!Character table for double representation
!Created by Thomas Aquino Ariasoca
!Modified by Muhammad Y. H. Widianto 2021. The Bethe symbols is used in SOC IR Ref: G. Koster, Solid State Phys. 5 (1957) 173-256

type(character_table) function get_dgroup_ctable&
(schname, status) result(ctab)
character(*), intent(in):: schname
logical, intent(out):: status
status = .true.
select case (trim(schname))
!---------------------Modified by M. Y.H. Widianto-----------------------------
case("C1")
100 ctab%nclass = 1
ctab%imrs(1)%name = "2" 		!B_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%numimr = 1
!------------------------------------------------------------------------------
case("C2")
ctab%nclass = 2
!ctab%imrs(1)%name = "e_{1/2}(2)"
ctab%imrs(1)%name = "3"
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, -1) !C2
!ctab%imrs(2)%name = "e_{1/2}(1)"
ctab%imrs(2)%name = "4"
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 1) !C2
ctab%numimr = 2
!---------------------Modified by M. Y.H. Widianto-----------------------------
!corrected Saito
case("C2h")
ctab%nclass = 4
ctab%imrs(1)%name = "3^+" 	!e_{1/2g}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, -1) !C_2(z)
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !i
ctab%imrs(1)%comp(4) = CMPLX_(0, -1) !{/Symbol s}_h
ctab%imrs(2)%name = "4^+"		!e_{1/2g}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0,1) !C_2(z)
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !i
ctab%imrs(2)%comp(4) = CMPLX_(0, 1) !{/Symbol s}_h
ctab%imrs(3)%name = "3^-"		!e_{1/2u}(1)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0,-1) !C_2(z)
ctab%imrs(3)%comp(3) = CMPLX_(-1, 0) !i
ctab%imrs(3)%comp(4) = CMPLX_(0,1) !{/Symbol s}_h
ctab%imrs(4)%name = "4^-"		!e_{1/2u}(2)
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(0, 1) !C_2(z)
ctab%imrs(4)%comp(3) = CMPLX_(-1, 0) !i
ctab%imrs(4)%comp(4) = CMPLX_(0, -1) !{/Symbol s}_h
ctab%numimr = 4
case("C2v")
ctab%nclass = 1
ctab%imrs(1)%name = "5"       !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !C_2(z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !{/Symbol s}_v(xz)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !{/Symbol s}_v(yz)
ctab%numimr = 1
case("C3")
ctab%nclass = 3
ctab%imrs(1)%name = "6"       !B_{3/2}
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !C3
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !(C3)^2
ctab%imrs(2)%name = "5"       !e_{1/2}(1)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(2)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !(C3)^2
ctab%imrs(3)%name = "4"       !e_{1/2}(2)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(3)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !(C3)^2
ctab%numimr = 3
case("C3h")
ctab%nclass = 6
ctab%imrs(1)%name = "11"           !e_{3/2}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !C3(z)
ctab%imrs(1)%comp(3) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !(S3)^5
ctab%imrs(1)%comp(5) = CMPLX_(1, 0) !{/synbol s}_h
ctab%imrs(1)%comp(6) = CMPLX_(-1, 0) !S3
ctab%imrs(2)%name = "12"           !e_{3/2}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1, 0) !C3(z)
ctab%imrs(2)%comp(3) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(2)%comp(4) = CMPLX_(-1, 0) !(S3)^5
ctab%imrs(2)%comp(5) = CMPLX_(-1, 0) !{/synbol s}_h
ctab%imrs(2)%comp(6) = CMPLX_(1, 0) !S3
ctab%imrs(3)%name = "7"           !e_{1/2}(1)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !C3(z)
ctab%imrs(3)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !(C3)^2
ctab%imrs(3)%comp(4) = CMPLX_(-0.5, -0.866025403784439) !(S3)^5
ctab%imrs(3)%comp(5) = CMPLX_(1, 0) !{/synbol s}_h
ctab%imrs(3)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !S3
ctab%imrs(4)%name = "8"           !e_{1/2}(2)
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !C3(z)
ctab%imrs(4)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !(C3)^2
ctab%imrs(4)%comp(4) = CMPLX_(0.5, 0.866025403784439) !(S3)^5
ctab%imrs(4)%comp(5) = CMPLX_(-1, 0) !{/synbol s}_h
ctab%imrs(4)%comp(6) = CMPLX_(0.5, -0.866025403784439) !S3
ctab%imrs(5)%name = "9"           !e_{5/2}(1)
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C3(z)
ctab%imrs(5)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !(C3)^2
ctab%imrs(5)%comp(4) = CMPLX_(-0.5, 0.866025403784439) !(S3)^5
ctab%imrs(5)%comp(5) = CMPLX_(1, 0) !{/synbol s}_h
ctab%imrs(5)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !S3
ctab%imrs(6)%name = "10"          !e_{5/2}(1)
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C3(z)
ctab%imrs(6)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !(C3)^2
ctab%imrs(6)%comp(4) = CMPLX_(0.5, -0.866025403784439) !(S3)^5
ctab%imrs(6)%comp(5) = CMPLX_(-1, 0) !{/synbol s}_h
ctab%imrs(6)%comp(6) = CMPLX_(0.5, 0.866025403784439) !S3
ctab%numimr = 6
case("C3v")
ctab%nclass = 3
ctab%imrs(1)%name = "4"          !e_{3/2}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !2C^3
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !3{/Synbol s}_v
ctab%imrs(2)%name = "5"           !e_{3/2}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1, 0) !2C^3
ctab%imrs(2)%comp(3) = CMPLX_(-1, 0) !3{/Synbol s}_v
ctab%imrs(3)%name = "6"           !E_{1/2}
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(1, 0) !2C^3
ctab%imrs(3)%comp(3) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%numimr = 3
case("C4")
ctab%nclass = 4
ctab%imrs(1)%name = "5"           !E_{1/2}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 1) !C2
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !C4
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !(C4)^3
ctab%imrs(2)%name = "6"           !E_{1/2}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, -1) !C2
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !C4
ctab%imrs(2)%comp(4) = CMPLX_(1, 0) !(C4)^3
ctab%imrs(3)%name = "7"           !E_{3/2}(1)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 1) !C2
ctab%imrs(3)%comp(3) = CMPLX_(-1, 0) !C4
ctab%imrs(3)%comp(4) = CMPLX_(-1, 0) !(C4)^3
ctab%imrs(4)%name = "8"            !E_{3/2}(2)
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-1, 0) !C2
ctab%imrs(4)%comp(3) = CMPLX_(-1, 0) !C4
ctab%imrs(4)%comp(4) = CMPLX_(-1, 0) !(C4)^3
ctab%numimr = 4
case("C4h")
ctab%nclass = 8
ctab%imrs(1)%name = "9^+"         !e_{1/2g}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !C4(z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 1) !C2
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !(C4)^3
ctab%imrs(1)%comp(5) = CMPLX_(1, 0) !i
ctab%imrs(1)%comp(6) = CMPLX_(1, 0) !(S4)^3
ctab%imrs(1)%comp(7) = CMPLX_(0, 1) !{/Synbol s}_h
ctab%imrs(1)%comp(8) = CMPLX_(1, 0) !S4
ctab%imrs(2)%name = "10^+"        !e_{1/2g}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(1, 0) !C4(z)
ctab%imrs(2)%comp(3) = CMPLX_(0, -1) !C2
ctab%imrs(2)%comp(4) = CMPLX_(1, 0) !(C4)^3
ctab%imrs(2)%comp(5) = CMPLX_(1, 0) !i
ctab%imrs(2)%comp(6) = CMPLX_(1, 0) !(S4)^3
ctab%imrs(2)%comp(7) = CMPLX_(0, -1) !{/Synbol s}_h
ctab%imrs(2)%comp(8) = CMPLX_(1, 0) !S4
ctab%imrs(3)%name = "11^+"
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 1) !C4(z)
ctab%imrs(3)%comp(3) = CMPLX_(-1, 0) !C2
ctab%imrs(3)%comp(4) = CMPLX_(0, -1) !(C4)^3
ctab%imrs(3)%comp(5) = CMPLX_(1, 0) !i
ctab%imrs(3)%comp(6) = CMPLX_(0, 1) !(S4)^3
ctab%imrs(3)%comp(7) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(3)%comp(8) = CMPLX_(0, -1) !S4
ctab%imrs(4)%name = "12+"
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(0, -1) !C4(z)
ctab%imrs(4)%comp(3) = CMPLX_(-1, 0) !C2
ctab%imrs(4)%comp(4) = CMPLX_(0, 1) !(C4)^3
ctab%imrs(4)%comp(5) = CMPLX_(1, 0) !i
ctab%imrs(4)%comp(6) = CMPLX_(0, -1) !(S4)^3
ctab%imrs(4)%comp(7) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(4)%comp(8) = CMPLX_(0, 1) !S4
ctab%imrs(5)%name = "9^-"
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(1, 0) !C4(z)
ctab%imrs(5)%comp(3) = CMPLX_(1, 0) !C2
ctab%imrs(5)%comp(4) = CMPLX_(1, 0) !(C4)^3
ctab%imrs(5)%comp(5) = CMPLX_(-1, 0) !i
ctab%imrs(5)%comp(6) = CMPLX_(-1, 0) !(S4)^3
ctab%imrs(5)%comp(7) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(5)%comp(8) = CMPLX_(-1, 0) !S4
ctab%imrs(6)%name = "10^-"
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-1, 0) !C4(z)
ctab%imrs(6)%comp(3) = CMPLX_(1, 0) !C2
ctab%imrs(6)%comp(4) = CMPLX_(-1, 0) !(C4)^3
ctab%imrs(6)%comp(5) = CMPLX_(-1, 0) !i
ctab%imrs(6)%comp(6) = CMPLX_(1, 0) !(S4)^3
ctab%imrs(6)%comp(7) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(6)%comp(8) = CMPLX_(1, 0) !S4
ctab%imrs(7)%name = "11^-"
ctab%imrs(7)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(7)%comp(2) = CMPLX_(0, 1) !C4(z)
ctab%imrs(7)%comp(3) = CMPLX_(-1, 0) !C2
ctab%imrs(7)%comp(4) = CMPLX_(0, -1) !(C4)^3
ctab%imrs(7)%comp(5) = CMPLX_(-1, 0) !i
ctab%imrs(7)%comp(6) = CMPLX_(0, -1) !(S4)^3
ctab%imrs(7)%comp(7) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(7)%comp(8) = CMPLX_(0, 1) !S4
ctab%imrs(8)%name = "12^-"
ctab%imrs(8)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(8)%comp(2) = CMPLX_(0, -1) !C4(z)
ctab%imrs(8)%comp(3) = CMPLX_(-1, 0) !C2
ctab%imrs(8)%comp(4) = CMPLX_(0, 1) !(C4)^3
ctab%imrs(8)%comp(5) = CMPLX_(-1, 0) !i
ctab%imrs(8)%comp(6) = CMPLX_(0, 1) !(S4)^3
ctab%imrs(8)%comp(7) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(8)%comp(8) = CMPLX_(0, -1) !S4
ctab%numimr = 8
case("C4v")
ctab%nclass = 2
ctab%imrs(1)%name = "6"           !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !C2
ctab%imrs(1)%comp(3) = CMPLX_(1.4142135624, 0) !2C4 (z)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(2)%name = "7"           !E_{3/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 0) !C2
ctab%imrs(2)%comp(3) = CMPLX_(-1.4142135624, 0) !2C4 (z)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%numimr = 2
case("C6")
ctab%nclass = 6
ctab%imrs(1)%name = "7"		!e_{3/2}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !C6
ctab%imrs(1)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(1)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(1)%comp(6) = CMPLX_(1, 0) !(C6)^5
ctab%imrs(2)%name = "8"		!e_{3/2}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(1, 0) !C6
ctab%imrs(2)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(2)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(2)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(2)%comp(6) = CMPLX_(-1, 0) !(C6)^5
ctab%imrs(3)%name = "9"		!e_{}
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C6
ctab%imrs(3)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !C3
ctab%imrs(3)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(3)%comp(5) = CMPLX_(-0.5, -0.866025403784439) !(C3)^2
ctab%imrs(3)%comp(6) = CMPLX_(0.5, -0.866025403784439) !(C6)^5
ctab%imrs(4)%name = "10"
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(0.5, -0.866025403784439) !C6
ctab%imrs(4)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !C3
ctab%imrs(4)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(4)%comp(5) = CMPLX_(-0.5, 0.866025403784439) !(C3)^2
ctab%imrs(4)%comp(6) = CMPLX_(0.5, 0.866025403784439) !(C6)^5
ctab%imrs(5)%name = "11"
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !C6
ctab%imrs(5)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !C3
ctab%imrs(5)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(5)%comp(5) = CMPLX_(-0.5, 0.866025403784439) !(C3)^2
ctab%imrs(5)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !(C6)^5
ctab%imrs(6)%name = "12"
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C6
ctab%imrs(6)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !C3
ctab%imrs(6)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(6)%comp(5) = CMPLX_(-0.5, -0.866025403784439) !(C3)^2
ctab%imrs(6)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !(C6)^5
ctab%numimr = 6
case("C6h")
ctab%nclass = 12
ctab%imrs(1)%name = "7^+"		!e_{3/2g}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !C6(z)
ctab%imrs(1)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(1)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(1)%comp(6) = CMPLX_(1, 0) !(C6)^5
ctab%imrs(1)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(1)%comp(8) = CMPLX_(-1, 0) !(S3)^5
ctab%imrs(1)%comp(9) = CMPLX_(-1, 0) !(S6)^5
ctab%imrs(1)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(1)%comp(11) = CMPLX_(-1, 0) !S6
ctab%imrs(1)%comp(12) = CMPLX_(1, 0) !S3
ctab%imrs(2)%name = "8^+"		!e_{3/2g}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(1, 0) !C6(z)
ctab%imrs(2)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(2)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(2)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(2)%comp(6) = CMPLX_(-1, 0) !(C6)^5
ctab%imrs(2)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(2)%comp(8) = CMPLX_(1, 0) !(S3)^5
ctab%imrs(2)%comp(9) = CMPLX_(-1, 0) !(S6)^5
ctab%imrs(2)%comp(10) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(2)%comp(11) = CMPLX_(-1, 0) !S6
ctab%imrs(2)%comp(12) = CMPLX_(-1, 0) !S3
ctab%imrs(3)%name = "9^+" 	!e_{1/2g}(1)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C6(z)
ctab%imrs(3)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(3)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(3)%comp(5) = CMPLX_(0.5, 0.866025403784439) !(C3)^2
ctab%imrs(3)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !(C6)^5
ctab%imrs(3)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(3)%comp(8) = CMPLX_(-0.5, -0.866025403784439) !(S3)^5
ctab%imrs(3)%comp(9) = CMPLX_(0.5, -0.866025403784439) !(S6)^5
ctab%imrs(3)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(3)%comp(11) = CMPLX_(0.5, 0.866025403784439) !S6
ctab%imrs(3)%comp(12) = CMPLX_(-0.5, 0.866025403784439) !S3
ctab%imrs(4)%name = "10^+"	!e_{1/2g}(2)
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !C6(z)
ctab%imrs(4)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(4)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(4)%comp(5) = CMPLX_(0.5, -0.866025403784439) !(C3)^2
ctab%imrs(4)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !(C6)^5
ctab%imrs(4)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(4)%comp(8) = CMPLX_(-0.5, 0.866025403784439) !(S3)^5
ctab%imrs(4)%comp(9) = CMPLX_(0.5, 0.866025403784439) !(S6)^5
ctab%imrs(4)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(4)%comp(11) = CMPLX_(0.5, -0.866025403784439) !S6
ctab%imrs(4)%comp(12) = CMPLX_(-0.5, -0.866025403784439) !S3
ctab%imrs(5)%name = "11^+"	!e_{5/2g}(1)
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(0.5, -0.866025403784439) !C6(z)
ctab%imrs(5)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(5)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(5)%comp(5) = CMPLX_(0.5, -0.866025403784439) !(C3)^2
ctab%imrs(5)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !(C6)^5
ctab%imrs(5)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(5)%comp(8) = CMPLX_(0.5, -0.866025403784439) !(S3)^5
ctab%imrs(5)%comp(9) = CMPLX_(0.5, 0.866025403784439) !(S6)^5
ctab%imrs(5)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(5)%comp(11) = CMPLX_(0.5, -0.866025403784439) !S6
ctab%imrs(5)%comp(12) = CMPLX_(0.5, 0.866025403784439) !S3
ctab%imrs(6)%name = "12^+"	!e_{5/2g}(2)
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C6(z)
ctab%imrs(6)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(6)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(6)%comp(5) = CMPLX_(0.5, 0.866025403784439) !(C3)^2
ctab%imrs(6)%comp(6) = CMPLX_(0.5, -0.866025403784439) !(C6)^5
ctab%imrs(6)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(6)%comp(8) = CMPLX_(-0.5, -0.866025403784439) !(S3)^5
ctab%imrs(6)%comp(9) = CMPLX_(0.5, -0.866025403784439) !(S6)^5
ctab%imrs(6)%comp(10) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(6)%comp(11) = CMPLX_(0.5, 0.866025403784439) !S6
ctab%imrs(6)%comp(12) = CMPLX_(0.5, -0.866025403784439) !S3
ctab%imrs(7)%name = "7^-"		!e_{3/2u}(1)
ctab%imrs(7)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(7)%comp(2) = CMPLX_(-1, 0) !C6(z)
ctab%imrs(7)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(7)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(7)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(7)%comp(6) = CMPLX_(1, 0) !(C6)^5
ctab%imrs(7)%comp(7) = CMPLX_(-1, 0) !i
ctab%imrs(7)%comp(8) = CMPLX_(1, 0) !(S3)^5
ctab%imrs(7)%comp(9) = CMPLX_(1, 0) !(S6)^5
ctab%imrs(7)%comp(10) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(7)%comp(11) = CMPLX_(1, 0) !S6
ctab%imrs(7)%comp(12) = CMPLX_(-1, 0) !S3
ctab%imrs(8)%name = "8^-"		!e_{3/2u}(2)
ctab%imrs(8)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(8)%comp(2) = CMPLX_(1, 0) !C6(z)
ctab%imrs(8)%comp(3) = CMPLX_(-1, 0) !C3
ctab%imrs(8)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(8)%comp(5) = CMPLX_(-1, 0) !(C3)^2
ctab%imrs(8)%comp(6) = CMPLX_(-1, 0) !(C6)^5
ctab%imrs(8)%comp(7) = CMPLX_(-1, 0) !i
ctab%imrs(8)%comp(8) = CMPLX_(-1, 0) !(S3)^5
ctab%imrs(8)%comp(9) = CMPLX_(1, 0) !(S6)^5
ctab%imrs(8)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(8)%comp(11) = CMPLX_(1, 0) !S6
ctab%imrs(8)%comp(12) = CMPLX_(1, 0) !S3
ctab%imrs(9)%name = "9^-"		!e_{1/2u}(1)
ctab%imrs(9)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(9)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !C6(z)
ctab%imrs(9)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(9)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(9)%comp(5) = CMPLX_(0.5, 0.866025403784439) !(C3)^2
ctab%imrs(9)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !(C6)^5
ctab%imrs(9)%comp(7) = CMPLX_(-1, 0) !i
ctab%imrs(9)%comp(8) = CMPLX_(0.5, 0.866025403784439) !(S3)^5
ctab%imrs(9)%comp(9) = CMPLX_(-0.5, 0.866025403784439) !(S6)^5
ctab%imrs(9)%comp(10) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(9)%comp(11) = CMPLX_(-0.5, -0.866025403784439) !S6
ctab%imrs(9)%comp(12) = CMPLX_(0.5, -0.86602) !S3
ctab%imrs(10)%name = "10^-"	!e_{1/2u}(2)
ctab%imrs(10)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(10)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !C6(z)
ctab%imrs(10)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(10)%comp(4) = CMPLX_(1, 0) !C2
ctab%imrs(10)%comp(5) = CMPLX_(0.5, -0.866025403784439) !(C3)^2
ctab%imrs(10)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !(C6)^5
ctab%imrs(10)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(10)%comp(8) = CMPLX_(0.5, -0.866025403784439) !(S3)^5
ctab%imrs(10)%comp(9) = CMPLX_(-0.5, -0.866025403784439) !(S6)^5
ctab%imrs(10)%comp(10) = CMPLX_(-1, 0) !{/Synbol s}_h
ctab%imrs(10)%comp(11) = CMPLX_(-0.5, 0.866025403784439) !S6
ctab%imrs(10)%comp(12) = CMPLX_(0.5, 0.866025403784439) !S3
ctab%imrs(11)%name = "11^-"	!e_{5/2u}(1)
ctab%imrs(11)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(11)%comp(2) = CMPLX_(0.5, -0.866025403784439) !C6(z)
ctab%imrs(11)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(11)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(11)%comp(5) = CMPLX_(0.5, -0.866025403784439) !(C3)^2
ctab%imrs(11)%comp(6) = CMPLX_(0.5, 0.866025403784439) !(C6)^5
ctab%imrs(11)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(11)%comp(8) = CMPLX_(-0.5, 0.866025403784439) !(S3)^5
ctab%imrs(11)%comp(9) = CMPLX_(-0.5, -0.866025403784439) !(S6)^5
ctab%imrs(11)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(11)%comp(11) = CMPLX_(-0.5, 0.866025403784439) !S6
ctab%imrs(11)%comp(12) = CMPLX_(-0.5, -0.866025403784439) !S3
ctab%imrs(12)%name = "12^-"	!e_{5/2u}(2)
ctab%imrs(12)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(12)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C6(z)
ctab%imrs(12)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(12)%comp(4) = CMPLX_(-1, 0) !C2
ctab%imrs(12)%comp(5) = CMPLX_(0.5, 0.866025403784439) !(C3)^2
ctab%imrs(12)%comp(6) = CMPLX_(0.5, -0.866025403784439) !(C6)^5
ctab%imrs(12)%comp(7) = CMPLX_(1, 0) !i
ctab%imrs(12)%comp(8) = CMPLX_(-0.5, -0.866025403784439) !(S3)^5
ctab%imrs(12)%comp(9) = CMPLX_(-0.5, 0.866025403784439) !(S6)^5
ctab%imrs(12)%comp(10) = CMPLX_(1, 0) !{/Synbol s}_h
ctab%imrs(12)%comp(11) = CMPLX_(-0.5, -0.866025403784439) !S6
ctab%imrs(12)%comp(12) = CMPLX_(-0.5, 0.866025403784439) !S3
ctab%numimr = 12
case("C6v")
ctab%nclass = 3
ctab%imrs(1)%name = "7"             !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.73205080756888, 0) !2C6 (z)
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !2C3 (z)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(2)%name = "8"             !E_{5/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.73205080756888, 0) !2C6 (z)
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !2C3 (z)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(3)%name = "9"           !E_{3/2}
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 0) !2C6 (z)
ctab%imrs(3)%comp(3) = CMPLX_(-2, 0) !2C3 (z)
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(3)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%numimr = 3
case("Ci")
ctab%nclass = 2
ctab%imrs(1)%name = "3"		!A_{1/2g}
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !I
ctab%imrs(2)%name = "4"		!A_{1/2u}
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1, 0) !I
ctab%numimr = 2
case("Cs")
ctab%nclass = 2
ctab%imrs(1)%name = "3"		!e_{1/2}(1)
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0,-1) !{/Synbol s}_h
ctab%imrs(2)%name = "4"		!e_{1/2}(2)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 1) !{/Synbol s}_h
ctab%numimr = 2
case("D2")
ctab%nclass = 1
ctab%imrs(1)%name = "5"		!E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !C2 (y)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !C2 (x)
ctab%numimr = 1
case("D2d")
ctab%nclass = 2
ctab%imrs(1)%name = "6"         !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.4142135624, 0) !2S4
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%imrs(2)%name = "7"         !E_{3/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.4142135624, 0) !2S4
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%numimr = 2
case("D2h")
ctab%nclass = 2
ctab%imrs(1)%name = "5^+"         !E_{1/2g}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !C2 (y)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !C2 (x)
ctab%imrs(1)%comp(5) = CMPLX_(2, 0) !i
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !{/Synbol s}(xy)
ctab%imrs(1)%comp(7) = CMPLX_(0, 0) !{/Synbol s}(yz)
ctab%imrs(1)%comp(8) = CMPLX_(0, 0) !{/Synbol s}(xz)
ctab%imrs(2)%name = "5^-"         !E_{1/2u}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !C2 (y)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !C2 (x)
ctab%imrs(2)%comp(5) = CMPLX_(-2, 0) !i
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !{/Synbol s}(xy)
ctab%imrs(2)%comp(7) = CMPLX_(0, 0) !{/Synbol s}(yz)
ctab%imrs(2)%comp(8) = CMPLX_(0, 0) !{/Synbol s}(xz)
ctab%numimr = 2
!------------------------------------------------------------------------------
case("D3")
ctab%nclass = 3
!ctab%imrs(1)%name = "E_{1/2}"
ctab%imrs(1)%name = "6"
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !2C_3(z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !3C'_2
!ctab%imrs(2)%name = "e_{3/2}(1)"
ctab%imrs(2)%name = "4"
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1, 0) !2C_3(z)
ctab%imrs(2)%comp(3) = CMPLX_(0, 1) !3C'_2
!ctab%imrs(3)%name = "e_{3/2}(2)"
ctab%imrs(3)%name = "5"
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-1, 0) !2C_3(z)
ctab%imrs(3)%comp(3) = CMPLX_(0, -1) !3C'_2
ctab%numimr = 3
case("D3d")
ctab%nclass = 6
!ctab%imrs(1)%name = "E_{1/2g}"
ctab%imrs(1)%name = "6^+"
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !2C_3
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !3C_2'
ctab%imrs(1)%comp(4) = CMPLX_(2, 0) !i
ctab%imrs(1)%comp(5) = CMPLX_(1, 0) !2S_6
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !3{/Symbol s}_d
!ctab%imrs(2)%name = "e_{3/2g}(1)"
ctab%imrs(2)%name = "4^+"
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1, 0) !2C_3
ctab%imrs(2)%comp(3) = CMPLX_(0, 1) !3C_2'
ctab%imrs(2)%comp(4) = CMPLX_(1, 0) !i
ctab%imrs(2)%comp(5) = CMPLX_(-1, 0) !2S_6
ctab%imrs(2)%comp(6) = CMPLX_(0, 1) !3{/Symbol s}_d
!ctab%imrs(3)%name = "e_{3/2g}(2)"
ctab%imrs(3)%name = "5^+"
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-1, 0) !2C_3
ctab%imrs(3)%comp(3) = CMPLX_(0, -1) !3C_2'
ctab%imrs(3)%comp(4) = CMPLX_(1, 0) !i
ctab%imrs(3)%comp(5) = CMPLX_(-1, 0) !2S_6
ctab%imrs(3)%comp(6) = CMPLX_(0, -1) !3{/Symbol s}_d
!ctab%imrs(4)%name = "E_{1/2u}"
ctab%imrs(4)%name = "6^-"
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(1, 0) !2C_3
ctab%imrs(4)%comp(3) = CMPLX_(0, 0) !3C_2'
ctab%imrs(4)%comp(4) = CMPLX_(-2, 0) !i
ctab%imrs(4)%comp(5) = CMPLX_(-1, 0) !2S_6
ctab%imrs(4)%comp(6) = CMPLX_(0, 0) !3{/Symbol s}_d
!ctab%imrs(5)%name = "e_{3/2u}(1)"
ctab%imrs(5)%name = "4^-"
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(-1, 0) !2C_3
ctab%imrs(5)%comp(3) = CMPLX_(0, 1) !3C_2'
ctab%imrs(5)%comp(4) = CMPLX_(-1, 0) !i
ctab%imrs(5)%comp(5) = CMPLX_(1, 0) !2S_6
ctab%imrs(5)%comp(6) = CMPLX_(0, -1) !3{/Symbol s}_d
!ctab%imrs(6)%name = "e_{3/2u}(2)"
ctab%imrs(6)%name = "5^-"
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-1, 0) !2C_3
ctab%imrs(6)%comp(3) = CMPLX_(0, -1) !3C_2'
ctab%imrs(6)%comp(4) = CMPLX_(-1, 0) !i
ctab%imrs(6)%comp(5) = CMPLX_(1, 0) !2S_6
ctab%imrs(6)%comp(6) = CMPLX_(0, 1) !3{/Symbol s}_d
ctab%numimr = 6
!---------------------Modified by M. Y.H. Widianto-----------------------------
case("D3h")
ctab%nclass = 3
ctab%imrs(1)%name = "7"            !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !2C3
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !3C'2
ctab%imrs(1)%comp(4) = CMPLX_(1.73205080756888, 0) !2S3
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(2)%name = "8"           !E_{5/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(1, 0) !2C3
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !3C'2
ctab%imrs(2)%comp(4) = CMPLX_(-1.73205080756888, 0) !2S3
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(3)%name = "9"           !E_{3/2}
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-2, 0) !2C3
ctab%imrs(3)%comp(3) = CMPLX_(0, 0) !3C'2
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !2S3
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(3)%comp(6) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%numimr = 3
case("D4")
ctab%nclass = 2
ctab%imrs(1)%name = "6"		!E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.4142135624, 0) !2C4 (z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%imrs(2)%name = "7"		!E_{3/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.4142135624, 0) !2C4 (z)
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%numimr = 2
case("D4d")
ctab%nclass = 4
ctab%imrs(1)%name = "8"
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0.3826834324, 0) !2S8
ctab%imrs(1)%comp(3) = CMPLX_(1.4142135624, 0) !2C4
ctab%imrs(1)%comp(4) = CMPLX_(0.9238795325, 0) !2(S8)3
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !C2
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !4C'2
ctab%imrs(1)%comp(7) = CMPLX_(0, 0) !4Ïƒd
ctab%imrs(2)%name = "9"
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-0.9238795325, 0) !2S8
ctab%imrs(2)%comp(3) = CMPLX_(-1.4142135624, 0) !2C4
ctab%imrs(2)%comp(4) = CMPLX_(0.3826834324, 0) !2(S8)3
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !C2
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !4C'2
ctab%imrs(2)%comp(7) = CMPLX_(0, 0) !4Ïƒd
ctab%imrs(3)%name = "10"
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0.9238795325, 0) !2S8
ctab%imrs(3)%comp(3) = CMPLX_(-1.4142135624, 0) !2C4
ctab%imrs(3)%comp(4) = CMPLX_(-0.3826834324, 0) !2(S8)3
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !C2
ctab%imrs(3)%comp(6) = CMPLX_(0, 0) !4C'2
ctab%imrs(3)%comp(7) = CMPLX_(0, 0) !4Ïƒd
ctab%imrs(4)%name = "11"
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-0.3826834324, 0) !2S8
ctab%imrs(4)%comp(3) = CMPLX_(1.4142135624, 0) !2C4
ctab%imrs(4)%comp(4) = CMPLX_(-0.9238795325, 0) !2(S8)3
ctab%imrs(4)%comp(5) = CMPLX_(0, 0) !C2
ctab%imrs(4)%comp(6) = CMPLX_(0, 0) !4C'2
ctab%imrs(4)%comp(7) = CMPLX_(0, 0) !4Ïƒd
ctab%numimr = 4
case("D4h")
ctab%nclass = 4
ctab%imrs(1)%name = "6^+"         !E_{1/2g}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.4142135623731, 0) !2C4 (z)
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !C2
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%imrs(1)%comp(6) = CMPLX_(2, 0) !i
ctab%imrs(1)%comp(7) = CMPLX_(1.4142135623731, 0) !2S4
ctab%imrs(1)%comp(8) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(1)%comp(9) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(1)%comp(10) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%imrs(2)%name = "7^+"         !E_{3/2g}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.4142135623731, 0) !2C4 (z)
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !C2
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%imrs(2)%comp(6) = CMPLX_(2, 0) !i
ctab%imrs(2)%comp(7) = CMPLX_(-1.4142135623731, 0) !2S4
ctab%imrs(2)%comp(8) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(2)%comp(9) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(2)%comp(10) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%imrs(3)%name = "6^-"         !E_{1/2u}
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(1.4142135623731, 0) !2C4 (z)
ctab%imrs(3)%comp(3) = CMPLX_(0, 0) !C2
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%imrs(3)%comp(6) = CMPLX_(-2, 0) !i
ctab%imrs(3)%comp(7) = CMPLX_(-1.4142135623731, 0) !2S4
ctab%imrs(3)%comp(8) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(3)%comp(9) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(3)%comp(10) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%imrs(4)%name = "7^-"         !E_{3/2u}
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-1.4142135623731, 0) !2C4 (z)
ctab%imrs(4)%comp(3) = CMPLX_(0, 0) !C2
ctab%imrs(4)%comp(4) = CMPLX_(0, 0) !2C'2
ctab%imrs(4)%comp(5) = CMPLX_(0, 0) !2C''2
ctab%imrs(4)%comp(6) = CMPLX_(-2, 0) !i
ctab%imrs(4)%comp(7) = CMPLX_(1.4142135623731, 0) !2S4
ctab%imrs(4)%comp(8) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(4)%comp(9) = CMPLX_(0, 0) !2{/Synbol s}_v
ctab%imrs(4)%comp(10) = CMPLX_(0, 0) !2{/Synbol s}_d
ctab%numimr = 4
case("D6")
ctab%nclass = 3
ctab%imrs(1)%name = "7"		!E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.73205080756888, 0) !2C6 (z)
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !2C3 (z)
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(2)%name = "8"		!E_{3/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.73205080756888, 0) !2C6 (z)
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !2C3 (z)
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(3)%name = "9"		!E_{5/2}
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 0) !2C6 (z)
ctab%imrs(3)%comp(3) = CMPLX_(-2, 0) !2C3 (z)
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !C2 (z)
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(3)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%numimr = 3
case("D6d")
ctab%nclass = 6
ctab%imrs(1)%name = "10"
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0.2588190451, 0) !2S12
ctab%imrs(1)%comp(3) = CMPLX_(1.73205080757, 0) !2C6
ctab%imrs(1)%comp(4) = CMPLX_(1.41421356237, 0) !2S4
ctab%imrs(1)%comp(5) = CMPLX_(1, 0) !2C3
ctab%imrs(1)%comp(6) = CMPLX_(0.96592582628, 0) !2(S12)5
ctab%imrs(1)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(1)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(1)%comp(9) = CMPLX_(0, 0) !6Ïƒd
ctab%imrs(2)%name = "11"
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.41421356237, 0) !2S12
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !2C6
ctab%imrs(2)%comp(4) = CMPLX_(-1.41421356237, 0) !2S4
ctab%imrs(2)%comp(5) = CMPLX_(-2, 0) !2C3
ctab%imrs(2)%comp(6) = CMPLX_(1.41421356237, 0) !2(S12)5
ctab%imrs(2)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(2)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(2)%comp(9) = CMPLX_(0, 0) !6Ïƒd
ctab%imrs(3)%name = "12"
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0.9659258262, 0) !2S12
ctab%imrs(3)%comp(3) = CMPLX_(-1.73205080757, 0) !2C6
ctab%imrs(3)%comp(4) = CMPLX_(-1.41421356237, 0) !2S4
ctab%imrs(3)%comp(5) = CMPLX_(1, 0) !2C3
ctab%imrs(3)%comp(6) = CMPLX_(0.258819045, 0) !2(S12)5
ctab%imrs(3)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(3)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(3)%comp(9) = CMPLX_(-1, 0) !6Ïƒd
ctab%imrs(4)%name = "13"
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-0.965925826, 0) !2S12
ctab%imrs(4)%comp(3) = CMPLX_(-1.73205080757, 0) !2C6
ctab%imrs(4)%comp(4) = CMPLX_(-1.41421356237, 0) !2S4
ctab%imrs(4)%comp(5) = CMPLX_(1, 0) !2C3
ctab%imrs(4)%comp(6) = CMPLX_(-0.258819045, 0) !2(S12)5
ctab%imrs(4)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(4)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(4)%comp(9) = CMPLX_(0, 0) !6Ïƒd
ctab%imrs(5)%name = "14"
ctab%imrs(5)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(1.4142135623, 0) !2S12
ctab%imrs(5)%comp(3) = CMPLX_(0, 0) !2C6
ctab%imrs(5)%comp(4) = CMPLX_(1.4142135623, 0) !2S4
ctab%imrs(5)%comp(5) = CMPLX_(-2, 0) !2C3
ctab%imrs(5)%comp(6) = CMPLX_(-1.4142135623, 0) !2(S12)5
ctab%imrs(5)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(5)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(5)%comp(9) = CMPLX_(0, 0) !6Ïƒd
ctab%imrs(6)%name = "15"
ctab%imrs(6)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-0.258819045, 0) !2S12
ctab%imrs(6)%comp(3) = CMPLX_(1.7320508075, 0) !2C6
ctab%imrs(6)%comp(4) = CMPLX_(-1.4142135623, 0) !2S4
ctab%imrs(6)%comp(5) = CMPLX_(1, 0) !2C3
ctab%imrs(6)%comp(6) = CMPLX_(-0.965925826, 0) !2(S12)5
ctab%imrs(6)%comp(7) = CMPLX_(0, 0) !C2
ctab%imrs(6)%comp(8) = CMPLX_(0, 0) !6C'2
ctab%imrs(6)%comp(9) = CMPLX_(0, 0) !6Ïƒd
ctab%numimr = 6
case("D6h")
ctab%nclass = 6
ctab%imrs(1)%name = "7^+"
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.73205080756888, 0) !2C6
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !2C3
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(1)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(1)%comp(7) = CMPLX_(2, 0) !i
ctab%imrs(1)%comp(8) = CMPLX_(1.73205080756888, 0) !2S3
ctab%imrs(1)%comp(9) = CMPLX_(1, 0) !2S6
ctab%imrs(1)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(1)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(1)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(2)%name = "7^-"
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(1.73205080756888, 0) !2C6
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !2C3
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(2)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(2)%comp(7) = CMPLX_(-2, 0) !i
ctab%imrs(2)%comp(8) = CMPLX_(-1.73205080756888, 0) !2S3
ctab%imrs(2)%comp(9) = CMPLX_(-1, 0) !2S6
ctab%imrs(2)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(2)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(2)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(3)%name = "8^+"
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-1.73205080756888, 0) !2C6
ctab%imrs(3)%comp(3) = CMPLX_(1, 0) !2C3
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(3)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(3)%comp(7) = CMPLX_(2, 0) !i
ctab%imrs(3)%comp(8) = CMPLX_(-1.73205080756888, 0) !2S3
ctab%imrs(3)%comp(9) = CMPLX_(1, 0) !2S6
ctab%imrs(3)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(3)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(3)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(4)%name = "8^-"
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-1.73205080756888, 0) !2C6
ctab%imrs(4)%comp(3) = CMPLX_(1, 0) !2C3
ctab%imrs(4)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(4)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(4)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(4)%comp(7) = CMPLX_(-2, 0) !i
ctab%imrs(4)%comp(8) = CMPLX_(1.73205080756888, 0) !2S3
ctab%imrs(4)%comp(9) = CMPLX_(-1, 0) !2S6
ctab%imrs(4)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(4)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(4)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(5)%name = "9^+"
ctab%imrs(5)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(0, 0) !2C6
ctab%imrs(5)%comp(3) = CMPLX_(-2, 0) !2C3
ctab%imrs(5)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(5)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(5)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(5)%comp(7) = CMPLX_(2, 0) !i
ctab%imrs(5)%comp(8) = CMPLX_(0, 0) !2S3
ctab%imrs(5)%comp(9) = CMPLX_(-2, 0) !2S6
ctab%imrs(5)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(5)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(5)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%imrs(6)%name = "9^-"
ctab%imrs(6)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(0, 0) !2C6
ctab%imrs(6)%comp(3) = CMPLX_(-2, 0) !2C3
ctab%imrs(6)%comp(4) = CMPLX_(0, 0) !C2
ctab%imrs(6)%comp(5) = CMPLX_(0, 0) !3C'2
ctab%imrs(6)%comp(6) = CMPLX_(0, 0) !3C''2
ctab%imrs(6)%comp(7) = CMPLX_(-2, 0) !i
ctab%imrs(6)%comp(8) = CMPLX_(0, 0) !2S3
ctab%imrs(6)%comp(9) = CMPLX_(2, 0) !2S6
ctab%imrs(6)%comp(10) = CMPLX_(0, 0) !{/Synbol s}_h
ctab%imrs(6)%comp(11) = CMPLX_(0, 0) !3{/Synbol s}_d
ctab%imrs(6)%comp(12) = CMPLX_(0, 0) !3{/Synbol s}_v
ctab%numimr = 6
case("O")
ctab%nclass = 3
ctab%imrs(1)%name = "6"		!E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1.4142135624, 0) !6C4
ctab%imrs(1)%comp(3) = CMPLX_(0, 0) !3C2
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !8C3
ctab%imrs(1)%comp(5) = CMPLX_(0, 0) !6C2
ctab%imrs(2)%name = "7"		!E_{5/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-1.4142135624, 0) !6C4
ctab%imrs(2)%comp(3) = CMPLX_(0, 0) !3C2
ctab%imrs(2)%comp(4) = CMPLX_(1, 0) !8C3
ctab%imrs(2)%comp(5) = CMPLX_(0, 0) !6C2
ctab%imrs(3)%name = "8"		!F_{3/2}
ctab%imrs(3)%comp(1) = CMPLX_(4, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 0) !6C4
ctab%imrs(3)%comp(3) = CMPLX_(0, 0) !3C2
ctab%imrs(3)%comp(4) = CMPLX_(-1, 0) !8C3
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !6C2
ctab%numimr = 3
case("Oh")
ctab%nclass = 6
ctab%imrs(1)%name = "6^+"       !E_{1/2g}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(1)%comp(5) = CMPLX_(1.414213562, 0) !6C4
ctab%imrs(1)%comp(6) = CMPLX_(2, 0) !I
ctab%imrs(1)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(1)%comp(8) = CMPLX_(1, 0) !8S6
ctab%imrs(1)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(1)%comp(10) = CMPLX_(1.414213562, 0) !6S4
ctab%imrs(2)%name = "7^+"       !E_{5/2g}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(2)%comp(5) = CMPLX_(-1.414213562, 0) !6C4
ctab%imrs(2)%comp(6) = CMPLX_(2, 0) !I
ctab%imrs(2)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(2)%comp(8) = CMPLX_(1, 0) !8S6
ctab%imrs(2)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(2)%comp(10) = CMPLX_(-1.414213562, 0) !6S4
ctab%imrs(3)%name = "8^+"         !G_{3/2g}
ctab%imrs(3)%comp(1) = CMPLX_(4, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(3)%comp(3) = CMPLX_(-1, 0) !8C3
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !6C4
ctab%imrs(3)%comp(6) = CMPLX_(4, 0) !I
ctab%imrs(3)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(3)%comp(8) = CMPLX_(-1, 0) !8S6
ctab%imrs(3)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(3)%comp(10) = CMPLX_(0, 0) !6S4
ctab%imrs(4)%name = "6^-"         !E_{1/2u}
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(4)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(4)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(4)%comp(5) = CMPLX_(1.414213562, 0) !6C4
ctab%imrs(4)%comp(6) = CMPLX_(-2, 0) !I
ctab%imrs(4)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(4)%comp(8) = CMPLX_(-1, 0) !8S6
ctab%imrs(4)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(4)%comp(10) = CMPLX_(-1.414213562, 0) !6S4
ctab%imrs(5)%name = "7^-"         !E_{5/2u}
ctab%imrs(5)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(5)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(5)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(5)%comp(5) = CMPLX_(-1.414213562, 0) !6C4
ctab%imrs(5)%comp(6) = CMPLX_(-2, 0) !I
ctab%imrs(5)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(5)%comp(8) = CMPLX_(-1, 0) !8S6
ctab%imrs(5)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(5)%comp(10) = CMPLX_(1.414213562, 0) !6S4
ctab%imrs(6)%name = "8^-"         !G_{3/2u}
ctab%imrs(6)%comp(1) = CMPLX_(4, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(6)%comp(3) = CMPLX_(-1, 0) !8C3
ctab%imrs(6)%comp(4) = CMPLX_(0, 0) !6C2
ctab%imrs(6)%comp(5) = CMPLX_(0, 0) !6C4
ctab%imrs(6)%comp(6) = CMPLX_(-4, 0) !I
ctab%imrs(6)%comp(7) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(6)%comp(8) = CMPLX_(1, 0) !8S6
ctab%imrs(6)%comp(9) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(6)%comp(10) = CMPLX_(0, 0) !6S4
ctab%numimr = 6
case("S4")
ctab%nclass = 4
ctab%imrs(1)%name = "5"
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0.70710678118, -0.70710678118) !S4
ctab%imrs(1)%comp(3) = CMPLX_(0,-1) !C2
ctab%imrs(1)%comp(4) = CMPLX_(-0.70710678118, -0.70710678118) !(S4)3
ctab%imrs(2)%name = "6"
ctab%imrs(2)%comp(1) = CMPLX_(1,0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0.70710678118, 0.70710678118) !S4
ctab%imrs(2)%comp(3) = CMPLX_(0, 1) !C2
ctab%imrs(2)%comp(4) = CMPLX_(-0.70710678118, 0.70710678118) !(S4)3
ctab%imrs(3)%name = "7"
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-0.70710678118, 0.70710678118) !S4
ctab%imrs(3)%comp(3) = CMPLX_(0,-1) !C2
ctab%imrs(3)%comp(4) = CMPLX_(0.70710678118, 0.70710678118 ) !(S4)3
ctab%imrs(4)%name = "8"
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_( -0.70710678118, -0.70710678118) !S4
ctab%imrs(4)%comp(3) = CMPLX_(0, 1) !C2
ctab%imrs(4)%comp(4) = CMPLX_(0.70710678118, -0.70710678118) !(S4)3
ctab%numimr = 4
case("S6")
ctab%nclass = 6
ctab%imrs(1)%name = "4^+" 	!A_{3/2g}
ctab%imrs(1)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(-1, 0) !C3
ctab%imrs(1)%comp(3) = CMPLX_(-1, 0) !C3^2
ctab%imrs(1)%comp(4) = CMPLX_(1, 0) !i
ctab%imrs(1)%comp(5) = CMPLX_(-1, 0) !S6^5
ctab%imrs(1)%comp(6) = CMPLX_(-1, 0) !S6
ctab%imrs(2)%name = "5^+" 	!E_{1/2g}(1)
ctab%imrs(2)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(2)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3^2
ctab%imrs(2)%comp(4) = CMPLX_(1, 0) !i
ctab%imrs(2)%comp(5) = CMPLX_(0.5, -0.866025403784439) !S6^5
ctab%imrs(2)%comp(6) = CMPLX_(0.5, 0.866025403784439) !S6
ctab%imrs(3)%name = "6^+" 	!E_{1/2g}(2)
ctab%imrs(3)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(3)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3^2
ctab%imrs(3)%comp(4) = CMPLX_(1, 0) !i
ctab%imrs(3)%comp(5) = CMPLX_(0.5, 0.866025403784439) !S6^5
ctab%imrs(3)%comp(6) = CMPLX_(0.5, -0.866025403784439) !S6
ctab%imrs(4)%name = "4^-"		!A_{3/2u}
ctab%imrs(4)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(-1, 0) !C3
ctab%imrs(4)%comp(3) = CMPLX_(-1, 0) !C3^2
ctab%imrs(4)%comp(4) = CMPLX_(-1, 0) !i
ctab%imrs(4)%comp(5) = CMPLX_(1, 0) !S6^5
ctab%imrs(4)%comp(6) = CMPLX_(1, 0) !S6
ctab%imrs(5)%name = "5^-"		!E_{1/2u}(1)
ctab%imrs(5)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(0.5, -0.866025403784439) !C3
ctab%imrs(5)%comp(3) = CMPLX_(0.5, 0.866025403784439) !C3^2
ctab%imrs(5)%comp(4) = CMPLX_(-1, 0) !i
ctab%imrs(5)%comp(5) = CMPLX_(-0.5, 0.866025403784439) !S6^5
ctab%imrs(5)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !S6
ctab%imrs(6)%name = "6^-"		!E_{1/2u}(2)
ctab%imrs(6)%comp(1) = CMPLX_(1, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(0.5, 0.866025403784439) !C3
ctab%imrs(6)%comp(3) = CMPLX_(0.5, -0.866025403784439) !C3^2
ctab%imrs(6)%comp(4) = CMPLX_(-1, 0) !i
ctab%imrs(6)%comp(5) = CMPLX_(-0.5, -0.866025403784439) !S6^5
ctab%imrs(6)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !S6
ctab%numimr = 6
case("T")
ctab%nclass = 3
ctab%imrs(1)%name = "5"		!E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !4C3
ctab%imrs(1)%comp(3) = CMPLX_(-1, 0) !4C3^2
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(2)%name = "6"		!f_{3/2}(1)
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !4C3
ctab%imrs(2)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !4C3^2
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(3)%name = "7"		!f_{3/2}(2)
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !4C3
ctab%imrs(3)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !4C3^2
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !3C2
ctab%numimr = 3
case("Td")
ctab%nclass = 3
ctab%imrs(1)%name = "6"           !E_{1/2}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(1)%comp(5) = CMPLX_(1.4142135624, 0) !6S4
ctab%imrs(2)%name = "7"           !E_{5/2}
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(2)%comp(3) = CMPLX_(1, 0) !8C3
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(2)%comp(5) = CMPLX_(-1.4142135624, 0) !6S4
ctab%imrs(3)%name = "8"           !F_{3/2}
ctab%imrs(3)%comp(1) = CMPLX_(4, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(0, 0) !3C2
ctab%imrs(3)%comp(3) = CMPLX_(-1, 0) !8C3
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !6{/Synbol s}_d
ctab%imrs(3)%comp(5) = CMPLX_(0, 0) !6S4
ctab%numimr = 3
case("Th")
ctab%nclass = 6
ctab%imrs(1)%name = "5^+"         !E_{1/2g}
ctab%imrs(1)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(1)%comp(2) = CMPLX_(1, 0) !4C3
ctab%imrs(1)%comp(3) = CMPLX_(1, 0) !4C3^2
ctab%imrs(1)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(1)%comp(5) = CMPLX_(2, 0) !I
ctab%imrs(1)%comp(6) = CMPLX_(1, 0) !4S6
ctab%imrs(1)%comp(7) = CMPLX_(1, 0) !4S6^5
ctab%imrs(1)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(2)%name = "6^+"         !F_{3/2g} (1)
ctab%imrs(2)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(2)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !4C3
ctab%imrs(2)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !4C3^2
ctab%imrs(2)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(2)%comp(5) = CMPLX_(2, 0) !I
ctab%imrs(2)%comp(6) = CMPLX_(-0.5, 0.866025403784439) !4S6
ctab%imrs(2)%comp(7) = CMPLX_(-0.5, -0.866025403784439) !4S6^5
ctab%imrs(2)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(3)%name = "7^+"         !E_{3/2g}(2)
ctab%imrs(3)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(3)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !4C3
ctab%imrs(3)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !4C3^2
ctab%imrs(3)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(3)%comp(5) = CMPLX_(2, 0) !I
ctab%imrs(3)%comp(6) = CMPLX_(-0.5, -0.866025403784439) !4S6
ctab%imrs(3)%comp(7) = CMPLX_(-0.5, 0.866025403784439) !4S6^5
ctab%imrs(3)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(4)%name = "5^-"         !E_{1/2u}
ctab%imrs(4)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(4)%comp(2) = CMPLX_(1, 0) !4C3
ctab%imrs(4)%comp(3) = CMPLX_(1, 0) !4C3^2
ctab%imrs(4)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(4)%comp(5) = CMPLX_(-2, 0) !I
ctab%imrs(4)%comp(6) = CMPLX_(-1, 0) !4S6
ctab%imrs(4)%comp(7) = CMPLX_(-1, 0) !4S6^5
ctab%imrs(4)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(5)%name = "6^-"         !F_{3/2u}(1)
ctab%imrs(5)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(5)%comp(2) = CMPLX_(-0.5, 0.866025403784439) !4C3
ctab%imrs(5)%comp(3) = CMPLX_(-0.5, -0.866025403784439) !4C3^2
ctab%imrs(5)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(5)%comp(5) = CMPLX_(-2, 0) !I
ctab%imrs(5)%comp(6) = CMPLX_(0.5, -0.866025403784439) !4S6
ctab%imrs(5)%comp(7) = CMPLX_(0.5, 0.866025403784439) !4S6^5
ctab%imrs(5)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%imrs(6)%name = "7^-"         !F_{3/2u}(2)
ctab%imrs(6)%comp(1) = CMPLX_(2, 0) !E
ctab%imrs(6)%comp(2) = CMPLX_(-0.5, -0.866025403784439) !4C3
ctab%imrs(6)%comp(3) = CMPLX_(-0.5, 0.866025403784439) !4C3^2
ctab%imrs(6)%comp(4) = CMPLX_(0, 0) !3C2
ctab%imrs(6)%comp(5) = CMPLX_(-2, 0) !I
ctab%imrs(6)%comp(6) = CMPLX_(0.5, 0.866025403784439) !4S6
ctab%imrs(6)%comp(7) = CMPLX_(0.5, -0.866025403784439) !4S6^5
ctab%imrs(6)%comp(8) = CMPLX_(0, 0) !3{/Synbol s}_h
ctab%numimr = 6
!------------------------------------------------------------------------------
case default
status = .false.
go to 100
end select
end function get_dgroup_ctable
