/**
 * \license This project is released under the BSD 2-clause license
 *
 * Copyright (C) 2014 Xevolver Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* ׻åѷ C*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FFTW_ASL_INCLUDED
#include "fftw_asl.h"
#endif

#ifndef UTIL_INCLUDED
#include "util.h"
#endif

#ifdef ENABLE_FLOAT
#define COMPLEX Complex8
#define ASL1D ASL_cfc1fb
#define ASL2D ASL_cfc2fb
#define ASL3D ASL_cfc3fb
#else
#define COMPLEX Complex16
#define ASL1D ASL_zfc1fb
#define ASL2D ASL_zfc2fb
#define ASL3D ASL_zfc3fb
#endif

/* C */
void fftw_execute(struct fftw_plan *plan)
{
  struct fftw_plan *plan_p = plan;
  /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
  /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
  COMPLEX asl_wk[plan_p->asl_n1 * plan_p->asl_n2 * plan_p->asl_n3];
  Int32 asl_ifax[60];
  double asl_trigs[2 * (plan_p->asl_n1 + plan_p->asl_n2 + plan_p->asl_n3)];
  Int32    asl_err;                            /* 顼ǥ */
  Int32    asl_isw;    /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

  /* ץƤ asl_flags Ф -1 (Ԥʤ) */
  if (plan_p->asl_flags != NOEFFECT)
  {
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  /* ASLFFTWѴб */
  asl_isw = __FFTWR_fftw_to_asl_flag(plan_p->asl_fbflag);

  switch (plan_p->asl_plan_type)
  {
  case FFTW_PLAN_DFT_1D :
    /* ʣ1 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*sizeof(COMPLEX));
    }

    asl_err = ASL1D(plan_p->asl_n1, plan_p->asl_outdt, plan_p->asl_n1,
                          asl_isw, asl_ifax, asl_trigs, asl_wk);
    break ;

  case FFTW_PLAN_DFT_2D :
    /* ʣ2 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*
                                                   plan_p->asl_n2*sizeof(COMPLEX));
    }
    asl_err = ASL2D(plan_p->asl_n2, plan_p->asl_n1, plan_p->asl_outdt,
                          plan_p->asl_n2, plan_p->asl_n1, asl_isw,
                          asl_ifax, asl_trigs, asl_wk);
    break ;

  case FFTW_PLAN_DFT_3D :
    /* ʣ3 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*
                                                   plan_p->asl_n2*
                                                   plan_p->asl_n3*sizeof(COMPLEX));
    }
    asl_err = ASL3D(plan_p->asl_n3, plan_p->asl_n2, plan_p->asl_n1,
                          plan_p->asl_outdt, plan_p->asl_n3, plan_p->asl_n2,
                          plan_p->asl_n1, asl_isw, asl_ifax, asl_trigs, asl_wk);
    break ;

  default :
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  __FFTWR_check_asl_error(asl_err);

  return ;
}
