!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  MAIN PROGRAM: CPMD
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
program CPMD
! $Id: mdepmain.f90 334 2013-07-18 14:15:28Z yamasaki $
  implicit none
  logical  :: Forces_are_Converged, Ending_Time, MultiReplicaMode &
       &     ,AllForces_are_Converged

  call Initialization
  call InputData_Analysis
  MultiReplica: do
     call Preparation_ep
     call Initial_MD_Condition

     AtomicConfiguration: do
        call Forces
        if(Forces_are_Converged()) exit AtomicConfiguration
        call Move_Ions
        if(Ending_Time())          exit AtomicConfiguration
        call MDIterationNumber_Setting_ep
     enddo AtomicConfiguration

     call WriteDownData_onto_Files

     if(.not.MultiReplicaMode()) then
        exit MultiReplica
     else if( Ending_Time() .or. AllForces_are_Converged()) then
        exit MultiReplica
     end if

  end do MultiReplica

end program CPMD
