! =================================== added by K. Tagami =========== 5.0
subroutine Renewal_of_Chg_Ctrl_Param

  use m_Const_Parameters,    only  : DP, ON, OFF, YES
  use m_Total_Energy,         only : m_TE_what_is_edeltb_now
  use m_Ionic_System,        only : natm
  use m_Control_Parameters,  only : sw_eval_energy_before_charge, &
       &                            sw_update_charge_total, spin_density_mixfactor
!
  use m_Const_Parameters,  only : MSD, CG, SD, LMSD, LMCG,lmeazyCG, lmmsd
  use m_Control_Parameters,  only :  m_CtrlP_solver_for_WFs_now, intzaj

  use  m_IterationNumbers,    only : iteration, iteration_ionic, iteration_electronic

  use m_Control_Parameters,       only : sw_update_charge_hsr, eval_energy_before_charge
  use m_Control_Parameters,     only : sw_recomposing, sw_force_simple_mixing
  use m_Control_Parameters,     only : sw_recomposing_hsr, sw_force_simple_mixing_hsr

  use m_Files,               only : nfout
  use m_Control_Parameters,   only : printable

  implicit none

!
  real(kind=DP) :: edeltab_per_atom, edeltb_per_atom
  edeltab_per_atom = m_TE_what_is_edeltb_now() / natm
  edeltab_per_atom = abs(edeltab_per_atom )

!
!  call update_or_fix_charge
!  call update_or_fix_charge_hardpart
!
  if ( eval_energy_before_charge == YES ) then
    call order_energy_chg_construction
  endif

!  call update_spin_density_mixfactor
!   call update_spin_recomposing

contains

  subroutine update_spin_recomposing
    logical, save :: first = .true.
    integer :: nstep_threshold = 15 

    integer :: sw_recomposing0 = OFF
    integer :: sw_force_simple_mixing0 = OFF
!
    if ( first ) then
       sw_recomposing0 = sw_recomposing
       sw_force_simple_mixing0 = sw_force_simple_mixing
       first = .false.
    endif
!
    if ( sw_recomposing0 == ON ) then
       if ( iteration <= nstep_threshold ) then
          sw_recomposing = ON
          sw_force_simple_mixing = ON
          sw_recomposing_hsr = ON
          sw_force_simple_mixing_hsr = ON
       else
          sw_recomposing = OFF
          sw_force_simple_mixing = OFF
          sw_recomposing_hsr = OFF
          sw_force_simple_mixing_hsr = OFF
       endif
    end if
  end subroutine update_spin_recomposing

  subroutine update_spin_density_mixfactor
    logical, save :: first = .true.
    real(kind=DP),save ::  spin_dens_mixfactor_0

    if ( first ) then
       spin_dens_mixfactor_0 = spin_density_mixfactor
       first = .false.
    endif
!
    if ( iteration <= 5 ) then
       spin_density_mixfactor = 4.0
    else
       spin_density_mixfactor = spin_dens_mixfactor_0
    endif
!
    if ( printable ) then
       write(nfout,*) '*** spin_density_mixfacotr now = ', &
            & iteration, spin_density_mixfactor
    end if
! --------------------------------------
  end subroutine update_spin_density_mixfactor

  subroutine order_energy_chg_construction
!
    real(kind=DP) :: edeltb_now
    integer :: isolver, sw_submat
    
    integer :: nsteps_for_transition = 3
    
    edeltb_now = edeltab_per_atom
    isolver = m_CtrlP_solver_for_WFs_now(iteration_electronic,iteration_ionic,intzaj &
         &                              ,edeltb_now, sw_submat)
!
    select case(isolver)
    case (SD,MSD)       
       sw_eval_energy_before_charge = OFF
    case (lmSD, lmMSD, lmCG, lmeazyCG)
       sw_eval_energy_before_charge = OFF
    case default
       if ( iteration <= nsteps_for_transition ) then
          sw_eval_energy_before_charge = OFF
       else
          sw_eval_energy_before_charge = ON
       endif
    end select
!    
    if ( printable ) then
       write(nfout,*) '*-- sw_eval_ene_before_charge now = ',  &
            &               iteration, sw_eval_energy_before_charge
    endif
  end subroutine order_energy_chg_construction

  subroutine update_or_fix_charge
    integer, save :: counter = 0

    real(kind=DP) :: ene_threshold1
    integer :: nsteps_for_fixing_charge = -2

    ene_threshold1 = 1.0E-3
    if ( iteration_electronic == 0 &
         & .or. iteration_electronic <= nsteps_for_fixing_charge ) then
       sw_update_charge_total = ON
    else
       if ( edeltab_per_atom > ene_threshold1 ) then
          sw_update_charge_total = OFF
       else
          sw_update_charge_total = ON
       endif
    endif
!
    if ( iteration <= 1 ) then
       sw_update_charge_total = ON
    else if ( iteration_electronic <= nsteps_for_fixing_charge ) then
       sw_update_charge_total = OFF
    else
       sw_update_charge_total = ON
    endif
! 
  end subroutine update_or_fix_charge

  subroutine update_or_fix_charge_hardpart
    if ( sw_update_charge_total == OFF ) then
       sw_update_charge_hsr = OFF
    else

    endif

  end subroutine update_or_fix_charge_hardpart

end subroutine Renewal_of_Chg_Ctrl_Param
