!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  MODULE: m_FFT
!
!  AUTHOR(S): T. Yamasaki, K. Betsuyaku,   August/20/2003
!  
!  FURTHER MODIFICATION: T. Yamasaki, January/13/2004
!                                   , March/14/2005, April/10/2007
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!

  ! ---------------------
  integer(8) :: plan_WF(2),plan_CD(2)
  ! ------- Positron start 
  integer(8) :: plan_pWF(2)
  ! ------- Positron end

  integer :: sw_avoiding_odd_fftbox = OFF
  integer :: sw_zero_padding = OFF

  include 'mpif.h'
  integer, parameter :: FFTW_MEASURE=0
contains
  subroutine m_FFT_alloc_WF_work
  end subroutine m_FFT_alloc_WF_work

  subroutine m_FFT_alloc_pWF_work()
  end subroutine m_FFT_alloc_pWF_work

  subroutine m_FFT_dealloc_WF_work
  end subroutine m_FFT_dealloc_WF_work

  subroutine m_FFT_alloc_CD_box
    integer :: istat
    if(sw_mpifft == OFF) then
       allocate(afft_CD(nfftp), stat=istat)
    end if
  end subroutine m_FFT_alloc_CD_box

  subroutine m_FFT_dealloc_CD_box
    integer :: istat
    if(sw_mpifft == OFF) then
       deallocate(afft_CD)
    end if
  end subroutine m_FFT_dealloc_CD_box

  subroutine m_FFT_setup(inversion_symmetry,paramset)
    integer, intent(in) :: inversion_symmetry
    logical, intent(in) :: paramset

    real(kind=DP), allocatable, dimension(:)          :: ftw

    integer :: istat = 0
    integer :: nfft_t, ipad
    integer :: id_sname = -1
    call tstatc0_begin('m_FFT_setup ',id_sname)

    if(inversion_symmetry == ON) then  ! kimg == 1
       ipad = 2
    else if(inversion_symmetry == OFF) then ! kimg == 2
       ipad = 0
    end if
! --- fft_box_size_WF, fft_box_size_pWF ---
    fft_box_size_WF(1,0) = fft_box_size_WF(1,1) + ipad
    fft_box_size_WF(2:3,0) = fft_box_size_WF(2:3,1)
    if(sw_positron /= OFF) then
       fft_box_size_pWF(1,0)   = fft_box_size_pWF(1,1) + ipad
       fft_box_size_pWF(2:3,0) = fft_box_size_pWF(2:3,1)
    end if

    nfft =   product(fft_box_size_WF(1:3,0)) * (2-inversion_symmetry)
! --- fft_box_size_CD ---
    fft_box_size_CD_nonpara(1,0)   = fft_box_size_CD(1,1) + ipad
    fft_box_size_CD_nonpara(2:3,0) = fft_box_size_CD(2:3,1)
    nfftp_nonpara  = product(fft_box_size_CD_nonpara(1:3,0)) * (2-inversion_symmetry)

    if(sw_mpifft == ON) then
       if(ipri >= 1) write(nfout,*) '!FFT_CD = MPIFFT <<m_FFT_setup>>'
       call set_mpifft_box_size_CD(inversion_symmetry) ! -> fft_box_size_CD, fft_box_size_CD_c, ny_d, nz_d, etc.
       nfftp  = product(fft_box_size_CD_c(1:3,0)) * (2-inversion_symmetry)
!$$!!#ifndef PARA3D
       nfftps = product(fft_box_size_CD(1:3,0)) * (2-inversion_symmetry)
!$$!!#endif


    else
       fft_box_size_CD(1:3,0) = fft_box_size_CD_nonpara(1:3,0)
       fft_box_size_CD_c(1:3,0) = fft_box_size_CD(1:3,0)
       nfftp  = product(fft_box_size_CD(1:3,0)) * (2-inversion_symmetry)
       nfftps = nfftp
    end if

    if(ipri >= 1) call wd_FFTboxsizes(nfout)

    if(sw_positron /= OFF) &
         & nfft_pstrn = product(fft_box_size_pWF(1:3,0))*(2-inversion_symmetry)

    if(.not. paramset) then
! Initialization of the Wave-Function FFT
       nfft_t = nfft
       if(sw_positron /= OFF .and. nfft_t < nfft_pstrn) nfft_t = nfft_pstrn
       allocate(ftw(nfft_t), stat=istat) ! ftw is used only for initiallization
       if(istat /= 0) then
          if(ipri >= 1) then
             write(nfout,*) 'Allocation error for ftw in sub. m_FFT_setup'
             write(nfout,*) 'stat =', istat, 'nfft =', nfft
          end if
          stop
       end if

       call init_fft_coefficients_arrays_WF()

       deallocate(ftw,stat=istat)
       if(istat /= 0 ) then
          if(ipri >= 1) then
             write(nfout,*) 'Deallocation error for ftw in sub. m_FFT_setup'
             write(nfout,*) 'stat =', istat
          end if
          stop
       end if
!!$#ifndef _MPIFFT_
       if(sw_mpifft == OFF) then
! Initialization of the Charge-Density FFT
          call CDFFT_setup()
!!$#endif
       end if
    end if

    call tstatc0_end(id_sname)
  contains
    subroutine init_fft_coefficients_arrays_WF()
      integer :: nl, nm, nn
      integer :: nl_p, nm_p, nn_p
      nl = fft_box_size_WF(1,1)
      nm = fft_box_size_WF(2,1)
      nn = fft_box_size_WF(3,1)
      if(sw_positron /= OFF) then
         nl_p = fft_box_size_pWF(1,1)
         nm_p = fft_box_size_pWF(2,1)
         nn_p = fft_box_size_pWF(3,1)
      end if

      if(kimg == 1) then
         ! Forward FFT
         call dfftw_plan_dft_c2r_3d(plan_WF(1) &
       &                       ,nl,nm,nn &
       &                       ,ftw(1),ftw(1) &
       &                       ,FFTW_MEASURE)
         ! Inverse FFT
         call dfftw_plan_dft_r2c_3d(plan_WF(2) &
       &                       ,nl,nm,nn &
       &                       ,ftw(1),ftw(1) &
       &                       ,FFTW_MEASURE)
         if(sw_positron /= OFF) then
            ! Forward FFT
            call dfftw_plan_dft_c2r_3d(plan_pWF(1) &
       &                       ,nl_p,nm_p,nn_p &
       &                       ,ftw(1),ftw(1) &
       &                       ,FFTW_MEASURE)
            ! Inverse FFT
            call dfftw_plan_dft_r2c_3d(plan_pWF(2) &
       &                       ,nl_p,nm_p,nn_p &
       &                       ,ftw(1),ftw(1) &
       &                       ,FFTW_MEASURE)
         end if
      else
         ! Forward FFT
         call dfftw_plan_dft_3d(plan_WF(1),nl,nm,nn &
     &                         ,ftw(1),ftw(1) &
     &                         ,-1,FFTW_MEASURE)
         ! Inverse FFT
         call dfftw_plan_dft_3d(plan_WF(2),nl,nm,nn &
     &                         ,ftw(1),ftw(1) &
     &                         ,+1,FFTW_MEASURE)
         if(sw_positron /= OFF) then
            ! Forward FFT
            call dfftw_plan_dft_3d(plan_pWF(1),nl_p,nm_p,nn_p &
     &                         ,ftw(1),ftw(1) &
     &                         ,-1,FFTW_MEASURE)
            ! Inverse FFT
            call dfftw_plan_dft_3d(plan_pWF(2),nl_p,nm_p,nn_p &
     &                         ,ftw(1),ftw(1) &
     &                         ,+1,FFTW_MEASURE)
         end if
      end if
      if(ipri >= 1) then
         write(nfout,'(" !(init_fft_coef_WF) nl, nm, nn   = ",3i8)') nl, nm, nn
         write(nfout,'(" !(init_fft_coef_WF) plan_WF(1:2) = ",2i20)') plan_WF(1:2)
      end if
    end subroutine init_fft_coefficients_arrays_WF


  end subroutine m_FFT_setup

  subroutine CDFFT_setup()
    allocate(afft_CD(nfftp_nonpara))
    call init_fft_coefficients_arrays_CD()
    CD_setup_is_done = YES
    deallocate(afft_CD)
  contains
    subroutine init_fft_coefficients_arrays_CD
      integer :: nl, nm, nn

   !  ---> FFT for Charge density
      nl = fft_box_size_CD(1,1)
      nm = fft_box_size_CD(2,1)
      nn = fft_box_size_CD(3,1)
      if(kimg == 1) then
         ! Forward FFT
         call dfftw_plan_dft_c2r_3d(plan_CD(1) &
       &                       ,nl,nm,nn &
       &                       ,afft_CD(1),afft_CD(1) &
       &                       ,FFTW_MEASURE)
         ! Inverse FFT
         call dfftw_plan_dft_r2c_3d(plan_CD(2) &
       &                       ,nl,nm,nn &
       &                       ,afft_CD(1),afft_CD(1) &
       &                       ,FFTW_MEASURE)
      else
         ! Forward FFT
         call dfftw_plan_dft_3d(plan_CD(1),nl,nm,nn &
     &                         ,afft_CD(1),afft_CD(1) &
     &                         ,-1,FFTW_MEASURE)
         ! Inverse FFT
         call dfftw_plan_dft_3d(plan_CD(2),nl,nm,nn &
     &                         ,afft_CD(1),afft_CD(1) &
     &                         ,+1,FFTW_MEASURE)
      end if
      if(ipri >= 1) then
         write(nfout,'(" !(CDFFT_setup) nl, nm, nn   = ",3i8)') nl, nm, nn
         write(nfout,'(" !(CDFFT_setup) plan_CD(1:2) = ",2i20)') plan_CD(1:2)
      end if
    end subroutine init_fft_coefficients_arrays_CD
  end subroutine CDFFT_setup

! === necessary to make 3D_Parallel, too!!! by tkato ===========================
!!BRANCH_P ORG_Parallel
! ==============================================================================
!$$#ifndef PARA3D
  subroutine m_FFT_WF(electron_or_positron,nfout,afft,inverse_or_direct,switch)  ! G space --> R space
    integer, intent(in)          :: electron_or_positron
    integer, intent(in)          :: nfout
    real(kind=DP), intent(inout) :: afft(nfft)
    integer, intent(in)          :: inverse_or_direct
    integer, intent(in)          :: switch

    integer(8) :: plan(2)
    integer :: id_sname = -1
    if(electron_or_positron == ELECTRON) then
       call tstatc0_begin('m_FFT_WF ',id_sname)
    else if(electron_or_positron == POSITRON) then
       call tstatc0_begin('m_FFT_pWF ',id_sname)
    end if

    if(electron_or_positron == ELECTRON) then
       plan(1:2) = plan_WF(1:2)
    else if(electron_or_positron == POSITRON) then
       plan(1:2) = plan_pWF(1:2)
    end if

    if(inverse_or_direct == DIRECT) then
       if(kimg==1) then
          call dfftw_execute_dft_c2r(plan(1),afft(1),afft(1))
       else
          call dfftw_execute_dft(plan(1),afft(1),afft(1))
       end if
    else ! INVERSE
       if(kimg==1) then
          call dfftw_execute_dft_r2c(plan(2),afft(1),afft(1))
       else
          call dfftw_execute_dft(plan(2),afft(1),afft(1))
       end if
    end if

    call tstatc0_end(id_sname)
  end subroutine m_FFT_WF
!$$#endif
! === necessary to make 3D_Parallel, too!!! by tkato ===========================
!!BRANCH_P_END ORG_Parallel
! ==============================================================================

  subroutine fft_CD_inverse_core(afft_CD)
    real(kind=DP),intent(inout),dimension(nfftp_nonpara) :: afft_CD

    if(kimg==1) then
       call dfftw_execute_dft_r2c(plan_CD(2),afft_CD(1),afft_CD(1))
    else
       call dfftw_execute_dft(plan_CD(2),afft_CD(1),afft_CD(1))
    endif
  end subroutine fft_CD_inverse_core

  subroutine fft_CD_direct_core(afft_CD)
    real(kind=DP),intent(inout),dimension(nfftp_nonpara) :: afft_CD
    if(kimg==1) then
       call dfftw_execute_dft_c2r(plan_CD(1),afft_CD(1),afft_CD(1))
    else
       call dfftw_execute_dft(plan_CD(1),afft_CD(1),afft_CD(1))
    end if
  end subroutine fft_CD_direct_core

! --------------
