/******************************************************************
 *
 *	CyberX3D for Java
 *
 *	Copyright (C) Satoshi Konno 1997-2002
 *
 *	File : ImageTextureNode.java
 *
 *	Revisions:
 *
 *	12/05/02
 *		- Changed the super class from TextureNode to Texture2DNode.
 *
 ******************************************************************/

package org.cybergarage.x3d.node;

import java.io.PrintWriter;

import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.SFBool;

public class ImageTextureNode extends Texture2DNode {
    // // Exposed Field ////////////////
    private final static String urlFieldName = "url";

    MFString urlField;

    public ImageTextureNode() {
        setHeaderFlag(false);
        setType(NodeType.IMAGETEXTURE);

        // /////////////////////////
        // Exposed Field
        // /////////////////////////

        // url field
        urlField = new MFString();
        addExposedField(urlFieldName, urlField);

    }

    public ImageTextureNode(ImageTextureNode node) {
        this();
        setFieldValues(node);
    }

    // //////////////////////////////////////////////
    // URL
    // //////////////////////////////////////////////

    public MFString getURLField() {
        if (isInstanceNode() == false)
            return urlField;
        return (MFString) getExposedField(urlFieldName);
    }

    public void addURL(String value) {
        getURLField().addValue(value);
    }

    public int getNURLs() {
        return getURLField().getSize();
    }

    public void setURL(int index, String value) {
        getURLField().set1Value(index, value);
    }

    public void setURLs(String value) {
        getURLField().setValues(value);
    }

    public void setURLs(String value[]) {
        getURLField().setValues(value);
    }

    public String getURL(int index) {
        return getURLField().get1Value(index);
    }

    public void removeURL(int index) {
        getURLField().removeValue(index);
    }

    // //////////////////////////////////////////////
    // abstract functions
    // //////////////////////////////////////////////

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    // //////////////////////////////////////////////
    // infomation
    // //////////////////////////////////////////////

    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool repeatS = getRepeatSField();
        SFBool repeatT = getRepeatTField();

        printStream.println(indentString + "\t" + "repeatS " + repeatS);
        printStream.println(indentString + "\t" + "repeatT " + repeatT);

        MFString url = getURLField();
        printStream.println(indentString + "\t" + "url [");
        url.outputContext(printStream, indentString + "\t\t");
        printStream.println(indentString + "\t" + "]");
    }
}
