/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Terminal.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.terminal;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.SshClient;
import ciss.phase_viewer.ssh.hosts.HostConfigurator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorMenu;
import ciss.phase_viewer.ssh.sftp.SftpClient;

public class Terminal extends InternalFrameChase implements SshClient {

    private static Logger logger = Logger.getLogger(Terminal.class.getName());

    private HostInfo hostinfo;

    private TermPanel termpanel;

    private int origw;
    private int origh;

    public Terminal() {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        init();
    }

    public Terminal(HostInfo hostinfo) {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.hostinfo = hostinfo;
        init();
        if (hostinfo != null) {
            connect(hostinfo);
        }
    }

    private String initCommand;

    public Terminal(HostInfo hostinfo, String initCommand) {
        super("ssh client", false, true, false, true, new Dimension(600, 400));
        this.hostinfo = hostinfo;
        this.initCommand = initCommand;
        init();
        if (hostinfo != null) {
            connect(hostinfo);
        }
    }

    private void init() {
        origw = getSize().width;
        origh = getSize().height;
        JPanel p = createPanelAndButtons();
        // JSplitPane split = new
        // JSplitPane(JSplitPane.HORIZONTAL_SPLIT,true,connector,p);
        // split.setOneTouchExpandable(true);
        // this.getContentPane().add(split);

        this.getContentPane().add(p);
        // JCTerm term = new JCTerm();
        // this.getContentPane().add(term);
        // this.setJMenuBar(term.getJMenuBar());

        addComponentListener(new TerminalListener(this));
        addInternalFrameListener(new InternalFrameListener() {
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                disconnect();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            public void internalFrameIconified(InternalFrameEvent e) {
            }

            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
        super.setJMenuBar(new TerminalMenuBar(this));
        this.pack();
    }

    protected void resized() {
        double wnow = (double) getSize().width;
        double hnow = (double) getSize().height;
        double wscale = wnow / ((double) origw);
        double hscale = hnow / ((double) origh);
        termpanel.parentResized(wscale, hscale);
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public void connect(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        logger.debug("connecting ...");
        if (hostinfo != null) {
            termpanel.connect(hostinfo);
        }
    }

    public void disconnect() {
        if (termpanel != null) {
            termpanel.disconnect();
        }
        termpanel = null;
    }

    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    private JPanel createPanelAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        termpanel = new TermPanel(initCommand, this);
        JScrollPane pane = new JScrollPane(termpanel);
        p.add(pane);
        p.add(createButtons());
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        return p;
    }

}

class TerminalListener implements ComponentListener {

    private Terminal term;

    protected TerminalListener(Terminal term) {
        this.term = term;
    }

    public void componentResized(ComponentEvent e) {
        term.resized();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

}

class TerminalMenuBar extends JMenuBar {

    SshClient client;

    protected TerminalMenuBar(SshClient client) {
        this.client = client;
        init();
    }

    private void init() {
        this.add(fileMenu());
        this.add(new HostSelectorMenu(client, "hosts", KeyEvent.VK_H));
        this.add(toolsMenu());
    }

    private MyJMenu fileMenu() {
        MyJMenu file = new MyJMenu("File", KeyEvent.VK_F, false);

        MyJMenuItem exit = new MyJMenuItem("exit", KeyEvent.VK_X);
        file.add(exit);

        exit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                client.disconnect();
                ((JInternalFrame) client).dispose();
            }
        });

        return file;
    }

    private MyJMenu toolsMenu() {
        MyJMenu tool = new MyJMenu("Tools", KeyEvent.VK_T, false);
        MyJMenuItem host = new MyJMenuItem("host configurator", KeyEvent.VK_H);
        MyJMenuItem sftp = new MyJMenuItem("sftp client", KeyEvent.VK_S);
        tool.add(host);
        tool.add(sftp);

        host.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                HostConfigurator configurator = new HostConfigurator();
            }
        });

        sftp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SftpClient sc = new SftpClient((HostInfo) client.getHostInfo()
                        .clone());
            }
        });

        return tool;
    }
}
