/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PrimitiveInputComponents.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;

import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;

abstract public class PrimitiveInputComponents extends JPanel {
    private static Logger logger = Logger
            .getLogger(PrimitiveInputComponents.class.getName());

    protected String[] inputSpecifications; // input specification
                                            // ̃tpX̔z(L蓾邽߂Ă).
    protected String[] fullName; // input specification ̃tpX? ̔z\.

    protected InputInterface inputInterface; // InputInterface IuWFNg.
    protected InputInterfacePrimitiveEntry entry;
    protected InputInterfaceUnits units;

    protected boolean isDoubleQuoted = false;

    public PrimitiveInputComponents(String[] inputSpecifications,
            InputInterface inputInterface) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.extractInputFile();
    }

    public PrimitiveInputComponents(String[] inputSpecifications,
            InputInterface inputInterface, boolean isDoubleQuoted) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.isDoubleQuoted = isDoubleQuoted;
        this.extractInputFile();
    }

    /**
     * ̃plɃXi[o^. , ۂɂ͂̃plێ艺̃R|[lgɓn.
     * 
     * @param listener
     *            CxgXi[
     */
    protected void addListeners(EventListener listener) {
        Component[] comps = getComponents();
        if (comps == null) {
            return;
        }

        for (int i = 0; i < comps.length; i++) {
            Component comp = comps[i];
            if (comp == null) {
                continue;
            }
            if (comp instanceof Command) {
                if (comp instanceof AbstractButton) {
                    ((AbstractButton) comp)
                            .addActionListener((ActionListener) listener);
                    ((AbstractButton) comp)
                            .addItemListener((ItemListener) listener);
                    if (comp instanceof JComboBox) {
                        ((JComboBox) comp)
                                .addPopupMenuListener((PopupMenuListener) listener);
                    }
                } else if (comp instanceof JTextComponent) {
                    ((JTextComponent) comp)
                            .addCaretListener((CaretListener) listener);
                }
            }
        }
    }

    /**
     * input specifications ɏ], inputInterface primitive entryIuWFNg
     * unitsIuWFNgւ̎QƂ擾. RXgN^[Ă΂̂, TuNX疾IɌĂԕKv͂Ȃ͂.
     * ł̐Uł͂܂sȂꍇI[o[ChĂ悢.
     */
    protected void extractInputFile() {
        for (int is = 0; is < inputSpecifications.length; is++) {
            String inp = inputSpecifications[is];
            fullName = inp.split("\\.");
            String blockIdent = fullName[0];
            for (int i = 1; i < fullName.length - 1; i++) {
                blockIdent += "." + fullName[i];
            }

            inputInterface.selectRoot();
            if (!inputInterface.selectBlock(blockIdent)) {
                logger.debug("couldn't select block: " + blockIdent);
            }

            boolean found = false;

            units = inputInterface.getUnits();
            if (units.getName().trim().length() != 0
                    || is == inputSpecifications.length - 1) {
                logger.debug("got entry: " + units.getName());
                String st = inputSpecifications[0];
                found = true;
            }

            entry = inputInterface
                    .getPrimitiveEntry(fullName[fullName.length - 1]);
            // if ( entry.getName().trim().length() != 0 || is ==
            // inputSpecifications.length - 1 ) {
            if (entry.getValue().trim().length() != 0
                    || is == inputSpecifications.length - 1) {
                entry.setDoubleQuoted(isDoubleQuoted);
                logger.debug("got entry: " + entry.getName() + " value: "
                        + entry.getValue() + " unit: " + entry.getUnit()
                        + " isDoubleQuoted? " + entry.isDoubleQuoted());
                String st = inputSpecifications[0];
                fullName = st.split("\\.");
                entry.setName((fullName[fullName.length - 1]).trim());
                found = true;
            }

            if (found) {
                break;
            }

        }
    }

}
