/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceUnits.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import java.util.HashMap;

public class InputInterfaceUnits extends InputInterfaceEntry {

    private String[] units;

    public InputInterfaceUnits() {
    }

    public InputInterfaceUnits(String name, String[] units) {
        super(name);
        this.units = units;
    }

    public String[] getUnits() {
        return this.units;
    }

    public void setUnits(String[] units) {
        this.units = units;
    }

    /**
     * Pʂ, ނŕނĕԂ. o^ĂȂPʂ̏ꍇnulli[.
     * 
     * @return ނŕނꂽP.
     */
    public String[] getUnitTypes() {
        if (units == null)
            return null;
        HashMap map = getUnitMap();
        String[] types = new String[units.length];
        for (int i = 0; i < units.length; i++) {
            Object obj = map.get(units[i].toLowerCase());
            if (obj != null)
                types[i] = obj.toString();
            else
                types[i] = null;
        }
        return types;
    }

    public int getEntryType() {
        return UNITS;
    }

    public InputInterfaceEntry getCopy() {
        return this;
    }

    public boolean equals(InputInterfaceEntry entry) {
        if (!(entry instanceof InputInterfaceUnits)) {
            return false;
        }
        return true;
    }

    public void saveState() {

    }

    public void undo() {

    }

    public void redo() {

    }

    public static String LENGTH = "length";
    public static String ENERGY = "energy";

    private static HashMap unitMap;

    /**
     * Pʂ̖OL[, ̒Pʂ̎ނlƂnbV}bvԂ. ł͂Ȃ.
     * 
     * @return Pʂ̖OL[, ̒Pʂ̎ނlƂnbV}bv.
     */
    public static HashMap getUnitMap() {
        if (unitMap == null) {
            unitMap = new HashMap();
            unitMap.put("angstrom", LENGTH);
            unitMap.put("bohr", LENGTH);
            unitMap.put("nm", LENGTH);
            unitMap.put("ev", ENERGY);
            unitMap.put("hartree", ENERGY);
            unitMap.put("rydberg", ENERGY);
        }

        return unitMap;
    }
}
