/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/02, 17:08
!  AUTHOR(S): KOGA, Junichiro
!  File : MenuTree.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import java.util.LinkedList;
import java.util.Vector;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import org.apache.log4j.Logger;

/**
 * JMenůKw𐧌䂷NX. InputInterfaceNXƎdg݂ǐ蔲.
 * 
 * @author
 */
public class MenuTree {
    private Logger logger = Logger.getLogger(MenuTree.class.getName());
    private MenuBlock list = new MenuBlock(null, null);

    /** Creates a new instance of MenuTree */
    public MenuTree() {
        super();
    }

    /**
     * uݑI𒆁ṽubNJMenu𑫂.
     * 
     * @param menu
     *            ݂JMenuIuWFNg.
     */
    public void addMenu(JMenu menu) {
        list.add(new MenuBlock(list, menu));
    }

    /**
     * ݑI𒆂̃ubNɊ֘AtꂽJMenuɎwJMenuItem𑫂.
     * 
     * @param menuItem
     *            ݂JMenuItemIuWFNg.
     */
    public void addMenuItem(JMenuItem menuItem) {
        addMenuItem(menuItem, false);
    }

    /**
     * ݑI𒆂̃ubNɊ֘AtꂽJMenuɎwJMenuItem𑫂. OJSeparatortł.
     * 
     * @param menuItem
     *            ݂JMenuItemIuWFNg.
     * @param hasSeparator
     *            JSeparatorOɕtꍇ^ɂ.
     */
    public void addMenuItem(JMenuItem menuItem, boolean hasSeparator) {
        JMenu menu = list.getMenu();
        if (menu != null) {
            if (hasSeparator) {
                menu.add(new JSeparator());
            }
            menu.add(menuItem);
        }
    }

    /**
     * ubNw̃ubNI(݂Ȃꍇ쐬)
     * 
     * @param menu
     *            IubNJMenuIuWFNg
     */
    public void selectBlock(JMenu menu) {
        String name = menu.getText();
        logger.debug("menu: " + menu);
        logger.debug("size of list: " + list.size());
        for (int i = 1; i < list.size(); i++) {
            MenuBlock bl = (MenuBlock) list.get(i);
            logger.debug("block: " + bl);
            if (name.trim().equals(bl.getName())) {
                list = bl;
                return;
            }
        }
        list.add(new MenuBlock(list, menu));
        selectBlock(menu);
    }

    /**
     * ubNw̃ubNI. ̏ꍇ݂͑邱Ƃ肵Ă , ȂꍇꉞȒPJMenuIuWFNg쐬.
     * 
     * @param name
     *            IubN̖O.
     */
    public void selectBlock(String name) {
        for (int i = 1; i < list.size(); i++) {
            MenuBlock bl = (MenuBlock) list.get(i);
            logger.debug("block: " + bl);
            if (name.trim().equals(bl.getName())) {
                list = bl;
                return;
            }
        }
        JMenu menu = new JMenu(name);
        list.add(new MenuBlock(list, menu));
        selectBlock(menu);
    }

    /**
     * ݑI𒆂̃ubN, ̃ubNI.
     */
    public void selectParent() {
        list = (MenuBlock) list.get(0);
    }

    /**
     * [gubNI.
     */
    public void selectRoot() {
        while (list.get(0) != null) {
            selectParent();
        }
    }

    public JMenu[] getMenus() {
        selectRoot();
        Vector menuvec = new Vector();
        for (int i = 1; i < list.size(); i++) {
            menuvec.addElement(((MenuBlock) list.get(i)).getMenu());
        }
        if (menuvec.size() == 0) {
            return null;
        }
        JMenu[] ret = new JMenu[menuvec.size()];
        menuvec.copyInto(ret);

        return ret;
    }

}

class MenuBlock extends LinkedList {
    private JMenu menu;

    protected MenuBlock(MenuBlock parent, JMenu menu) {
        add(parent);
        this.menu = menu;
        if (parent != null) {
            JMenu parentMenu = parent.getMenu();
            if (parentMenu != null) {
                parentMenu.add(menu);
            }
        }
    }

    protected JMenu getMenu() {
        return menu;
    }

    protected String getName() {
        return menu.getText();
    }

    public String toString() {
        return "name: " + getName();
    }

}
