/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ExternalProgramExecuter.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;

import org.apache.log4j.Logger;

public class ExternalProgramExecuter {
    private static Logger logger = Logger
            .getLogger(ExternalProgramExecuter.class.getName());
    /** the program path string */
    private String programPath = new String();

    /** process */
    private Process process;

    public static final int NORMAL = 0; /* !< I̍ۂɕԂintl */
    public static final int EXCEPTION = 1; /* !< OۂɕԂintl */

    public ExternalProgramExecuter() {
    }

    /**
     * @param programPath
     *            sׂvÕpX
     */
    public ExternalProgramExecuter(String programPath) {
        this.programPath = programPath;
    }

    /**
     * vOpXɕ𑫂.
     *
     * @param str
     *            
     */
    public void addProgramPath(String str) {
        programPath = programPath + str;
    }

    /** vOsp. */
    public void clearProgramPath() {
        programPath = new String();
    }

    /**
     * @return sׂvÕpX
     */
    public String getProgramPath() {
        return this.programPath;
    }

    /**
     * ̃NXێ, usׂvs.
     */
    public void execute() throws Exception {
        process = Runtime.getRuntime().exec(programPath);
        logger.info("executed: " + programPath);
        // process.waitFor();
    }

    /**
     * @return svZXIuWFNg̎Q.
     */
    public Process getProcess() {
        return this.process;
    }

    /**
     * ڎsvÕpXw肵, s郁\bh.
     *
     * @param str
     *            svÕpX.
     */
    public static void execute(String str) throws Exception {
        Process p = Runtime.getRuntime().exec(str);
        logger.info("executed: " + str);
        p.waitFor();
    }

    /**
     * ڎsvÕpXw肵, s郁\bh. Wo͂̏~ꍇgp.
     *
     * @param str
     *            svÕpX.
     * @return Wo͂ƕWG[o͂̏ێBufferedReader; 0Ԗڂ̗vf
     *         Wo͂1Ԗڂ̗vfWG[o͂ɑ邪, WG[o݂͂͌̕܂ 삵Ȃ.
     * @param str
     *            svÕpX.
     * @return svOWóEWG[o͂ɏoێ BufferedReader.
     */
    public static BufferedReader[] executeGetBR(String str) throws IOException {
        return executeGetBR(str, null);
    }

    /**
     * Wo͂1Ԗڂ̗vfWG[o͂ɑ邪, WG[o݂͂͌̕܂ 삵Ȃ.
     *
     * @param str
     *            svÕpX.
     * @param dir
     *            ƃfBNg[
     * @return svOWóEWG[o͂ɏoێ BufferedReader.
     */
    public static BufferedReader[] executeGetBR(String str, File dir)
            throws IOException {

        BufferedReader[] bin = new BufferedReader[2];

        Process p = Runtime.getRuntime().exec(str, null, dir);
        InputStream ie;
        InputStream is;
        ie = p.getErrorStream();
        bin[1] = new BufferedReader(new InputStreamReader(ie));
        is = p.getInputStream();
        bin[0] = new BufferedReader(new InputStreamReader(is));
        return bin;
    }

    /**
     * Wo͂1Ԗڂ̗vfWG[o͂ɑ邪, WG[o݂͂͌̕܂ 삵Ȃ. ϐn.
     *
     * @param str
     *            svÕpX.
     * @param dir
     *            ƃfBNg[
     * @param envp
     *            ϐ̔z; RuntimeNXQ.
     * @return svOWóEWG[o͂ɏoێ BufferedReader.
     */
    public static BufferedReader[] executeGetBR(String str, File dir,
            String[] envp) throws IOException {

        BufferedReader[] bin = new BufferedReader[2];

        Process p = Runtime.getRuntime().exec(str, envp, dir);
        InputStream ie;
        InputStream is;
        ie = p.getErrorStream();
        bin[1] = new BufferedReader(new InputStreamReader(ie));
        is = p.getInputStream();
        bin[0] = new BufferedReader(new InputStreamReader(is));
        return bin;
    }

    /**
     * vO𒼐ڋNł郁\bh. ̃\bh, waitForp^[^̏ꍇsOvO I܂Ŏɐi܂Ȃ.
     *
     * @param str
     *            sׂvÕpX.
     * @param waitFor
     *            ^̂ƂsOvOI܂ő҂.
     * @return svOWóEWG[o͂ɏoێ BufferedReader.
     */
    public static BufferedReader[] executeGetBR(String str, boolean waitFor)
            throws Exception {

        BufferedReader[] bin = new BufferedReader[2];

        Process p = Runtime.getRuntime().exec(str);
        BufferedInputStream ie;
        BufferedInputStream is;
        try {
            ie = (BufferedInputStream) p.getErrorStream();
            bin[1] = new BufferedReader(new InputStreamReader(ie));
        } catch (Exception e) {
            // System.out.println("no error out (?)");
        }
        try {
            is = (BufferedInputStream) p.getInputStream();
            bin[0] = new BufferedReader(new InputStreamReader(is));
        } catch (Exception ex) {
            logger.error("no output");
        }

        if (waitFor) {
            p.waitFor();
        }
        return bin;
    }

    /**
     * eLXgf[^̃t@CRs[郁\bh. OSɈˑȂ. ܂, Rs[ƃRs[悪t@CꍇȂ.
     *
     * @param str1
     *            Rs[
     * @param str2
     *            Rs[
     */
    public static void copy(String str1, String str2) throws IOException {
        if (str1.trim().equalsIgnoreCase(str2.trim())) {
            logger.error("can't copy ... same file!");
            return;
        }
        String strBuff;
        BufferedReader brInFile = new BufferedReader(new FileReader(str1));
        PrintWriter pwOutFile = new PrintWriter(new BufferedWriter(
                new FileWriter(str2)));

        while ((strBuff = brInFile.readLine()) != null) {
            pwOutFile.println(strBuff);
        }
        brInFile.close();
        pwOutFile.close();
    }

    /**
     * oCi[f[^̃t@CRs[郁\bh. OSɈˑȂ. ܂, Rs[ƃRs[悪t@CꍇȂ.
     *
     * @param binaryFile1
     *            Rs[
     * @param binaryFile2
     *            Rs[
     */
    public static void copyBinary(String binaryFile1, String binaryFile2)
            throws IOException {
        if (binaryFile1.trim().equalsIgnoreCase(binaryFile2.trim())) {
            logger.debug("can't copy ... same file!");
            return;
        }
        BufferedInputStream bistream = new BufferedInputStream(
                new FileInputStream(binaryFile1));
        BufferedOutputStream bostream = new BufferedOutputStream(
                new FileOutputStream(binaryFile2));

        int indata;

        while ((indata = bistream.read()) != -1) {
            bostream.write(indata);
        }

        bostream.flush();
        bistream.close();
        bostream.close();
    }


    /**
     * oCi[f[^̃t@CRs[郁\bh. OSɈˑȂ. Rs[URLŎwB
     *
     * @param binaryFile1
     *            Rs[
     * @param binaryFile2
     *            Rs[
     */
    public static void copyBinary(URL binaryFile1, String binaryFile2)
            throws IOException {
        InputStream bistream = binaryFile1.openStream();
        BufferedOutputStream bostream = new BufferedOutputStream(
                new FileOutputStream(binaryFile2));

        int indata;

        while ((indata = bistream.read()) != -1) {
            bostream.write(indata);
        }

        bostream.flush();
        bistream.close();
        bostream.close();
    }


    /**
     * t@C폜p\bh.
     *
     * @param fileName
     *            폜t@C.
     */
    public static void remove(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return;
    }

    /**
     * t@Cړp̃\bh. ړƈړ悪̏ꍇȂɂȂ. Javãl[@\𗘗p.
     *
     * @param fileName1
     *            ړ
     * @param fileName2
     *            ړ
     * @return t@Cړ^.
     */
    public static boolean move(String fileName1, String fileName2) {
        logger.info("moving file " + fileName1 + " to " + fileName2);
        boolean bret = false;
        if (fileName1.trim().equalsIgnoreCase(fileName2.trim())) {
            logger.error("can't move ... same file!");
            return false;
        }
        File file1 = new File(fileName1);
        File file2 = new File(fileName2);
        bret = file1.renameTo(file2);
        return bret;
    }

}
