/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/13, 19:41
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptReplaceRules.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting.scriptreplace;

import org.apache.log4j.Logger;
import org.jdom.Element;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;

/**
 * XNvg̃L[[huK񋟂NX̃x[XNX.
 * 
 * @author
 */
public abstract class ScriptReplaceRules {
    private Logger logger = Logger
            .getLogger(ScriptReplaceRules.class.getName());

    /** Creates a new instance of ScriptReplaceRules */
    public ScriptReplaceRules() {
    }

    /**
     * u\? ȑSẴL[̔z擾.
     * 
     * @param L[̔z
     *            .
     */
    protected abstract String[] getKeys();

    /**
     * ۂ̒u.
     * 
     * @param script
     *            ̑sXNvg{.
     * @param document
     *            ȂǂLqĂƎvDocument.
     * @return uꂽ. sꍇnullԂ.
     */
    public abstract String replace(String script, org.jdom.Document document);

    /**
     * ۂ̒u.
     * 
     * @param script
     *            ̑sXNvg{.
     * @param document
     *            ȂǂLqĂƎvDocument.
     * @param overwrite
     *            ㏑Ă܂Ȃw
     * @return uꂽ. sꍇnullԂ.
     */
    public abstract String replace(String script, org.jdom.Document document,
            boolean overwrite);

    /**
     * MPIΉǂԂ.
     * 
     * @param env
     *            ݒ̋L^ꂽElement
     * @return MPIΉȂ^CłȂȂU
     */
    protected boolean mpiSupport(Element env, String targetHost) {
        boolean localhost = targetHost.equals("localhost");
        boolean win = Utils.isWindows();
        boolean asms = false;
        String vendor = System.getProperty("pviewer.vendor");
        if (vendor != null && vendor.equalsIgnoreCase("asms"))
            asms = true;

//        boolean mpiSettings = false;
//        String mpidir = MyElement.decode(env.getChildTextTrim("mpidir"));
//        if (mpidir != null
//                && MyElement.decode(env.getChildTextTrim("mpidir")).length() > 0)
//            mpiSettings = true;

        if (localhost && win && !asms)
            return false;
//        if (localhost && win && !mpiSettings)
//            return false;

        return true;
    }

}
