/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : JTreeTest.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.projectbrowser;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

public class JTreeTest extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(JTreeTest.class.getName());
    JList list;
    JScrollPane spane1;
    JScrollPane spane2;
    JPanel panel;
    JSplitPane spltpane;
    JTree tree;
    DefaultMutableTreeNode treenode;

    Container cont;
    File[] roots;
    File[] templist;
    File[][] work = new File[512][];
    int curdir = 0;
    File temp;
    JButton btn1;
    boolean bFreezeFlag = false;

    // TreePathpX𐶐郁\bh
    File getSubDirList(TreePath treepath) {
        if (treepath == null)
            return null;
        // ܂A[gfBNg擾
        String string = treepath.getPathComponent(0).toString();
        // ɃpXJEg擾
        int count = treepath.getPathCount();
        // ̌Ac̃pX擾
        for (int i = 1; i < count; i++) {
            string += treepath.getPathComponent(i).toString();
            if (i + 1 == count)
                break;
            else
                string += "\\"; // UNIXł́u/vg
        }
        logger.debug("subdirlist: " + string);
        return new File(string);
    }

    // XgƓWJp̃c[쐬
    void addExpandTree(TreePath tp, File file) {
        // XgXV
        if (file == null)
            return;

        DefaultMutableTreeNode node = (DefaultMutableTreeNode) tp
                .getLastPathComponent();
        logger.debug(node.toString());
        if (node == null)
            return;

        // fBNg̏ꍇ́AXgXV
        if (file.isDirectory()) {
            // XgXV
            // /////////////////////////////////////////
            // TufBNgXg
            templist = file.listFiles();
            // Xg̏ꍇ͏Ȃ
            if (templist.length == 0)
                return;
            curdir++;
            work[curdir] = templist;
            Arrays.sort(work[curdir]);
            list.setListData(work[curdir]);
            // /////////////////////////////////////////

            // ɁAc[XV
            // ̃m[ȟׂ݂̂Ă̎qm[h
            node.removeAllChildren();

            // 2x̎qm[hǉ
            for (int i = 0; i < work[curdir].length; i++) {
                DefaultMutableTreeNode temp = new DefaultMutableTreeNode(
                        work[curdir][i].getName());
                logger.debug(temp.toString());
                node.add(temp);

                if (work[curdir][i].isDirectory()) {
                    // ̃fBNg̃Xg쐬
                    File[] files = work[curdir][i].listFiles();
                    // Xg̏ꍇ͏Ȃ
                    if (files == null || files.length == 0)
                        continue;
                    // Ƀ\[g
                    Arrays.sort(files);

                    // Xg̊em[hc[ɒǉ
                    for (int j = 0; j < files.length; j++) {
                        DefaultMutableTreeNode tempsub = new DefaultMutableTreeNode(
                                files[j].getName());
                        // ̃m[hǉ
                        temp.add(tempsub);
                    }
                }
            }
        }
    }

    // ܂񂾌̃Xg\
    void showDirectory(TreePath tp, File file) {
        // XgXV
        if (file == null) {
            templist = new File[1];
            curdir++;
            work[curdir] = templist;
            list.setListData(work[curdir]);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) tp
                .getLastPathComponent();
        if (node == null)
            return;

        // fBNg̏ꍇ́AXgXV
        if (file.isDirectory()) {
            // TufBNgXg
            templist = file.listFiles();
            // Xg̏ꍇ͏Ȃ
            if (templist.length == 0)
                return;
            curdir++;
            work[curdir] = templist;
            Arrays.sort(work[curdir]);
            list.setListData(work[curdir]);
        }
    }

    public static void main(String args[]) {

        // MyFirstJavaIuWFNg쐬
        JTreeTest window = new JTreeTest();

        // EBhẼTCYw肷
        window.setSize(400, 200);

        // ////////////////////////////////////////////////////
        // ftHg̏Iݒ肷
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        // ////////////////////////////////////////////////////

        // EBhE\
        window.setVisible(true);
    }

    // MyFirstJavaNX̃ftHgRXgN^
    public JTreeTest() {
        super("c[ƃXggfBNgT", true, true, true, true, new Dimension(600,
                300));

        // RegyC擾
        cont = getContentPane();
        ((BorderLayout) cont.getLayout()).setVgap(5);

        panel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        btn1 = new JButton("");
        btn1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                --curdir;
                if (curdir == -1) {
                    curdir = 0;
                    Toolkit.getDefaultToolkit().beep();
                }
                // ̕ύX̃Cxgt[Y
                bFreezeFlag = true;
                list.setListData(work[curdir]);
            }
        });
        panel.add(btn1);
        cont.add(panel, "North");

        // ̃XN[yC쐬
        spane1 = new JScrollPane();

        // [gfBNg擾
        roots = File.listRoots();
        // [gfBNg̃m[h쐬
        treenode = new DefaultMutableTreeNode(roots[1]); // UNIXł́Aroots[0]
        // [gpX̃m[hgăc[쐬
        tree = new JTree(treenode);
        // ŏ̓[tɂȂȂ悤A_~[̎qc[ǉĂ
        treenode.add(new DefaultMutableTreeNode(""));

        // TreeWillExpandListenerXio^A
        tree.addTreeWillExpandListener(new TreeWillExpandListener() {
            // c[WJ悤ƂĂ
            public void treeWillExpand(TreeExpansionEvent e) {
                // ݂̃c[pX擾
                TreePath tp = e.getPath();
                // pX𐶐
                File file = getSubDirList(tp);
                // XgXVāAWJp̃c[쐬
                addExpandTree(tp, file);
            }

            // c[܂܂悤ƂĂ
            public void treeWillCollapse(TreeExpansionEvent e) {
                // ݂̃c[pX擾
                TreePath tp = e.getPath().getParentPath();
                // pX𐶐
                File file = getSubDirList(tp);
                // ܂񂾃pX̃Xg\
                showDirectory(tp, file);
            }
        });

        // c[XN[yCɊi[
        spane1.setViewportView(tree);

        // ẼXN[yC쐬
        spane2 = new JScrollPane();

        // Xg쐬
        list = new JList(work[curdir]);

        // ŏ͋̃Xg\
        templist = new File[1];
        work[curdir] = templist;
        list.setListData(work[curdir]);

        // XgZNVXio^A
        list.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                // ̃P[X͏Ȃ
                if (bFreezeFlag) {
                    bFreezeFlag = false;
                    return;
                }
                if (list.getSelectedValue() == null)
                    return;
                // t@C̏ꍇ
                if (((File) list.getSelectedValue()).isFile()) {
                    JOptionPane.showMessageDialog(cont, list.getSelectedValue()
                            + "I܂");
                }
            }
        });
        // XgXN[yCɊi[
        spane2.setViewportView(list);

        // XvbgyC쐬
        spltpane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, spane1,
                spane2);
        // ^b`GLXp_𑕒
        spltpane.setOneTouchExpandable(true);
        // fBoC_𐅕ʒuɐݒ肷
        spltpane.setDividerLocation(300);
        cont.add(spltpane, "Center");
    }
}
