/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/22, 18:11
!  AUTHOR(S): KOGA, Junichiro
!  File : IntroPanelEkcal.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal.intropanel;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

import ciss.phase_viewer.plugins.projectmanipulator.IntroPanel;
import ciss.phase_viewer.plugins.projectmanipulator.ekcal.EkcalUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;

/**
 * ekcalp''IntroPanel''
 * 
 * @author
 */
public class IntroPanelEkcal extends IntroPanel {
    private Logger logger = Logger.getLogger(IntroPanelEkcal.class.getName());

    /** Creates a new instance of IntroPanel */
    public IntroPanelEkcal(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    protected void updateParent(String newParentDir) {
        EkcalUtils.initializeFileNamesData(projectInfo, newParentDir);
        projectInfo.getProjectElement();
        Element element = projectInfo.getProjectElement();
        Element parentElement = null;
        java.util.List associated_dirs = element
                .getChildren("associated_directory");
        if (associated_dirs != null) {
            for (int i = 0; i < associated_dirs.size(); i++) {
                Element elem = (Element) associated_dirs.get(i);
                Attribute attr = elem.getAttribute("type");
                if (attr != null && attr.getValue().equals("parent")) {
                    parentElement = elem;
                    break;
                }
            }
        }
        String relativeDir = ciss.phase_viewer.common.Utils.getRelativePath(
                projectInfo.getProjectDirectory(), newParentDir);
        if (parentElement == null) {
            parentElement = new Element("associated_directory");
            parentElement.setText(relativeDir);
            parentElement.setAttribute(new Attribute("type", "parent"));
        } else {
            parentElement.setText(relativeDir);
        }
        ProjectDirBrowser.saveMyProjectsDocument();
        projectInfo.update();
        recreate();
    }

}
