/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.main.PhaseViewerMain;
import ciss.phase_viewer.pkg.ActivationPanel;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

//import ciss.phase_viewer.test.materialeditor.*;

public class ChaseMenu extends JMenuBar {
    private static Logger logger = Logger.getLogger(ChaseMenu.class.getName());
    private JDesktopPane desktop = Desk.getDesktop();

    private final int NEW = 0;
    private final int OLD = 1;

    private GlobalProperties propChase = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);

    private final String FS = System.getProperty("file.separator");
    private final String PS = System.getProperty("path.separator");
    private final String CR = System.getProperty("line.separator");

    private ChaseGUI root;
    private LookandFeel l_and_f;

    protected ChaseMenu(ChaseGUI root) {
        this.root = root;

        ChaseJMenuItems foo = new ChaseJMenuItems();
        JMenuItem[] items = foo.getMenuItems();
        for (int i = 0; i < items.length; i++) {
            if (items[i] != null) {
                add(items[i]);
            } else {
                add(Box.createHorizontalGlue());
            }
        }
        //
        // add(Box.createHorizontalGlue());
        // MyJMenu helpmenu = new MyJMenu("Help",KeyEvent.VK_H);
        //
        // MyJMenuItem mversion = new MyJMenuItem("Version",KeyEvent.VK_V);
        // mversion.addActionListener(new ActionListener() {
        // public void actionPerformed(ActionEvent e) {
        // bootVersionDialog();
        // }
        // });
        // helpmenu.add(mversion);
        //
        // MyJMenuItem mmanual = new MyJMenuItem("Online manual",KeyEvent.VK_M);
        // mmanual.addActionListener(new ActionListener() {
        // public void actionPerformed(ActionEvent e) {
        // org.jdom.Document doc = Main.getDefaultPropertiesDocument();
        // String helpdir =
        // doc.getRootElement().getChild("help").getChildTextTrim("htmlhelpdir");
        // String helpPath =
        // System.getProperty("pviewer.home")+FS+helpdir+FS+"index.html";
        // TextViewer browser = new TextViewer(helpPath);
        // browser.setVisible(true);
        // }
        // });
        // helpmenu.add(mmanual);
        //
        // boolean activationRequired =
        // (Boolean.valueOf(propChase.getProperty("activationRequired"))).booleanValue();
        // if ( activationRequired ) {
        // JMenuItem mactivation = new MyJMenuItem("activate product",
        // KeyEvent.VK_A);
        // mactivation.addActionListener(new ActionListener() {
        // public void actionPerformed(ActionEvent e) {
        // bootActivationPanel();
        // }
        // }
        // );
        // helpmenu.addSeparator();
        // helpmenu.add(mactivation);
        // }
        //
        // add(helpmenu);
        // createMenu();
    }

    //
    // private ProjectDirBrowser dirBrowser;
    // private void fileMenu() {
    // dirBrowser = root.getProjectDirBrowser();
    // DirBrowserMenu dirMenu = new
    // DirBrowserMenu("Project",KeyEvent.VK_P,dirBrowser);
    // this.add(dirMenu);
    // }
    //
    // private void createMenu() {
    //
    // l_and_f = new LookandFeel();
    // fileMenu();
    //
    // MyJMenu modulemenu = new MyJMenu("Module",KeyEvent.VK_M);
    // // MyJMenu elstrsubmenu = new
    // MyJMenu("Electronic structure calculation",KeyEvent.VK_E);
    // // modulemenu.add(elstrsubmenu);
    // // modulemenu.addSeparator();
    //
    // // MyJMenu networkmenu = new MyJMenu("Network tools",KeyEvent.VK_N);
    // // modulemenu.add(networkmenu);
    // MyJMenu networkmenu = modulemenu;
    // MyJMenuItem sshterminal = new MyJMenuItem("ssh terminal",KeyEvent.VK_T);
    // networkmenu.add(sshterminal);
    // sshterminal.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // Terminal term = new Terminal();
    // term.setVisible(true);
    // }
    // });
    //
    // MyJMenuItem sftpclient = new MyJMenuItem("sftp client",KeyEvent.VK_F);
    // networkmenu.add(sftpclient);
    // sftpclient.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // SftpClient sftp = new SftpClient();
    // }
    // });
    //
    // MyJMenuItem networkconfig = new
    // MyJMenuItem("configure host info",KeyEvent.VK_C);
    // networkmenu.add(networkconfig);
    // networkconfig.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // HostConfigurator configurator = new HostConfigurator();
    // }
    // });
    // modulemenu.addSeparator();
    // //
    // // MyJMenuItem filebrowse = new
    // MyJMenuItem("File browser",KeyEvent.VK_B);
    // // modulemenu.add(filebrowse);
    // // filebrowse.addActionListener(new ActionListener() {
    // // public void actionPerformed(ActionEvent e) {
    // // DefaultFileBrowser browser = new DefaultFileBrowser("local files");
    // // }
    // // });
    // //
    // // filebrowse.addActionListener(new ActionListener() {
    // // public void actionPerformed(ActionEvent e) {
    // //// JTreeTest test = new JTreeTest();
    // // GlobalProperties gp =
    // PropertiesManager.getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);
    // // String sx = gp.getProperty("project_browser_init_x");
    // // String sy = gp.getProperty("project_browser_init_y");
    // // int x = 980;
    // // int y = 630;
    // // try {
    // // x = Integer.parseInt(sx);
    // // y = Integer.parseInt(sy);
    // // } catch(NumberFormatException nfe){
    // // } catch(NullPointerException npe) {
    // // }
    // // ProjectBrowser browser = new ProjectBrowser(new Dimension(x,y));
    // // }
    // // });
    // //
    // // MyJMenuItem materialEditor = new
    // MyJMenuItem("Material editor",KeyEvent.VK_M);
    // // modulemenu.add(materialEditor);
    // // materialEditor.addActionListener(new ActionListener() {
    // // public void actionPerformed(ActionEvent e) {
    // // MaterialEditor editor = new MaterialEditor();
    // // editor.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    // // editor.setBounds( 10, 10, 600, 650);
    // // editor.setVisible(true);
    // // }
    // // });
    // //
    // // MyJMenu chasemenu = new MyJMenu("Analysis Tools",KeyEvent.VK_A);
    // //
    // // modulemenu.add(chasemenu);
    //
    // this.add(modulemenu);
    // MyJMenu chasemenu = modulemenu;
    // MyJMenuItem macv = new
    // MyJMenuItem("atomic configuration viewer",KeyEvent.VK_A);
    // macv.addActionListener( new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootACViewer();
    // }
    // });
    // chasemenu.add(macv);
    //
    // MyJMenuItem mgraph = new MyJMenuItem("graph tool",KeyEvent.VK_G);
    // mgraph.addActionListener( new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootGraphTool();
    // }
    // });
    // chasemenu.add(mgraph);
    //
    // MyJMenuItem mimageView = new MyJMenuItem("image viewer",KeyEvent.VK_I);
    // mimageView.addActionListener( new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootImageLoader();
    // }
    // });
    // chasemenu.add(mimageView);
    // MyJMenuItem mexeviewer = new
    // MyJMenuItem("BioStationViewer",KeyEvent.VK_B);
    // chasemenu.add(mexeviewer);
    // mexeviewer.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootBSV();
    // }
    // });
    //
    // MyJMenu toolmenu = new MyJMenu("External tools",KeyEvent.VK_E);
    // MyJMenuItem mexeeditor = new MyJMenuItem("Editor",KeyEvent.VK_D);
    // mexeeditor.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootEditor();
    //
    // }
    // });
    // toolmenu.add(mexeeditor);
    // toolmenu.addSeparator();
    // //
    // // MyJMenuItem mexeviewer = new
    // MyJMenuItem("BioStationViewer",KeyEvent.VK_B);
    // // toolmenu.add(mexeviewer);
    // // toolmenu.addSeparator();
    // //
    // // mexeviewer.addActionListener(new ActionListener() {
    // // public void actionPerformed(ActionEvent e) {
    // // bootBSV();
    // // }
    // // });
    //
    // MyJMenuItem mshell = new MyJMenuItem("shell",KeyEvent.VK_S);
    // toolmenu.add(mshell);
    //
    // mshell.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootProcessFrame();
    // }
    // });
    //
    // // this.add(toolmenu);
    //
    // MyJMenu processmenu = new MyJMenu("Process",KeyEvent.VK_R);
    // MyJMenuItem mprocessViewer = new
    // MyJMenuItem("Process Viewer",KeyEvent.VK_V);
    //
    // mprocessViewer.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootProcessViewer();
    // }
    // });
    // processmenu.add(mprocessViewer);
    // ProcessMenu process = new ProcessMenu("Process",KeyEvent.VK_R);
    //
    // //this.add(processmenu);
    // this.add(process);
    //
    // MyJMenu prefs = new MyJMenu("Preferences",KeyEvent.VK_F);
    // MyJMenuItem msetappl = new MyJMenuItem("program paths",KeyEvent.VK_P);
    // msetappl.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // // Utils.bootPropertyPanel();
    // ExternalProgramSelector foo = new ExternalProgramSelector();
    // }
    // });
    // prefs.add(msetappl);
    //
    // WindowMenu window = new WindowMenu("Window(s)",KeyEvent.VK_W);
    // this.add(window);
    //
    // //'look and feel' menu
    // prefs.add(l_and_f);
    // this.add(prefs);
    //
    // this.add(Box.createHorizontalGlue());
    //
    // MyJMenu helpmenu = new MyJMenu("Help",KeyEvent.VK_H);
    //
    // MyJMenuItem mversion = new MyJMenuItem("Version",KeyEvent.VK_V);
    // mversion.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootVersionDialog();
    // }
    // });
    // helpmenu.add(mversion);
    // //
    // // MyJMenuItem msupportedpp = new
    // MyJMenuItem("supported elements",KeyEvent.VK_S);
    // // msupportedpp.addActionListener(new ActionListener() {
    // // public void actionPerformed(ActionEvent e) {
    // // FixedImageViewer fv = new
    // FixedImageViewer(System.getProperty("pviewer.home")
    // // + FS + "lib"
    // // + FS + "resource"
    // // + FS + "pp_generated.png", "supported elements" );
    // // fv.setVisible(true);
    // // }
    // // });
    // // helpmenu.add(msupportedpp);
    //
    // MyJMenuItem mmanual = new MyJMenuItem("Online manual",KeyEvent.VK_M);
    // mmanual.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // org.jdom.Document doc = Main.getDefaultPropertiesDocument();
    // String helpdir =
    // doc.getRootElement().getChild("help").getChildTextTrim("htmlhelpdir");
    // String helpPath =
    // System.getProperty("pviewer.home")+FS+helpdir+FS+"index.html";
    // TextViewer browser = new TextViewer(helpPath);
    // browser.setVisible(true);
    // }
    // });
    // helpmenu.add(mmanual);
    //
    // boolean activationRequired =
    // (Boolean.valueOf(propChase.getProperty("activationRequired"))).booleanValue();
    // if ( activationRequired ) {
    // JMenuItem mactivation = new MyJMenuItem("activate product",
    // KeyEvent.VK_A);
    // mactivation.addActionListener(new ActionListener() {
    // public void actionPerformed(ActionEvent e) {
    // bootActivationPanel();
    // }
    // }
    // );
    // helpmenu.addSeparator();
    // helpmenu.add(mactivation);
    // }
    //
    // this.add(helpmenu);
    // }
    //
    // protected void setUI(String str) {
    // root.setUI(str);
    // }
    //
    // private void bootProcessViewer() {
    // if ( !ConstParameters.osName.toLowerCase().trim().startsWith("windows") )
    // {
    // ProcessViewer psv = new ProcessViewer();
    // psv.start();
    // psv.setVisible(true);
    // } else {
    // String taskmgr = propChase.getProperty("taskmgr");
    // MyThread th = new MyThread(taskmgr);
    // }
    // }

    private void bootActivationPanel() {
        ActivationPanel ap = new ActivationPanel();
        ap.display();
    }

    private void bootVersionDialog() {
        org.jdom.Document doc = PhaseViewerMain.getDefaultPropertiesDocument();
        org.jdom.Element elem = doc.getRootElement().getChild("version_dialog");

        String title = MyElement.decode(elem.getChildTextTrim("title").trim());
        String message = elem.getChildTextTrim("message");
        java.net.URL advancelogo = getClass()
                .getResource(
                        MyElement.decode(elem.getChildTextTrim("imagefilepath")
                                .trim()));

        ImageIcon icon = new ImageIcon(advancelogo);

        JOptionPane.showInternalMessageDialog(Desk.getDesktop(), message,
                title, JOptionPane.PLAIN_MESSAGE, icon);
    }

    // private void bootEditor() {
    // String editorPath = propChase.getProperty("editor");
    // MyThread th = new
    // MyThread(Utils.getPathDQ(propChase.getProperty("editor")));
    // }
    //
    // private void bootBSV() {
    // String BSVbooter = Utils.getPathDQ(ConstParameters.getJavaPath()) +
    // " -jar ";
    // BSVbooter += Utils.getPathDQ(
    // System.getProperty("pviewer.home") + FS +
    // propChase.getProperty("BioStationViewer"));
    // MyThread th = new MyThread(BSVbooter);
    // }
    //
    // private void bootACViewer() {
    // ciss.phase_viewer.acviewer.MainPanel panel = new
    // ciss.phase_viewer.acviewer.MainPanel();
    // try{
    // panel.display3D();
    // } catch(Exception exc){
    // exc.printStackTrace();
    // }
    // // PhaseInputFrame phaseinpfrm = new PhaseInputFrame(this,"acv");
    // // phaseinpfrm.displayNoInpRead();
    // }
    //
    // private void bootGraphTool() {
    // ciss.phase_viewer.graph.dataset.DataSetManipulator manip = new
    // ciss.phase_viewer.graph.dataset.DataSetManipulator();
    // /*
    // ciss.phase_viewer.graph.MainPanel mainPanel
    // = new ciss.phase_viewer.graph.MainPanel();
    // mainPanel.display();
    // */
    // }
    //
    // private void bootImageLoader() {
    // ciss.phase_viewer.imageviewer.ImageLoader imageLoader
    // = new
    // ciss.phase_viewer.imageviewer.ImageLoader(System.getProperty("user.home"));
    // imageLoader.display();
    // }
    //
    // private void bootProcessFrame() {
    // ciss.phase_viewer.scripting.BshConsole console = new
    // ciss.phase_viewer.scripting.BshConsole();
    // }
    //
}
