/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/30, 14:34
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptInterface.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.tools;

import java.awt.GridLayout;
import java.util.Date;

import org.apache.log4j.Logger;

import bsh.Interpreter;
import bsh.util.JConsole;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * bean shell XNvgLq/s.
 * 
 * @author jkoga
 */
public class ScriptInterface extends ProjectManipulator {
    private Logger logger = Logger.getLogger(ScriptInterface.class.getName());

    /** Creates a new instance of ScriptInterface */
    public ScriptInterface(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new GridLayout());
    }

    public void initializeProject() {
    }

    public void init() {
        JConsole console = new JConsole();
        Interpreter interpreter = new Interpreter(console);
        try {
            interpreter
                    .eval("importCommands(\"ciss.phase_viewer.scripting.commands\")");
            interpreter.eval("cd (\""
                    + Utils.escapeBackSlash(projectInfo.getProjectDirectory())
                    + "\")");
            interpreter.set("projectInfo", projectInfo);
            interpreter.set("date", new Date());
        } catch (Exception exc) {
            logger.error("failed to set project info to interpreter");
            exc.printStackTrace();
            return;
        }
        new Thread(interpreter).start();
        add(console);
    }

}
