/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 19:08
!  AUTHOR(S): KOGA, Junichiro
!  File : DosPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.postprocessing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.ProjectorEditor;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class DosPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(DosPanel.class.getName());

    /** Creates a new instance of DosPanel */
    public DosPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(new DosPanelPanel(projectInfo));
    }

    public void init() {
    }

    public void initializeProject() {
    }
}

class DosPanelPanel extends PhaseInputItems {
    private static Logger logger = Logger.getLogger(DosPanelPanel.class
            .getName());

    protected DosPanelPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void createGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        JPanel p_dos = new JPanel();
        // p_dos.setLayout(new GridLayout(1,3));
        p_dos.setLayout(new BoxLayout(p_dos, BoxLayout.X_AXIS));
        p_dos.setBorder(new TitledBorder("total DOS"));

        String[] pdosspec = new String[] { "postprocessing.pdos.sw_pdos" };
        ChoicePanelPhase cpppdos = new ChoicePanelPhase(pdosspec,
                inputInterface, "projected DOS", ON_OFF, ON_OFF_DUPLI, this);
        JButton btnproj = new JButton("configure projector");

        String[] dossw = { "postprocessing.dos.sw_dos" };
        ChoicePanelPhase p_dos_sw = new ChoicePanelPhase(dossw, inputInterface,
                "DOS output", ON_OFF, ON_OFF_DUPLI, this);
        p_dos_sw.registerDisabableGUI(new int[] { 0, 2 }, cpppdos);
        p_dos_sw.registerDisabableGUI(new int[] { 0, 2 }, btnproj);
        p_dos.add(p_dos_sw);

        String[] dosme = { "postprocessing.dos.method",
                "postprocessing.dos.dos_method" };

        String[] methods = { NO_SELECTION, "Gaussian", "tetrahedral" };
        Vector dupli = new Vector();
        dupli.add(new String[] { "1", "g" });
        dupli.add(new String[] { "2", "t" });
        dupli.addElement(new String[] { "2", "tetrahedoral" });
        dupli.addElement(new String[] { "2", "tetrahedron" });
        ChoicePanelPhase p_dos_method = new ChoicePanelPhase(dosme,
                inputInterface, "method", methods, dupli, this);
        p_dos.add(p_dos_method);
        String[] de = { "postprocessing.dos.deltaE_dos",
                "postprocessing.dos.deltaE" };
        InputPanelPhase ippde = new InputPanelPhase(de, inputInterface, "dE",
                InputPanelPhase.ENERGY, 7, this);
        p_dos.add(ippde);

        String[] ww = { "postprocessing.dos.nwd_dos_window_width",
                "postprocessing.dos.nwd_window_width" };
        InputPanelPhase ippww = new InputPanelPhase(ww, inputInterface,
                "window width", InputPanelPhase.NONE, 7, this);
        p_dos.add(ippww);

        int[] disabable = new int[] { 0, 2 };
        p_dos_sw.registerDisabableGUI(disabable, p_dos_method);
        p_dos_sw.registerDisabableGUI(disabable, ippww);
        p_dos_sw.registerDisabableGUI(disabable, ippde);

        String tag_ldos = "postprocessing.ldos.";
        JPanel p_aldos = new JPanel();
        p_aldos.setLayout(new BoxLayout(p_aldos, BoxLayout.X_AXIS));
        p_aldos.setBorder(new TitledBorder("atomic local DOS"));

        String tag_aldos = tag_ldos + "aldos.";
        String[] sw_aldos = new String[] { tag_ldos + "sw_aldos" };
        ChoicePanelPhase p_aldos_sw = new ChoicePanelPhase(sw_aldos,
                inputInterface, "ALDOS output", ON_OFF, ON_OFF_DUPLI, this);
        String[] crtdst = new String[] { tag_aldos + "crtdst" };
        InputPanelPhase ippcrtdst = new InputPanelPhase(crtdst, inputInterface,
                "critical distance", InputPanelPhase.LENGTH, 7, this);
        String[] naldos_from = new String[] { tag_aldos + "naldos_from" };
        InputPanelPhase ippaldos_from = new InputPanelPhase(naldos_from,
                inputInterface, "from atom", InputPanelPhase.NONE, 7, this);
        String[] naldos_to = new String[] { tag_aldos + "naldos_to" };
        InputPanelPhase ippaldos_to = new InputPanelPhase(naldos_to,
                inputInterface, "to atom", InputPanelPhase.NONE, 7, this);
        p_aldos.add(p_aldos_sw);
        p_aldos.add(ippcrtdst);
        p_aldos.add(ippaldos_from);
        p_aldos.add(ippaldos_to);
        p_aldos_sw.registerDisabableGUI(disabable, ippcrtdst);
        p_aldos_sw.registerDisabableGUI(disabable, ippaldos_from);
        p_aldos_sw.registerDisabableGUI(disabable, ippaldos_to);

        String tag_layerdos = tag_ldos + "layerdos.";
        String[] sw_layerdos = new String[] { tag_ldos + "sw_layerdos" };
        ChoicePanelPhase p_layerdos_sw = new ChoicePanelPhase(sw_layerdos,
                inputInterface, "LAYERDOS output", ON_OFF, ON_OFF_DUPLI, this);
        String[] slicing_way = new String[] { tag_layerdos + "slicing_way" };
        String[] choislway = new String[] { NO_SELECTION, "regular_intervals",
                "by_atomic_positions" };
        ChoicePanelPhase cppslway = new ChoicePanelPhase(slicing_way,
                inputInterface, "slicing_way", choislway, this);
        String[] deltaz = new String[] { tag_layerdos + "deltaz" };
        InputPanelPhase ippdeltaz = new InputPanelPhase(deltaz, inputInterface,
                "deltaz", InputPanelPhase.LENGTH, 7, this);
        String[] layer_crtdst = new String[] { tag_layerdos + "crtdst" };
        InputPanelPhase ipplayer_crtdst = new InputPanelPhase(layer_crtdst,
                inputInterface, "critical distance", InputPanelPhase.LENGTH, 7,
                this);
        String[] normal_axis = new String[] { tag_layerdos + "normal_axis" };
        String[] normal_axis_choice = new String[] { NO_SELECTION, "1", "2",
                "3" };
        ChoicePanelPhase cppnormal = new ChoicePanelPhase(normal_axis,
                inputInterface, "normal axis", normal_axis_choice, this);
        JPanel p_layerdos1 = new JPanel();
        p_layerdos1.setLayout(new BoxLayout(p_layerdos1, BoxLayout.X_AXIS));
        p_layerdos1.add(p_layerdos_sw);
        p_layerdos1.add(cppslway);
        JPanel p_layerdos2 = new JPanel();
        p_layerdos2.setLayout(new BoxLayout(p_layerdos2, BoxLayout.X_AXIS));
        p_layerdos2.add(ippdeltaz);
        p_layerdos2.add(ipplayer_crtdst);
        p_layerdos2.add(cppnormal);
        JPanel p_layerdos = new JPanel();
        p_layerdos.setLayout(new BoxLayout(p_layerdos, BoxLayout.Y_AXIS));
        p_layerdos.setBorder(new TitledBorder("layer DOS"));
        p_layerdos.add(p_layerdos1);
        p_layerdos.add(p_layerdos2);
        p_layerdos_sw.registerDisabableGUI(disabable, ippdeltaz);
        p_layerdos_sw.registerDisabableGUI(disabable, ipplayer_crtdst);
        p_layerdos_sw.registerDisabableGUI(disabable, cppnormal);
        p_layerdos_sw.registerDisabableGUI(disabable, cppslway);

        JPanel p_pdos = new JPanel();
        p_pdos.setLayout(new BoxLayout(p_pdos, BoxLayout.X_AXIS));
        p_pdos.add(cpppdos);
        JPanel pbtnproj = new JPanel();
        pbtnproj.add(btnproj);
        p_pdos.add(btnproj);

        cpppdos.registerDisabableGUI(new int[] { 0, 2 }, btnproj);

        btnproj.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bootEditor();
            }
        });

        JScrollPane scr = new JScrollPane();
        String[] atmtable = new String[] { "structure.atom_list.atoms" };
        int[] map = { 0, 1, 2, 3, 4, 7, 8 };
        TableForInputInterface tfii = new TableForInputInterface(atmtable,
                inputInterface, map, this);
        scr.getViewport().setView(tfii.getPanel());
        scr.setPreferredSize(new Dimension(500, 150));
        p.add(p_dos);
        p.add(p_aldos);
        p.add(p_layerdos);
        p.add(p_pdos);
        p.add(scr);
        add(p);
    }

    private void bootEditor() {
        ProjectorEditor editor = new ProjectorEditor(super.projectInfo);
    }

}
