/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/22, 17:23
!  AUTHOR(S): KOGA, Junichiro
!  File : Monitorable.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.file;

import javax.swing.JTextArea;

import ciss.phase_viewer.jobcontrol.MonitorPanelInterface;

import com.jcraft.jsch.Session;

/**
 * WusɁuĎ\vȃt@C͂̃C^[tF[X. JobMonitorerȂNXŗp?
 * 
 * @author
 */
public interface Monitorable {

    /**
     * ̃\bhĂ΂ꂽ烂j^[Jn.
     * 
     * @param session
     *            j^[ɕKvȃZbV; null̏ꍇ͂Ԃlocalhost.
     * @param textArea
     *            ʂ֏o.
     */
    public void monitor(Session session, JTextArea textArea);

    /**
     * j^[𒆎~郁\bh.
     */
    public void stopMonitor();

    /**
     * j^[Ă錋ʂɃOt쐬.
     * 
     * @param textArea
     *            ̃eLXgR|[lg̓eQƂăOt𓮓Iɍ쐬.
     */
    public void createGraphFrom(JTextArea textArea);

    /**
     * Ot\. KȂ΂ȂȂ, ƂقǂłȂ?
     */
    public void destroyGraph();

    /**
     * , ̃t@Cuj^[\vȂΐ^Ԃ.
     * 
     * @return j^[\ȏꍇtrue.
     */
    public boolean isMonitorable();

    /**
     * , Ot쐬邱Ƃ\Ȃΐ^Ԃ.
     * 
     * @param textArea
     *            ̃eLXgR|[lg̏񂩂画f.
     * @return Ot쐬\ȏꍇ͐^.
     */
    public boolean isGraphCreatable(JTextArea textArea);

    /**
     * j^[t@C擾.
     * 
     * @return ΏۂƂȂt@C
     */
    public ChaseFile getChaseFile();

    /**
     * "j^[pGUI"Zbg
     * 
     * @param j^[pGUI
     *            .
     */
    public void setMonitorPanel(MonitorPanelInterface monitorPanel);
}
