/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Atom.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class Atom extends BranchGroup {
    private AtomObject parent;
    private AtomSphere sphere;
    private GlobalProperties gp = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    protected Atom(float radius, int primflags, int divisions, Appearance ap,
            AtomObject parent) {
        super();
        this.parent = parent;
        setCapability(BranchGroup.ALLOW_DETACH);
        setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        if (parent.getAtomRenderingMethod().equals(
                J3DDataManager.ATOM_RENDERING_METHODS[1])) {
            Material mat = ap.getMaterial();
            Color3f c = new Color3f();
            mat.getDiffuseColor(c);
            AtomFilledCircle circ = new AtomFilledCircle(parent, radius, c);
            addChild(circ);
        } else if (parent.getAtomRenderingMethod().equals(
                J3DDataManager.ATOM_RENDERING_METHODS[0])) {
            sphere = new AtomSphere(radius, primflags, divisions, ap, parent);

            addChild(sphere);
        }
    }

    protected AtomObject getAtomObject() {
        return this.parent;
    }

    private boolean isTemp = false;

    protected void isTemp(boolean isTemp) {
        this.isTemp = isTemp;
    }

    public boolean isTemp() {
        return this.isTemp;
    }

}

class Circle extends BranchGroup {

    private Shape3D circle;

    private float radius = 0.5f;
    private int resolution = 512;
    private int length = resolution + 1;
    private float resolutionh = (float) resolution * 0.5f;

    protected Circle(float radius, int resolution) {
        this.radius = radius;
        this.resolution = resolution;

        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(BranchGroup.ALLOW_CHILDREN_READ);

        this.circle = createCircle();
        OrientedShape3D oscircle = new OrientedShape3D(circle.getGeometry(),
                circle.getAppearance(), OrientedShape3D.ROTATE_ABOUT_POINT,
                new Point3f(0.0f, 0.0f, 0.0f));
        this.addChild(oscircle);
    }

    protected Circle(float radius) {
        this.radius = radius;
        this.circle = createCircle();

        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        OrientedShape3D oscircle = new OrientedShape3D(circle.getGeometry(),
                circle.getAppearance(), OrientedShape3D.ROTATE_ABOUT_POINT,
                new Point3f(0.0f, 0.0f, 0.0f));
        this.addChild(oscircle);
    }

    public Shape3D getCircle() {
        return circle;
    }

    private Shape3D createCircle() {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(0.9f, 0.9f,
                0.5f, ColoringAttributes.NICEST));

        LineAttributes lineAttrib = new LineAttributes();
        lineAttrib.setLineWidth(5.0f);
        appearance.setLineAttributes(lineAttrib);

        LineStripArray lsa = new LineStripArray(length,
                GeometryArray.COORDINATES, new int[] { length });
        Point3f pt0 = new Point3f(radius, 0.0f, 0.0f);
        lsa.setCoordinate(0, pt0);
        Point3f pt = new Point3f();
        for (int i = 1; i < resolution; i++) {
            pt.x = (float) (radius * Math.cos(i * Math.PI / resolutionh));
            pt.y = (float) (radius * Math.sin(i * Math.PI / resolutionh));
            lsa.setCoordinate(i, pt);
        }
        lsa.setCoordinate(resolution, pt0);
        Shape3D circle = new Shape3D(lsa, appearance);
        try {
            lsa.setCapability(Geometry.ALLOW_INTERSECT);
        } catch (RestrictedAccessException rae) {
        }
        return circle;
    }

}
