/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 14:38
!  AUTHOR(S): KOGA, Junichiro
!  File : StructuralEvolutionPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.TabbedProjectManipulator;

/**
 * F_ENFt@C̕\.
 * 
 * @author KOGA, Junichiro
 */
public class StructuralEvolutionPanel extends ProjectManipulator implements
        OutputParserListener {
    private Logger logger = Logger.getLogger(StructuralEvolutionPanel.class
            .getName());
    private OutputData output;

    /** Creates a new instance of EnergyPanel */
    public StructuralEvolutionPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void parseFinished() {
        removeAll();
        try {
            output = projectInfo.getOutputInterface().getParser("F_ENF", this)
                    .getOutputData()[0];
            // output = parser.getOutputData()[0];
        } catch (NullPointerException npe) {
            return;
        }
        if (output == null) {
            return;
        }
        add(firstRow());

        add(projectInfo.getOutputInterface().getDataPanel("F_ENF"));
        revalidate();
    }

    private OutputParser parser;
    private ChaseFile cf;

    public void init() {
        try {
            // add(firstRow());
            java.net.URL url = getClass()
                    .getResource(
                            "/ciss/phase_viewer/plugins/projectmanipulator/phase/resultsviewerpanel/tabbed_mainpulator_trj.xml");

            JPanel pa = new JPanel();
            pa.setLayout(new BoxLayout(pa, BoxLayout.Y_AXIS));
            TabbedProjectManipulator tpane = new TabbedProjectManipulator(url,
                    projectInfo);
            pa.add(tpane);
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            add(tpane);

        } catch (Exception exc) {
            exc.printStackTrace();
        }
        // setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        // cf = projectInfo.getChaseFileManager().getFile("F_ENF");
        // String fname =
        // projectInfo.getProjectDirectory()+System.getProperty("file.separator")+cf.getFileName();
        // if ( !new File(fname).exists() ) {
        // add(new NoFilePanel("F_ENF"));
        // return;
        // }
        // add(new LoadingFilePanel("F_ENF"));
        // if ( parser == null ) {
        // parser = projectInfo.getOutputInterface().getParser("F_ENF",this);
        // }
        // parser.setParsed(false);
        // parser.doParse();
    }

    public void initializeProject() {
    }

    private String nfdynmdata;

    private JPanel firstRow() {
        JPanel panel = new JPanel();
        // panel.setBorder(new TitledBorder("info"));
        // panel.setLayout(new BoxLayout(panel,BoxLayout.X_AXIS));
        //
        // //JPanel pfile = new JPanel();
        // //pfile.setBorder(new TitledBorder("file name"));
        // cf = projectInfo.getChaseFileManager().getFile("F_ENF");
        // //JLabel file = new JLabel(cf.getFileName());
        // //pfile.add(file);
        //
        // int nsteps = output.getData2D().length;
        // int ndata = output.getIdentifier().length;
        //
        // JPanel pnumsteps = new JPanel();
        // pnumsteps.setBorder(new TitledBorder("num. steps"));
        // JLabel numsteps = new JLabel(String.valueOf(nsteps));
        // pnumsteps.add(numsteps);
        //
        // JPanel ptype = new JPanel();
        // ptype.setBorder(new TitledBorder("type"));
        // String strtype = "static calculation";
        // if ( nsteps > 1 && ndata ==4 ) {
        // strtype = "geom. optimization";
        // }
        // if ( nsteps > 1 && ndata > 4 ) {
        // strtype = "molecular dynamics";
        // }
        // JLabel type = new JLabel(strtype);
        // ptype.add(type);
        //
        // JButton btn = new JButton("boot editor");
        //
        // btn.addActionListener(new ActionListener() {
        // public void actionPerformed(ActionEvent e) {
        // ProjectBrowserUtils.bootTextViewer(projectInfo.getProjectDirectory()
        // +System.getProperty("file.separator")+cf.getFileName());
        // }
        // });
        //
        // //panel.add(pfile);
        // panel.add(pnumsteps);
        // panel.add(ptype);
        // //panel.add(btn);
        //
        // JPanel pdynm = new JPanel();
        // this.nfdynmdata =
        // projectInfo.getChaseFileManager().getFile("F_DYNM").getFileName();
        // pdynm.setBorder(new TitledBorder("trajectory file : "+nfdynmdata));
        // pdynm.setLayout(new BoxLayout(pdynm,BoxLayout.X_AXIS));
        // JButton viewerbtn = new JButton("boot viewer");
        // JButton exportbtn = new JButton("export");
        // JButton diffbtn = new JButton("diff");
        // pdynm.add(viewerbtn);
        // pdynm.add(exportbtn);
        // pdynm.add(diffbtn);
        // panel.add(pdynm);

        return panel;
    }

}
