/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/10, 20:14
!  AUTHOR(S): KOGA, Junichiro
!  File : MDConfig.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * q͊wV~[VݒpGUI
 */
public class UnitCellConfig extends InternalFrameChase {
    private Logger logger = Logger.getLogger(UnitCellConfig.class.getName());
    private ProjectInfo projectInfo;
    private InputInterface inputInterface;
    private UnitCellPanel pan;

    /** Creates a new instance of MDConfig */
    public UnitCellConfig(ProjectInfo projectInfo) {
        super("MD config", true, true, true, true, new Dimension(400, 120));
        try {
            this.projectInfo = projectInfo;
            this.inputInterface = projectInfo.getInputInterface();
            JPanel p = new JPanel();
            pan = new UnitCellPanel(inputInterface);
            p.add(pan);
            getContentPane().add(p);
            addInternalFrameListener(new InternalFrameAdapter() {
                public void internalFrameClosed(InternalFrameEvent e) {
                    pan.exit();
                }
            });
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    class UnitCellPanel extends PhaseInputItems {
        UnitCellPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        private TableForInputInterface tfii;

        public void createGUI() {
            JPanel panel = new JPanel();

            String[] optlat = new String[] { "structure_evolution.lattice.sw_optimize_lattice" };
            CheckPanelPhase cppoptlat = new CheckPanelPhase(optlat,
                    inputInterface, "optimize lattice", this, false);
            CheckPanelPhase cppuniform = new CheckPanelPhase(
                    new String[] { "structure_evolution.lattice.sw_uniform" },
                    inputInterface, "uniform transformation", this, false);
            CheckPanelPhase cpprebuild = new CheckPanelPhase(
                    new String[] { "structure_evolution.lattice.sw_rebuild_pws" },
                    inputInterface, "rebuild pws", this, true);
            JPanel pp = new JPanel();
            pp.add(cppoptlat);
            pp.add(cppuniform);
            pp.add(cpprebuild);

            JPanel btn = new JPanel();
            JButton dismiss = new JButton("dismiss");
            dismiss.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            });
            btn.add(dismiss);

            panel.setLayout(new BorderLayout());
            panel.add(pp, BorderLayout.CENTER);
            panel.add(btn, BorderLayout.SOUTH);

            add(panel);
        }

        void exit() {
            inputInterface
                    .removeInputInterfaceEntryChangeListener((InputInterfaceEntryChangeListener) tfii
                            .getModel());
        }
    }

}
