/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : SolverPanelPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.GUIBootButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;

public class SolverPanelPanel extends PhaseInputItems implements
        InputInterfaceEntryChangeListener {
    private TableForInputInterface solverTable;

    public SolverPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        inputInterface.addInputInterfaceEntryChangeListener(this);
        // setPreferredSize(new Dimension(500,250));
        setLayout(new GridLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        // p.setPreferredSize(new Dimension(600, 350));

        JPanel p_solver = new JPanel();
        p_solver.setLayout(new BoxLayout(p_solver, BoxLayout.X_AXIS));

        String[] specSolver = { "wavefunction_solver.solvers",
                "wf_solver.solvers" };

        solverTable = new TableForInputInterface(specSolver, inputInterface,
                this);

        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(solverTable.getPanel());
        scrPane.setPreferredSize(new Dimension(500, 150));
        p_solver.add(scrPane);
        p.add(p_solver);

        JPanel p_solnew = new JPanel();
        p_solnew.setLayout(new GridLayout(2, 3, 1, 1));
        p_solnew.setBorder(new TitledBorder("new solver"));

        String[] dummyArray = { "" };
        String[] solverChoice = { "matrixdiagon", "lm+msd", "rmm3", "davidson",
                "mddavidson" };
        Vector solverChoiceDupli = new Vector();
        solverChoiceDupli.addElement(new String[] { "1", "lmmsd" });

        ChoicePanelPhase cppsol = new ChoicePanelPhase(dummyArray,
                inputInterface, "sol", solverChoice, solverChoiceDupli);
        InputPanelPhase ipptilln = new InputPanelPhase(dummyArray,
                inputInterface, "till_n", InputPanelPhase.NONE, 5);
        // InputPanelPhase ippdts = new
        // InputPanelPhase(dummyArray,inputInterface,"dts",InputPanelPhase.NONE,5);
        // InputPanelPhase ippdte = new
        // InputPanelPhase(dummyArray,inputInterface,"dte",InputPanelPhase.NONE,5);
        // InputPanelPhase ippitr = new
        // InputPanelPhase(dummyArray,inputInterface,"itr",InputPanelPhase.NONE,5);
        // String[] varChoice = {"linear","tanh","default"};
        // ChoicePanelPhase cppvar = new ChoicePanelPhase(dummyArray,
        // inputInterface, "var", varChoice);
        String[] on_off_FORCE = { "on", "off" };
        ChoicePanelPhase cppprec = new ChoicePanelPhase(dummyArray,
                inputInterface, "prec", on_off_FORCE);
        InputPanelPhase ippcmix = new InputPanelPhase(dummyArray,
                inputInterface, "cmix", InputPanelPhase.NONE, 5);
        ChoicePanelPhase cppsubmat = new ChoicePanelPhase(dummyArray,
                inputInterface, "submat", on_off_FORCE);

        p_solnew.add(cppsol);
        p_solnew.add(ipptilln);
        // p_solnew.add(ippdts);
        // p_solnew.add(ippdte);
        // p_solnew.add(ippitr);
        // p_solnew.add(cppvar);
        p_solnew.add(cppprec);
        p_solnew.add(ippcmix);
        p_solnew.add(cppsubmat);

        p.add(p_solnew);

        JPanel p_solbtn = new JPanel();
        p_solbtn.setLayout(new BoxLayout(p_solbtn, BoxLayout.X_AXIS));

        // PhaseInputPanelInterface[] guis =
        // {cppsol,ipptilln,ippdts,ippdte,ippitr,cppvar,cppprec,ippcmix,cppsubmat};
        PhaseInputPanelInterface[] guis = { cppsol, ipptilln, cppprec, ippcmix,
                cppsubmat };
        AddButton addButton = new AddButton(solverTable, guis, this);
        DeleteButton deleteButton = new DeleteButton(solverTable, this);
        JButton btnselect = new JButton("from file");

        p_solbtn.add(addButton);
        p_solbtn.add(deleteButton);
        p_solbtn.add(btnselect);

        GUIBootButton btnsoldtl = new GUIBootButton("solver detail ...",
                inputInterface, SolverDetails.class, this);
        p_solbtn.add(btnsoldtl);

        p.add(p_solbtn);

        btnselect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                fromFile(InputInterface.__ROOT__, "wavefunction_solver");
            }
        });
        this.add(p);
    }

    private void chooser() {
        // ChaseFileChooser chooser = new
        // ChaseFileChooser(ChaseFileChooser.input,true);
        // chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        //
        // if (chooser.showDialog(this, "open") != JFileChooser.APPROVE_OPTION)
        // {
        // return;
        // }
        //
        // String path = chooser.getSelectedFile().getAbsolutePath();
        // DataManager manager = new DataManager(path,PhaseConstants.TABLESPEC);
        // manager.parse();
        // InputInterface inputFrom = manager.getInputInterface();
        // inputInterface.swapBlock(InputInterface.__ROOT__,"wavefunction_solver",inputFrom);
        // recreate();
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        String tag = e.getTag();
        if (!tag.equalsIgnoreCase("charge_mixing.mixing_methods")) {
            return;
        }
        Utils.stop(solverTable);
        solverTable.updateCellEditor(3);
    }

    public void inputInterfaceInitializing() {
    }

    public void inputInterfaceInitialized() {
    }
}
