/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 13:19
!  AUTHOR(S): KOGA, Junichiro
!  File : ControlPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.GridLayout;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ControlPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(ControlPanel.class.getName());

    /** Creates a new instance of ControlPanel */
    public ControlPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new GridLayout());
    }

    public void init() {
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(
                new ControlPanelPanel(projectInfo.getInputInterface()));
        add(scr);
    }

    public void initializeProject() {
    }

}

class ControlPanelPanel extends PhaseInputItems {
    public ControlPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        JPanel p = new JPanel();
        // p.setLayout(new FlowLayout(FlowLayout.CENTER));
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        // p.setSize(500, 250);

        JPanel p1 = new JPanel();
        String[] control_cpumax = { "control.cpumax" };
        InputPanelPhase ippcpumax = new InputPanelPhase(control_cpumax,
                inputInterface, "Max CPU time", InputPanelPhase.LONGTIME, 7,
                this);
        p1.add(ippcpumax);

        String[] control_condition = { "control.condition", "control.cond" };
        String[] choices = { NO_SELECTION, "preparation", "automatic",
                "Initial", "Continuation", "Fixed_charge",
                "Fixed_charge_continuation" };

        Vector dupli = new Vector();
        dupli.addElement(new String[] { "1", "0" });
        dupli.addElement(new String[] { "2", "1" });
        dupli.addElement(new String[] { "3", "2" });
        dupli.addElement(new String[] { "4", "3" });
        dupli.addElement(new String[] { "5", "4" });

        ChoicePanelPhase cppcondition = new ChoicePanelPhase(control_condition,
                inputInterface, "Condition", choices, dupli, this);
        p1.add(cppcondition);

        String[] control_maxit = { "control.max_iteration" };
        InputPanelPhase p_max_iteration = new InputPanelPhase(control_maxit,
                inputInterface, "Max iterations", InputPanelPhase.NONE, 7, this);

        String[] cachesize = { "control.cachesize" };
        InputPanelPhase pcache = new InputPanelPhase(cachesize, inputInterface,
                "cachesize", InputPanelPhase.NONE, 7, this);
        p1.add(p_max_iteration);

        JPanel p2 = new JPanel();

        // p2.add(pcache);

        String[] driver = { "control.driver" };
        String[] choice_driver = null;
        choice_driver = new String[] { NO_SELECTION, "general", "constraints",
                "neb" };
        ChoicePanelPhase cppdriver = new ChoicePanelPhase(driver,
                inputInterface, "driver", choice_driver, this);
        p1.add(cppdriver);

        p.add(p1);
        // p.add(p2);

        this.add(p);
    }

}
