/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/20, 16:28
!  AUTHOR(S): KOGA, Junichiro
!  File : EpsilonManipulator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator;

import java.io.File;
import java.net.URL;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.EpsilonInitializer;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.UvsorEpsilonFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.EffectiveMass;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.StaticTensor;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout.StdoutGeneral;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.scripting.ScriptWrapper;

/**
 * UVSOR-Epsilon𐧌䂷GUI
 * 
 * @author
 */
public class EpsilonManipulator extends ProjectManipulatorBase {
    private Logger logger = Logger
            .getLogger(EpsilonManipulator.class.getName());

    /** Creates a new instance of EpsilonManipulator */
    public EpsilonManipulator(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    protected URL getSubSelectorURL() {
        return getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/manipulator_sub_selector_properties.xml");
    }

    protected URL getProgramDescriptionURL() {
        return getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/intropanel/uvsor.htm");
    }

    public void initializeProject() {
    }

    public void initializeProject(ProjectDirBrowserNode node) {
        EpsilonInitializer initializer = new EpsilonInitializer(projectInfo,
                this, node);
    }

    private String scriptDir = baseScriptDir+"uvsor-epsilon";

    public boolean createDefaultScript() {
        ScriptWrapper[] defaults = getDefaultScripts();
        for (int i = 0; i < defaults.length; i++) {
            if (new File(defaults[i].getPath()).exists()) {
                continue;
            }
            String name = new File(defaults[i].getPath()).getName();
            try {
                ciss.phase_viewer.common.ExternalProgramExecuter.copy(scriptDir
                        + System.getProperty("file.separator") + name,
                        defaults[i].getPath());
            } catch (Exception exc) {
                exc.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public ScriptWrapper[] getDefaultScripts() {
        ScriptWrapper[] defaults = new ScriptWrapper[REGISTERED_SCRIPT_TYPE.length];
        String prefix = "submit.";
        String FS = System.getProperty("file.separator");
        for (int i = 0; i < REGISTERED_SCRIPT_TYPE.length; i++) {
            defaults[i] = new ScriptWrapper(baseDir + FS + prefix
                    + REGISTERED_SCRIPT_TYPE[i], REGISTERED_SCRIPT_TYPE[i]);
        }
        return defaults;
    }

    private URL phaseSpec = PhaseConstants.FILEINFO_PHASE;
    private ciss.phase_viewer.file.ChaseFileManager cfManager;

    protected ciss.phase_viewer.file.ChaseFileManager getChaseFileManager() {
        File fnamesData = new File(projectInfo.getProjectDirectory()
                + System.getProperty("file.separator") + "file_names.data");
        if (cfManager == null) {
            cfManager = new UvsorEpsilonFileManager(phaseSpec, fnamesData);
        }
        cfManager.setFileSpecFile(fnamesData);
        return cfManager;
    }

    protected String getType() {
        getChaseFileManager();
        return cfManager.getName();
    }

    protected Class[] getStdoutGUIs() {
        return new Class[] { StdoutGeneral.class, StaticTensor.class,
                EffectiveMass.class };
    }

}
