/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Main.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.main;

import java.io.File;
import java.util.HashMap;

import org.apache.log4j.PropertyConfigurator;
import org.jdom.Document;

import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.mainpanel.Chase;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.scripting.ScriptUtils;

import com.jb2works.reference.HttpScanner;

/**
 * {vOmain\bh񋟂NX. static\bhmain̂.
 * 
 * @author KOGA Junichiro,
 */
public class PhaseViewerMain {
	/**
	 * ɉăgbvxGUĨNXCX^X.
	 * 
	 * @param args
	 *            [] R}hC̈, ڂ̈``false'' ̏ꍇÑXvbVXN[𖳌ɂł. ܂,
	 *            ȏ݂̈, ڂ̈``debug''̏ꍇfobO[hŋN. fobO[hł,
	 *            HttpScannerc[ɂq[v͂ȂǂsƂ ł悤ɂȂ. HttpScannerɂĂ
	 *            http://jb2works.com/ QƂ.
	 */
	private static Chase window;
	// private static Logger logger = Logger.getLogger(Main.class.getName());
	private static Document doc;

	public static void main(String args[]) {
		java.util.Locale.setDefault(new java.util.Locale("en", "US"));
		// System.setProperty("file.encoding","SHIFT_JIS");
		String chasehome = System.getProperty("pviewer.home");
		if (chasehome != null && chasehome.trim().length() != 0) {
			System.setProperty("java.library.path", chasehome + System.getProperty("file.separator") + "lib");
		} else {
			if (args.length != 0) {
				chasehome = args[0];
				System.setProperty("pviewer.home", chasehome);
			} else {
				java.io.File chasejar = new java.io.File(System.getProperty("java.class.path"));
				if (!chasejar.isAbsolute()) {
					chasejar = new java.io.File(
							System.getProperty("user.dir") + System.getProperty("file.separator") + chasejar.getPath());
				}
				chasehome = chasejar.getParentFile().getParent();
				System.setProperty("pviewer.home", chasehome);
			}
		}

		if (args.length >= 2 && args[0].trim().equalsIgnoreCase("interpreter_mode")) {
			HashMap map = new HashMap();
			map.put("parent", new PhaseViewerMain());
			map.put("loader", new PluginLoader());

			String log4j = chasehome + System.getProperty("file.separator") + "lib"
					+ System.getProperty("file.separator") + "log4j_script.properties";
			if (new File(log4j).exists())
				PropertyConfigurator.configure(log4j);

			String[] scripts = new String[args.length - 1];
			for (int i = 1; i < args.length; i++)
				scripts[i - 1] = args[i];

			ScriptUtils.runScript(scripts, map);

			System.exit(0);
		} else {
			String log4jfile = chasehome + System.getProperty("file.separator") + "lib"
					+ System.getProperty("file.separator") + "log4j.properties";
			if (!new File(log4jfile).exists()) {
				java.net.URL log4j = PhaseViewerMain.class.getClass()
						.getResource("/ciss/phase_viewer/main/log4j.properties");
				PropertyConfigurator.configure(log4j);
			} else {
				PropertyConfigurator.configure(log4jfile);
			}
		}

		if (args.length >= 2) {
			if (args[1].trim().equalsIgnoreCase("debug")) {
				HttpScanner.start(window);
			}
		}

		if (args.length == 0) {
			window = new Chase(true);
		} else if (args[0].trim().equalsIgnoreCase("true")) {
			window = new Chase(true);
		} else if (args[0].trim().equalsIgnoreCase("false")) {
			window = new Chase(false);
		} else {
			window = new Chase(true);
		}

	}

	public static ChaseGUI getRootFrame() {
		return Chase.getGUI();
	}

	/**
	 * {IɕύXz肵ȂvpeB[i[DocumentIuWFNgԂ(Singleton)
	 * 
	 * @return Singleton object. g,
	 *         /ciss/phase_viewer/main/properties.xmlȂt@CQƂ邱.
	 */
	public static Document getDefaultPropertiesDocument() {
		if (doc == null) {
			doc = XMLUtils.getDocumentFromURL(
					PhaseViewerMain.class.getClass().getResource("/ciss/phase_viewer/main/properties.xml"));
		}
		return doc;
	}

	/**
	 * ꉞ, Constructorp... gƂ?
	 */
	public PhaseViewerMain() {
	}

	public java.net.URL getURL(String string) {
		java.net.URL url = PhaseViewerMain.class.getResource(string);
		System.out.println(url);
		return this.getClass().getResource(string);
	}

}
