/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/17, 17:17
!  AUTHOR(S): KOGA, Junichiro
!  File : DataSetElement.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.dataset;

import org.apache.log4j.Logger;

/**
 * uf[^Zbgv̗vf.
 * 
 * @author
 */
public class DataSetElement {
    private Logger logger = Logger.getLogger(DataSetElement.class.getName());
    private String[] data;
    private String identifier;
    private DataSet parent;

    /**
     * @param data
     *            ꎟz̃f[^
     * @param identifier
     *            ̃f[^̎ʎq
     */
    public DataSetElement(String[] data, String identifier, DataSet parent) {
        this.data = data;
        this.identifier = identifier;
        this.parent = parent;
    }

    public String[] getData() {
        return data;
    }

    public String getName() {
        return identifier;
    }

    public String getFullName() {
        return parent.getName() + "." + identifier;
    }

    public DataSet getParent() {
        return this.parent;
    }

    public String toString() {
        return identifier;
    }

}
