/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/31, 11:06
!  AUTHOR(S): KOGA, Junichiro
!  File : ACVMultipleAtomEditorPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;

/**
 * 
 * @author
 */
class ACVMultipleAtomEditorPanel extends javax.swing.JPanel {
    private Logger logger = Logger.getLogger(ACVMultipleAtomEditorPanel.class
            .getName());
    private ACVMultipleAtomEditor parent;

    protected ACVMultipleAtomEditorPanel(ACVMultipleAtomEditor parent) {
        this.parent = parent;
        initAttrEditors();
        initComponents();
    }

    private void initAttrEditors() {
        InputInterfaceTableColumns[] columns = parent.getParentFrame()
                .getData().getTableColums();
        if (columns == null && columns.length == 0) {
            logger.error("invalid TableSpec file.");
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        int editor_per_row = 4;
        int editor_count = 0;
        JPanel prow = null;
        for (int i = 0; i < columns.length; i++) {
            if (!columns[i].hasApplytoAll()) {
                continue;
            }
            if (editor_count % editor_per_row == 0) {
                prow = new JPanel();
                prow.setLayout(new GridLayout(1, editor_per_row));
                logger.info("adding prow");
                p.add(prow);
                editor_count = 0;
            }
            JPanel pedi = new JPanel();
            pedi.setBorder(new TitledBorder(columns[i].getName()));
            if (columns[i].getCellEditor() == InputInterfaceTableColumns.TEXT_FIELD) {
                JTextField text = new JTextField(5);
                pedi.add(text);
            } else if (columns[i].getCellEditor() == InputInterfaceTableColumns.CHECK_BOX) {
                JCheckBox check = new JCheckBox(columns[i].getName());
                pedi.add(check);
            } else if (columns[i].getCellEditor() == InputInterfaceTableColumns.COMBO_BOX) {
                JComboBox box = new JComboBox(columns[i].getChoices());
                pedi.add(box);
            }
            prow.add(pedi);
            editor_count++;
        }
        add(p);
        revalidate();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed"
    // desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jTextField5 = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        editY = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        editZ = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        editX = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();
        applyButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();

        jTextField5.setText("0.0");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "Translation",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 0, 12), new java.awt.Color(0,
                        51, 102)));
        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "y", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 2, 12)));
        editY.setText("0.0");
        editY.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editYActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(
                jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(editY,
                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 100,
                Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.LEADING,
                jPanel4Layout
                        .createSequentialGroup()
                        .add(editY,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                Short.MAX_VALUE)));

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "z", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 2, 12)));
        editZ.setText("0.0");

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(
                jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(editZ,
                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 100,
                Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.LEADING,
                jPanel5Layout
                        .createSequentialGroup()
                        .add(editZ,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                Short.MAX_VALUE)));

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "x", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 2, 12)));
        editX.setText("0.0");

        org.jdesktop.layout.GroupLayout jPanel6Layout = new org.jdesktop.layout.GroupLayout(
                jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(editX,
                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 100,
                Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.LEADING,
                jPanel6Layout
                        .createSequentialGroup()
                        .add(editX,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                Short.MAX_VALUE)));

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(
                jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.LEADING,
                jPanel1Layout
                        .createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel6,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(20, 20, 20)
                        .add(jPanel4,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(
                                org.jdesktop.layout.LayoutStyle.RELATED, 17,
                                Short.MAX_VALUE)
                        .add(jPanel5,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap()));
        jPanel1Layout
                .setVerticalGroup(jPanel1Layout
                        .createParallelGroup(
                                org.jdesktop.layout.GroupLayout.LEADING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel1Layout
                                        .createSequentialGroup()
                                        .add(jPanel1Layout
                                                .createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.TRAILING,
                                                        false)
                                                .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                        jPanel5)
                                                .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                        jPanel4).add(jPanel6))
                                        .addContainerGap()));

        closeButton.setText("close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        applyButton.setText("apply");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });

        deleteButton.setText("delete selected atoms");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(
                jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                jPanel2Layout
                        .createSequentialGroup()
                        .addContainerGap(
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                Short.MAX_VALUE)
                        .add(applyButton)
                        .addPreferredGap(
                                org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(deleteButton)
                        .addPreferredGap(
                                org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(closeButton).addContainerGap()));
        jPanel2Layout
                .setVerticalGroup(jPanel2Layout
                        .createParallelGroup(
                                org.jdesktop.layout.GroupLayout.LEADING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                jPanel2Layout
                                        .createSequentialGroup()
                                        .addContainerGap()
                                        .add(jPanel2Layout
                                                .createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(closeButton)
                                                .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                        jPanel2Layout
                                                                .createParallelGroup(
                                                                        org.jdesktop.layout.GroupLayout.BASELINE)
                                                                .add(applyButton)
                                                                .add(deleteButton)))
                                        .addContainerGap(
                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                Short.MAX_VALUE)));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
                this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.LEADING,
                        layout.createSequentialGroup()
                                .add(layout
                                        .createParallelGroup(
                                                org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                layout.createSequentialGroup()
                                                        .addContainerGap()
                                                        .add(jPanel1,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                        .add(org.jdesktop.layout.GroupLayout.LEADING,
                                                layout.createSequentialGroup()
                                                        .add(69, 69, 69)
                                                        .add(jPanel2,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                .addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.LEADING,
                layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel1,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                81,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(
                                org.jdesktop.layout.LayoutStyle.RELATED, 14,
                                Short.MAX_VALUE)
                        .add(jPanel2,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap()));
    }

    // </editor-fold>//GEN-END:initComponents

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_deleteButtonActionPerformed
        // TODO add your handling code here:
        deleteAll();
    }// GEN-LAST:event_deleteButtonActionPerformed

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_applyButtonActionPerformed
        // TODO add your handling code here:
        doTranslation();
        parent.getParentFrame().getCD().update();
        revalidate();
    }// GEN-LAST:event_applyButtonActionPerformed

    private void deleteAll() {
        CoordsViewerInterface parentFrame = parent.getParentFrame();
        TGAtom tgatom = (TGAtom) parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = parent.getParentFrame().getCD().getAtomCoords();
        Vector indexVector = new Vector();
        for (int i = 0; i < atoms.length; i++) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            indexVector.addElement(new Integer(id));
        }
        if (indexVector.size() == 0) {
            return;
        }
        Integer[] indeces = new Integer[indexVector.size()];
        indexVector.copyInto(indeces);
        Arrays.sort(indeces);
        for (int i = indeces.length - 1; i >= 0; i--) {
            coords.getAtomList().removeAtomAt(indeces[i].intValue());
        }

        coords.getAtomList().setUndoCount(atoms.length);
        parent.getParentFrame().getCD().setCoords(coords);
        tgatom.deselectAll();
        parent.dispose();
    }

    private void doTranslation() {
        double x = 0.d;
        double y = 0.d;
        double z = 0.d;

        try {
            x = Double.parseDouble(editX.getText());
            y = Double.parseDouble(editY.getText());
            z = Double.parseDouble(editZ.getText());
        } catch (NumberFormatException nfe) {
            logger.error("enter double values.");
            return;
        } catch (NullPointerException npe) {
            logger.error("found invalid value at 'translation'");
            return;
        }

        CoordsViewerInterface parentFrame = parent.getParentFrame();
        TGAtom tgatom = (TGAtom) parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }

        AtomCoords coords = parent.getParentFrame().getCD().getAtomCoords();
        for (int i = 0; i < atoms.length; i++) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            double[] pos = parent.getParentFrame().getCD().getPos(id);
            pos[0] += x;
            pos[1] += y;
            pos[2] += z;
            ciss.phase_viewer.atomcoord.Atom atnow = coords.getAtomList()
                    .getAtomAt(id);
            coords.getAtomList().replaceAtomAt(
                    id,
                    new ciss.phase_viewer.atomcoord.Atom(
                            atnow.getElementName(), pos, atnow.getAuxil()));
        }
        coords.getAtomList().setUndoCount(atoms.length);
        parent.getParentFrame().getCD().setCoordsNoUpdate(coords);
    }

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_closeButtonActionPerformed
        // TODO add your handling code here:
        parent.dispose();
    }// GEN-LAST:event_closeButtonActionPerformed

    private void editYActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_editYActionPerformed
        // TODO add your handling code here:
    }// GEN-LAST:event_editYActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton applyButton;
    public javax.swing.JButton closeButton;
    public javax.swing.JButton deleteButton;
    public javax.swing.JTextField editX;
    public javax.swing.JTextField editY;
    public javax.swing.JTextField editZ;
    public javax.swing.JPanel jPanel1;
    public javax.swing.JPanel jPanel2;
    public javax.swing.JPanel jPanel4;
    public javax.swing.JPanel jPanel5;
    public javax.swing.JPanel jPanel6;
    public javax.swing.JTextField jTextField5;
    // End of variables declaration//GEN-END:variables

}
