/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.advancesoft.chase.common.XMLUtils;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.TabPanel;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class TabbedProjectManipulator
extends JTabbedPane {
    private static Logger logger = Logger.getLogger((String)TabbedProjectManipulator.class.getName());
    private URL property;
    private ProjectInfo info;
    private Vector projectManipulators = new Vector();

    public TabbedProjectManipulator(URL property, ProjectInfo info) {
        this.property = property;
        this.info = info;
        this.parseAndAddTabs();
    }

    private void parseAndAddTabs() {
        Element elem_tabs;
        List tab_list;
        String placement;
        String layout;
        Document doc = XMLUtils.getDocumentFrom(this.property);
        if (doc == null) {
            logger.error((Object)("couldn't get document from " + this.property));
            return;
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error((Object)"invalid ProjectSpecification file... contact AdvanceSoft.");
            return;
        }
        Element elem_tab = elem.getChild("tabbed_pane_properties");
        boolean wrap = new Boolean(elem_tab.getChildTextTrim("wrap"));
        if (wrap) {
            this.setTabLayoutPolicy(0);
        }
        if ((layout = elem_tab.getChildTextTrim("tab_layout")) != null) {
            if (layout.equalsIgnoreCase("wrap")) {
                this.setTabLayoutPolicy(0);
            } else if (layout.equalsIgnoreCase("scroll")) {
                this.setTabLayoutPolicy(1);
            }
        }
        if ((placement = elem_tab.getChildTextTrim("tab_placement")) != null) {
            if (placement.equalsIgnoreCase("top")) {
                this.setTabPlacement(1);
            } else if (placement.equalsIgnoreCase("left")) {
                this.setTabPlacement(2);
            } else if (placement.equalsIgnoreCase("bottom")) {
                this.setTabPlacement(3);
            } else if (placement.equalsIgnoreCase("right")) {
                this.setTabPlacement(4);
            }
        }
        if ((tab_list = (elem_tabs = elem.getChild("tabs")).getChildren()) == null || tab_list.size() == 0) {
            logger.warn((Object)"no tab to add...");
            return;
        }
        for (int i = 0; i < tab_list.size(); ++i) {
            Element element = (Element)tab_list.get(i);
            this.addManipulator(element);
        }
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                int selected = TabbedProjectManipulator.this.getSelectedIndex();
                for (int i = 0; i < TabbedProjectManipulator.this.projectManipulators.size(); ++i) {
                    if (i != selected) continue;
                    ((TabPanel)TabbedProjectManipulator.this.projectManipulators.elementAt(i)).instantiate();
                    return;
                }
            }
        });
        this.setSelectedIndex(0);
        this.fireStateChanged();
    }

    public void reload() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((TabPanel)this.getComponentAt(i)).setReload(true);
        }
        this.setSelectedIndex(this.getSelectedIndex());
        this.fireStateChanged();
    }

    private void addManipulator(Element element) {
        String name = element.getChildTextTrim("name");
        String iconpath = element.getChildTextTrim("iconpath");
        String loadClass = element.getChildTextTrim("loadclass");
        String description = element.getChildTextTrim("description");
        logger.debug((Object)("adding " + name));
        TabPanel tabPanel = new TabPanel(this, loadClass, this.info, this.getTabCount());
        this.addTab(name, tabPanel);
        this.projectManipulators.addElement(tabPanel);
        PluginLoader loader = new PluginLoader();
        if (iconpath != null && iconpath.length() != 0 && !iconpath.equals("null")) {
            URL res = null;
            try {
                res = loader.getResource(iconpath);
                super.setIconAt(this.getTabCount() - 1, new ImageIcon(res));
            }
            catch (Exception ex) {
                logger.error((Object)"failed to resolve icon path.");
            }
        }
        if (description != null && description.length() != 0) {
            super.setToolTipTextAt(this.getTabCount() - 1, description);
        }
    }
}

