/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.EventObject;
import javax.swing.JComboBox;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceBlock;
import jp.advancesoft.chase.inputinterface.InputInterfaceUnits;
import jp.advancesoft.chase.phase.PhaseInputFrame;
import org.apache.log4j.Logger;

class ComboBoxPhaseUnit
extends JComboBox
implements Command {
    private static Logger logger = Logger.getLogger((String)ComboBoxPhaseUnit.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private String[] choices;
    private int unitType;
    private boolean writeAll = true;
    public static final int LONGTIME = 1;
    public static final int TIME = 2;
    public static final int LENGTH = 3;
    public static final int ENERGY = 4;
    public static final int FORCE = 5;

    public ComboBoxPhaseUnit(String[] choices, String[] inputSpecifications, InputInterface inputinterface, int unitType) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.unitType = unitType;
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        logger.debug(super.getSelectedItem());
        int inpSpecLength = 1;
        if (this.writeAll) {
            inpSpecLength = this.inputSpecifications.length;
        }
        for (int is = 0; is < inpSpecLength; ++is) {
            String inp = this.inputSpecifications[is];
            String[] fullName = inp.split("\\.");
            for (int i = 0; i < fullName.length - 1; ++i) {
                String ident = fullName[i];
                if (this.inputinterface.selectBlock(ident)) continue;
                logger.debug((Object)("creating block: " + ident));
                this.inputinterface.addBlock(new InputInterfaceBlock(ident));
            }
            String newText = (String)super.getSelectedItem();
            InputInterfaceUnits units = this.inputinterface.getUnits();
            if (newText != null && !newText.equals(PhaseInputFrame.NO_SELECTION)) {
                String[] unitName = new String[]{newText};
                units.setUnits(unitName);
                this.inputinterface.replaceEntry(units);
                logger.debug((Object)("replaced unit at: " + units.getName()));
            } else {
                this.inputinterface.removeEntry(units);
                logger.debug((Object)("removed unit at: " + units.getName()));
            }
            this.inputinterface.selectRoot();
        }
    }

    public void writeAllEntries(boolean writeAll) {
        this.writeAll = writeAll;
    }
}

