/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;
import org.apache.log4j.Logger;
import org.jfree.text.TextBlock;
import org.jfree.text.TextMeasurer;

public class TextUtilities {
    static Logger logger = Logger.getLogger((Class)(class$org$jfree$text$TextUtilities == null ? (class$org$jfree$text$TextUtilities = TextUtilities.class$("org.jfree.text.TextUtilities")) : class$org$jfree$text$TextUtilities));
    public static boolean useFontMetricsGetStringBounds = false;
    static /* synthetic */ Class class$org$jfree$text$TextUtilities;

    public static TextBlock createTextBlock(String text, Font font, Paint paint, float maxWidth, TextMeasurer measurer) {
        return TextUtilities.createTextBlock(text, font, paint, maxWidth, Integer.MAX_VALUE, measurer);
    }

    public static TextBlock createTextBlock(String text, Font font, Paint paint, float maxWidth, int maxLines, TextMeasurer measurer) {
        TextBlock result = new TextBlock();
        BreakIterator iterator = BreakIterator.getLineInstance();
        iterator.setText(text);
        int current = 0;
        int length = text.length();
        while (current < length) {
            int next = TextUtilities.nextLineBreak(text, current, maxWidth, iterator, measurer);
            if (next == -1) {
                result.addLine(text.substring(current), font, paint);
                return result;
            }
            result.addLine(text.substring(current, next), font, paint);
            current = next;
        }
        return result;
    }

    private static int nextLineBreak(String text, int start, float width, BreakIterator iterator, TextMeasurer measurer) {
        int end;
        int current = start;
        float x = 0.0f;
        boolean firstWord = true;
        while ((end = iterator.next()) != -1) {
            if ((x += measurer.getStringWidth(text, current, end)) > width) {
                if (firstWord) {
                    while (measurer.getStringWidth(text, start, end) > width) {
                        --end;
                    }
                    return end;
                }
                end = iterator.previous();
                return end;
            }
            firstWord = false;
            current = end;
        }
        return -1;
    }

    public static Rectangle2D getTextBounds(String text, Graphics2D g2, FontMetrics fm) {
        Rectangle2D bounds = null;
        if (useFontMetricsGetStringBounds) {
            bounds = fm.getStringBounds(text, g2);
        } else {
            double width = fm.stringWidth(text);
            double height = fm.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Height = " + height));
            }
            bounds = new Rectangle2D.Double(0.0, -fm.getAscent(), width, height);
        }
        return bounds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

