/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.normalization;

import jas.hist.DataSource;
import jas.hist.normalization.SimpleNormalizer;
import java.util.Observable;
import java.util.Observer;

public abstract class DataSourceNormalizer
extends SimpleNormalizer
implements Observer {
    protected boolean hurry;
    protected DataSource source;
    private double norm;

    public DataSourceNormalizer(DataSource dataSource) {
        super(1.0);
        this.source = dataSource;
        String string = System.getProperty("hurry", "false");
        this.hurry = string != null && string.equalsIgnoreCase("true");
    }

    protected void init() {
        if (this.source instanceof Observable) {
            ((Observable)((Object)this.source)).addObserver(this);
        }
        this.norm = this.calculateNormalization();
    }

    public void update(Observable observable, Object object) {
        double d = this.calculateNormalization();
        if (d != this.norm) {
            this.norm = d;
            this.normalizationChanged();
        }
    }

    public double getNormalizationFactor() {
        return super.getNormalizationFactor() * this.norm;
    }

    protected abstract double calculateNormalization();
}

