/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Font;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class LogFontW
implements EMFConstants {
    private int height;
    private int width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charSet;
    private int outPrecision;
    private int clipPrecision;
    private int quality;
    private int pitchAndFamily;
    private String faceFamily;

    public LogFontW(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, int charSet, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, String faceFamily) {
        this.height = height;
        this.width = width;
        this.escapement = escapement;
        this.orientation = orientation;
        this.weight = weight;
        this.italic = italic;
        this.underline = underline;
        this.strikeout = strikeout;
        this.charSet = charSet;
        this.outPrecision = outPrecision;
        this.clipPrecision = clipPrecision;
        this.quality = quality;
        this.pitchAndFamily = pitchAndFamily;
        this.faceFamily = faceFamily;
    }

    public LogFontW(Font font) {
        this.height = -font.getSize();
        this.width = 0;
        this.escapement = 0;
        this.orientation = 0;
        this.weight = font.isBold() ? 700 : 400;
        this.italic = font.isItalic();
        this.underline = false;
        this.strikeout = false;
        this.charSet = 0;
        this.outPrecision = 0;
        this.clipPrecision = 0;
        this.quality = 4;
        this.pitchAndFamily = 0;
        this.faceFamily = font.getName();
    }

    LogFontW(EMFInputStream emf) throws IOException {
        this.height = emf.readLONG();
        this.width = emf.readLONG();
        this.escapement = emf.readLONG();
        this.orientation = emf.readLONG();
        this.weight = emf.readLONG();
        this.italic = emf.readBOOLEAN();
        this.underline = emf.readBOOLEAN();
        this.strikeout = emf.readBOOLEAN();
        this.charSet = emf.readBYTE();
        this.outPrecision = emf.readBYTE();
        this.clipPrecision = emf.readBYTE();
        this.quality = emf.readBYTE();
        this.pitchAndFamily = emf.readBYTE();
        this.faceFamily = emf.readWCHAR(32);
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeLONG(this.height);
        emf.writeLONG(this.width);
        emf.writeLONG(this.escapement);
        emf.writeLONG(this.orientation);
        emf.writeLONG(this.weight);
        emf.writeBYTE(this.italic);
        emf.writeBYTE(this.underline);
        emf.writeBYTE(this.strikeout);
        emf.writeBYTE(this.charSet);
        emf.writeBYTE(this.outPrecision);
        emf.writeBYTE(this.clipPrecision);
        emf.writeBYTE(this.quality);
        emf.writeBYTE(this.pitchAndFamily);
        emf.writeWCHAR(this.faceFamily, 32);
    }

    public String toString() {
        return "  LogFontW\n    height: " + this.height + "\n" + "    width: " + this.width + "\n" + "    orientation: " + this.orientation + "\n" + "    weight: " + this.weight + "\n" + "    italic: " + this.italic + "\n" + "    underline: " + this.underline + "\n" + "    strikeout: " + this.strikeout + "\n" + "    charSet: " + this.charSet + "\n" + "    outPrecision: " + this.outPrecision + "\n" + "    clipPrecision: " + this.clipPrecision + "\n" + "    quality: " + this.quality + "\n" + "    pitchAndFamily: " + this.pitchAndFamily + "\n" + "    faceFamily: " + this.faceFamily;
    }
}

