/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.sftp.FileProperty;
import org.apache.log4j.Logger;

public class FilePropertyViewer
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger((String)FilePropertyViewer.class.getName());
    private RemoteFile[] files;

    public FilePropertyViewer(RemoteFile[] files) {
        super("file property viewer", true, true, true, true, new Dimension(350, 240));
        this.files = files;
        this.init();
    }

    private void init() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JTabbedPane tp = new JTabbedPane();
        tp.setTabLayoutPolicy(1);
        for (int i = 0; i < this.files.length; ++i) {
            RemoteFile file = this.files[i];
            logger.debug((Object)("file properties for file no. " + i));
            logger.debug((Object)("isDirectory: " + file.isDirectory()));
            logger.debug((Object)("file path: " + file.getAbsolutePath()));
            logger.debug((Object)("canRead: " + file.canRead()));
            logger.debug((Object)("canWrite: " + file.canWrite()));
            logger.debug((Object)("lastModified: " + FileProperty.getTime(file.lastModified())));
            logger.debug((Object)("size: " + file.length()));
            tp.addTab(file.getName(), new FileProperty(file));
        }
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 0));
        JButton close = new JButton("close");
        pbtn.add(close);
        p.add(tp);
        p.add(pbtn);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilePropertyViewer.this.dispose();
            }
        });
        this.getContentPane().add(p);
    }
}

