/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.hosts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class HostInfo
extends Properties {
    private static Logger logger = Logger.getLogger((String)HostInfo.class.getName());
    private String name = "";
    private String address = "";
    private String bindir = "";
    private String mpidir = "";
    private String basedir = "";
    private String username = "";
    private String initpass = "";
    private byte[] password = this.initpass.getBytes();
    private boolean savepass = false;
    private String passString = "";
    private boolean xforwarding = false;
    private boolean antialias = false;

    public HostInfo() {
    }

    public HostInfo(String name) {
        this.name = name;
    }

    public Object setProperty(String key, boolean value) {
        return super.setProperty(key, Boolean.toString(value));
    }

    public TaggedString[] getHostProperties() {
        Vector<TaggedString> tmp = new Vector<TaggedString>();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String tag = (String)enumeration.nextElement();
            tmp.addElement(new TaggedString(tag, this.getProperty(tag)));
        }
        TaggedString[] ret = new TaggedString[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            ret[i] = (TaggedString)tmp.elementAt(i);
        }
        return ret;
    }

    public void setProperties(TaggedString[] elms) {
        if (elms != null) {
            for (int i = 0; i < elms.length; ++i) {
                String key = elms[i].getTag();
                String val = elms[i].getValue();
                this.setProperty(key, val);
            }
        }
    }

    public boolean getBooleanProperty(String key) {
        String ret = super.getProperty(key);
        boolean bret = ret != null ? ret.equalsIgnoreCase("true") || ret.equals("1") || ret.equalsIgnoreCase("on") : false;
        return bret;
    }

    public Object clone() {
        TaggedString[] elms = this.getHostProperties();
        String pass = this.getPasswordString();
        HostInfo inf = new HostInfo(this.name);
        inf.setProperties(elms);
        inf.setPasswordString(pass);
        return inf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public String getPasswordString() {
        return this.passString;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public void setPasswordString(String passString) {
        this.passString = passString;
    }

    public void setSavePassword(boolean savepass) {
        this.savepass = savepass;
    }

    public boolean savePassword() {
        return this.savepass;
    }

    public void debug() {
        TaggedString[] tmp = this.getHostProperties();
        logger.debug((Object)("name: " + this.getName()));
        for (int i = 0; i < tmp.length; ++i) {
            logger.debug((Object)("tag: " + tmp[i].getTag() + " value: " + tmp[i].getValue()));
        }
    }
}

