/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.fileinfo;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoEditor;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoParser;
import org.apache.log4j.Logger;

public abstract class FileInfoEditPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)FileInfoEditPanel.class.getName());
    private FileInfoParser fileinfo;
    private Vector editors = new Vector();

    public FileInfoEditPanel(FileInfoParser fileinfo) {
        super("edit fileinfo for " + fileinfo.getFileInfoName(), true, true, true, true, new Dimension(400, 600));
        this.fileinfo = fileinfo;
        this.init();
    }

    public FileInfoEditPanel(FileInfoParser fileinfo, Dimension size) {
        super("edit fileinfo for " + fileinfo.getFileInfoName(), true, true, true, true, size);
        this.fileinfo = fileinfo;
        this.init();
    }

    private void init() {
        Container cont = super.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().setView(this.createFileEditFrame());
        cont.add(scrollpane);
        cont.add(this.createButtons());
    }

    private JPanel createFileEditFrame() {
        JPanel p = new JPanel();
        FileInfo[] infos = this.fileinfo.getFileInfos();
        if (infos == null || infos.length == 0) {
            this.logger.error((Object)"invalid file info.");
        }
        p.setLayout(new BoxLayout(p, 1));
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i].getFileNameEditLevel() != 0) continue;
            FileInfoEditor editor = new FileInfoEditor(infos[i], this.fileinfo.getDefaultParent());
            infos[i].addFileInfoChangeListener(editor);
            p.add(editor);
            this.editors.addElement(editor);
        }
        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton def = new JButton("set default name");
        JButton save = new JButton("save");
        JButton saveclose = new JButton("save and close");
        JButton close = new JButton("close");
        p.add(def);
        p.add(save);
        p.add(saveclose);
        p.add(close);
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInfoEditPanel.this.setDefaultName();
            }
        });
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInfoEditPanel.this.save();
            }
        });
        saveclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInfoEditPanel.this.save();
                FileInfoEditPanel.this.dispose();
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInfoEditPanel.this.dispose();
            }
        });
        Dimension size = new Dimension(this.getSize().width, 50);
        p.setPreferredSize(size);
        p.setMinimumSize(size);
        return p;
    }

    private void setDefaultName() {
        for (int i = 0; i < this.editors.size(); ++i) {
            FileInfo info = ((FileInfoEditor)this.editors.elementAt(i)).getFileInfo();
            if (!info.getDefaultName().hasRegExp()) {
                info.setName(info.getDefaultName().getValue());
                continue;
            }
            info.setName(info.getDefaultName().getReplaceString());
        }
    }

    private void save() {
        this.fileinfo.save();
    }
}

