/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis;

import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntry;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntryChangeEvent;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntryChangeListener;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import org.apache.log4j.Logger;

public class TextFieldPhase
extends JTextField
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger((String)TextFieldPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;

    public TextFieldPhase(int columns) {
        super(columns);
    }

    public TextFieldPhase(int columns, String[] inputSpecifications, InputInterface inputinterface) {
        super(columns);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        String inp = this.inputSpecifications[0];
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(inp);
        String[] fname = inp.split("\\.");
        String name = fname[fname.length - 1];
        logger.debug((Object)(" primitive entry: " + entry));
        String value = super.getText().trim();
        entry.saveState();
        entry.setName(name);
        entry.setValue(value);
        if (value.length() == 0) {
            this.inputinterface.removeEntry(entry, this);
        } else {
            this.inputinterface.replaceEntry(entry, this);
        }
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceInitializing() {
        int i;
        CaretListener[] lists = this.getCaretListeners();
        for (i = 0; i < lists.length; ++i) {
            this.removeCaretListener(lists[i]);
        }
        this.setText("");
        for (i = 0; i < lists.length; ++i) {
            this.addCaretListener(lists[i]);
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        int i;
        if (evt.getSource() == this) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 0) {
            return;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        String fullName = tag + "." + pentry.getName();
        logger.debug((Object)("caught change of inputinterface object at: " + fullName + " and I'm " + this.inputSpecifications[0]));
        logger.debug((Object)("specifically, the change is : " + pentry.getValue()));
        CaretListener[] listeners = this.getCaretListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.removeCaretListener(listeners[i]);
        }
        if (fullName.trim().equalsIgnoreCase(this.inputSpecifications[0].trim())) {
            this.setText(pentry.getValue());
        }
        for (i = 0; i < listeners.length; ++i) {
            this.addCaretListener(listeners[i]);
        }
    }
}

