/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.outputinterface;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import jp.advancesoft.chase.graph.DataPanel;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.outputinterface.OutputData;
import jp.advancesoft.chase.outputinterface.OutputParser;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoParser;
import org.apache.log4j.Logger;

public class OutputInterface {
    private Logger logger = Logger.getLogger((String)OutputInterface.class.getName());
    private FileInfoParser parser;
    private OutputParser outputParser;
    private ProjectInfo projectInfo;
    private Vector loadedParsers = new Vector();

    public OutputInterface(FileInfoParser parser) {
        this.parser = parser;
    }

    public JPanel getDataPanel(String key) {
        this.logger.debug((Object)("at getGraphPanel, key: " + key));
        if (this.createOutputParser(key)) {
            OutputData[] data = this.outputParser.getOutputData();
            if (data != null && data.length > 1) {
                DataPanel dataPanel = new DataPanel(data);
                return dataPanel;
            }
            if (data != null && data.length == 1) {
                DataPanel dataPanel = new DataPanel(data[0]);
                return dataPanel;
            }
        }
        return new JPanel();
    }

    public JPanel getDataPanel(String key, String fileName) {
        if (this.createOutputParser(key, fileName)) {
            DataPanel dataPanel = new DataPanel(this.outputParser.getOutputData());
            return dataPanel;
        }
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        ret.add(new JPanel());
        return ret;
    }

    public OutputParser getParser(String key) {
        if (this.createOutputParser(key)) {
            return this.outputParser;
        }
        return null;
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public OutputParser getParser(String key, String fname) {
        if (this.createOutputParser(key, fname)) {
            return this.outputParser;
        }
        return null;
    }

    private boolean createOutputParser(String key, String fileName) {
        FileInfo info = this.parser.getFileInfo(key);
        return this.loadParser(info.getParser(), fileName);
    }

    private boolean createOutputParser(String key) {
        FileInfo info = this.parser.getFileInfo(key);
        File file = info.getPath();
        String dir = file.getAbsolutePath();
        if (!file.isAbsolute()) {
            dir = this.parser.getDefaultParent() + System.getProperty("file.separator");
        }
        String fileName = dir + info.getName();
        return this.loadParser(info.getParser(), fileName);
    }

    private boolean loadParser(String parserPath, String fileName) {
        this.logger.debug((Object)("loading parser: " + parserPath + "... file name is: " + fileName));
        if (parserPath == null || parserPath.length() == 0) {
            return false;
        }
        PluginLoader pl = new PluginLoader();
        try {
            Class<?> cla = pl.loadClass(parserPath);
            Constructor<?>[] constructor = cla.getDeclaredConstructors();
            this.outputParser = (OutputParser)constructor[0].newInstance(fileName);
        }
        catch (Exception ex) {
            this.logger.error((Object)("failed to load class: " + parserPath + " ... contact AdvanceSoft."));
            ex.printStackTrace();
            return false;
        }
        if (this.outputParser != null) {
            String ls = System.getProperty("line.separator");
            this.outputParser.setParent(this);
            this.loadedParsers.addElement(this.outputParser);
            if (this.outputParser.parse()) {
                OutputData[] outputData = this.outputParser.getOutputData();
                if (outputData != null && outputData.length != 0) {
                    for (int k = 0; k < outputData.length; ++k) {
                        this.logger.debug((Object)("output data no. " + k));
                        String[] ident = outputData[k].getIdentifier();
                        String description = outputData[k].getDescription();
                        String name = outputData[k].getName();
                        String header = "";
                        header = header + name + ls;
                        header = header + description + ls;
                        if (ident != null && ident.length != 0) {
                            for (int i = 0; i < ident.length; ++i) {
                                header = header + ident[i] + " ";
                            }
                        }
                        header = header + ls;
                        this.logger.debug((Object)header);
                        String[][] data = outputData[k].getData2D();
                        for (int i = 0; i < data.length; ++i) {
                            String row = "";
                            for (int j = 0; j < data[i].length; ++j) {
                                row = row + data[i][j] + " ";
                            }
                            this.logger.debug((Object)row);
                        }
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void reload() {
        for (int i = 0; i < this.loadedParsers.size(); ++i) {
            OutputParser op = (OutputParser)this.loadedParsers.get(i);
            if (op.parse()) continue;
            this.logger.error((Object)("failed to reload parser: " + op.getFileName()));
        }
    }
}

