/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import org.apache.log4j.Logger;

public class VectorOperations {
    private static final Logger logger = Logger.getLogger((String)VectorOperations.class.getName());

    public static double calDist(double[] firstVector, double[] secondVector) {
        double dist = 0.0;
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = firstVector.length;
        if (ndim > secondVector.length) {
            ndim = secondVector.length;
        }
        if (ndim != secondVector.length) {
            logger.warn((Object)("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim));
        }
        for (int i = 0; i < ndim; ++i) {
            dist += Math.pow(firstVector[i] - secondVector[i], 2.0);
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static double dotProduct(double[] v1, double[] v2) {
        if (v1 == null || v2 == null) {
            logger.error((Object)"either first vector or second vector is null... ");
            return 0.0;
        }
        int ndim = v1.length;
        if (ndim > v2.length) {
            ndim = v2.length;
        }
        if (v1.length != v2.length) {
            logger.warn((Object)("the dimension of the two vectors are inconsistent... using the smaller one, " + ndim));
        }
        double dot = 0.0;
        for (int i = 0; i < ndim; ++i) {
            dot += v1[i] * v2[i];
        }
        return dot;
    }

    public static double[] crossProduct(double[] v1, double[] v2) {
        double[] ret = null;
        if (v1 != null && v2 != null) {
            ret = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        } else {
            logger.error((Object)"either v1 or v2 was null ...");
            logger.error((Object)"returning null.");
        }
        return ret;
    }

    public static double norm(double[] v) {
        double norm = 0.0;
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                norm += v[i] * v[i];
            }
        } else {
            logger.error((Object)"v was null ... ");
        }
        return Math.sqrt(norm);
    }

    public static double[] getNormalVector(double[] firstVector, double[] secondVector) {
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either vector 1 or vector 2 was null...");
            return null;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error((Object)"the dimension of the vectors must at least be greater than 3.");
            return null;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn((Object)"the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn((Object)"truncating higher dimensions...");
        }
        double[] n1 = VectorOperations.crossProduct(firstVector, secondVector);
        double norm1 = VectorOperations.norm(n1);
        for (int i = 0; i < 3; ++i) {
            n1[i] = n1[i] / norm1;
        }
        return n1;
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin) {
        return VectorOperations.getDistanceFromPlane(point, firstVector, secondVector, origin, false);
    }

    public static double getDistanceFromPlane(double[] point, double[] firstVector, double[] secondVector, double[] origin, boolean orientationToo) {
        if (firstVector == null || secondVector == null) {
            logger.error((Object)"either vector 1 or vector 2 was null...");
            return 0.0;
        }
        if (firstVector.length < 3 || secondVector.length < 3) {
            logger.error((Object)"the dimension of the vectors must at least be greater than 3.");
            return 0.0;
        }
        if (firstVector.length != 3 || secondVector.length != 3) {
            logger.warn((Object)"the dimension of either vector 1 or vector 2 is greater than 3 ...");
            logger.warn((Object)"truncating higher dimensions...");
        }
        double[] referanceVector = new double[3];
        for (int i = 0; i < 3; ++i) {
            referanceVector[i] = point[i] - (firstVector[i] + origin[i]);
        }
        double[] normalVector = VectorOperations.getNormalVector(firstVector, secondVector);
        if (!orientationToo) {
            return Math.abs(VectorOperations.dotProduct(normalVector, referanceVector));
        }
        return VectorOperations.dotProduct(normalVector, referanceVector);
    }
}

