/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.advancesoft.chase.common.VectorOperations;

public class CylinderCreator {
    int edges = 7;

    public void setResolution(int e) {
        this.edges = e;
    }

    public BranchGroup create(Point3d b, Point3d a, double radius, float arrowHeadRadius, float arrowHeadHeight) {
        Appearance app = new Appearance();
        Material material = new Material();
        float[] color_wk = new float[]{0.2f, 0.2f, 0.5f};
        material.setDiffuseColor(new Color3f(color_wk));
        material.setShininess(120.0f);
        app.setMaterial(material);
        return this.create(b, a, radius, arrowHeadRadius, arrowHeadHeight, app);
    }

    public BranchGroup create(Point3d b, Point3d a, double radius, float arrowHeadRadius, float arrowHeadHeight, Appearance cylApp) {
        Vector3d base = new Vector3d();
        base.x = b.x;
        base.y = b.y;
        base.z = b.z;
        Vector3d apex = new Vector3d();
        apex.x = a.x;
        apex.y = a.y;
        apex.z = a.z;
        Vector3d center = new Vector3d();
        center.x = (apex.x - base.x) / 2.0 + base.x;
        center.y = (apex.y - base.y) / 2.0 + base.y;
        center.z = (apex.z - base.z) / 2.0 + base.z;
        Vector3d unit = new Vector3d();
        unit.sub((Tuple3d)apex, (Tuple3d)base);
        double height = unit.length();
        unit.normalize();
        Vector3d uX = new Vector3d();
        Vector3d uY = new Vector3d();
        Vector3d uZ = new Vector3d();
        Transform3D rotateFix = new Transform3D();
        uY = new Vector3d(unit);
        uX.cross(unit, new Vector3d(0.0, 0.0, 1.0));
        double magX = uX.length();
        if (magX != 0.0) {
            uX.z /= magX;
            uX.x /= magX;
            uX.y /= magX;
            uZ.cross(uX, uY);
        } else {
            uX = new Vector3d(unit);
            uZ.cross(unit, new Vector3d(0.0, 1.0, 0.0));
            double magZ = uZ.length();
            uZ.x /= magZ;
            uZ.y /= magZ;
            uZ.z /= magZ;
            uY.cross(uZ, uX);
            rotateFix.rotZ(1.5707963267948966);
        }
        Transform3D transMatrix = new Transform3D();
        Transform3D rotateMatrix = new Transform3D(new Matrix4d(uX.x, uX.y, uX.z, 0.0, uY.x, uY.y, uY.z, 0.0, uZ.x, uZ.y, uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
        rotateMatrix.invert();
        transMatrix.mul(rotateMatrix);
        transMatrix.mul(rotateFix);
        transMatrix.setTranslation(center);
        TransformGroup tg = new TransformGroup(transMatrix);
        Cylinder cyl = new Cylinder((float)radius, (float)height, 1, this.edges, 1, cylApp);
        if (arrowHeadHeight != 0.0f && arrowHeadRadius != 0.0f) {
            Cone cone = new Cone(arrowHeadRadius, arrowHeadHeight, cylApp);
            Transform3D translateCone = new Transform3D();
            Vector3d vCone = new Vector3d();
            vCone.y = VectorOperations.norm(new double[]{b.x - a.x, b.y - a.y, b.z - a.z}) / 2.0;
            translateCone.set(vCone);
            TransformGroup tgCone = new TransformGroup(translateCone);
            tgCone.addChild((Node)cone);
            tg.addChild((Node)tgCone);
        }
        tg.addChild((Node)cyl);
        BranchGroup cylBg = new BranchGroup();
        cylBg.addChild((Node)tg);
        cylBg.setCapability(17);
        return cylBg;
    }

    public BranchGroup create(Point3d b, Point3d a, double radius, Appearance cylApp) {
        return this.create(b, a, radius, 0.0f, 0.0f, cylApp);
    }

    public BranchGroup create(Point3d b, Point3d a, double radius) {
        Appearance app = new Appearance();
        Material material = new Material();
        float[] color_wk = new float[]{0.2f, 0.2f, 0.5f};
        material.setDiffuseColor(new Color3f(color_wk));
        material.setShininess(120.0f);
        app.setMaterial(material);
        return this.create(b, a, radius, 0.0f, 0.0f, app);
    }
}

