<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Generic XSL Stylesheet for the Reference Scanner
Copyright (c) jb2works.com 2003-2004

@author Joerg Baumgaertel
@version $Revision: 1.36 $ $Date: 2004/09/12 19:44:37 $
 -->
<!DOCTYPE xhtml-lat1 SYSTEM "xhtml-lat1.dtd">
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--
        ======= Common templates for static and result pages =======================================================
    -->
    <xsl:template match="/" >
        <html>
            <xsl:call-template name="head"/>
            <xsl:call-template name="body"/>
        </html>
    </xsl:template>

    <xsl:template name="head">
        <head>
            <xsl:apply-templates select="//page/title"/>
            <xsl:apply-templates select="//page/keywords"/>
            <link rel="stylesheet" href="scanner.css" type="text/css"/>
        </head>
    </xsl:template>

    <xsl:template match="title" >
        <title>Ref Scan - <xsl:value-of select="node()"/></title>
    </xsl:template>

    <xsl:template match="keywords" >
        <xsl:variable name="keywords" select="node()"/>
        <meta name="keywords" content="{$keywords}"/>
    </xsl:template>

    <xsl:template name="body">
        <body bgcolor="#FFFFFF">
            <center>
                <xsl:apply-templates select="//page/header"/>
                <!-- select depending on page type -->
<!--                <table  cellpadding="0" cellspacing="0" border="0" width="95%">-->
<!--                    <tr>-->
                        <xsl:choose>
                            <xsl:when test="//page/@type = 'result'" >
                                <xsl:call-template name="main.result"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="main.static"/>
                            </xsl:otherwise>
                        </xsl:choose>
<!--                    </tr>-->
<!--                </table>-->
                <xsl:call-template name="footer"/>
            </center>
        </body>
    </xsl:template>

    <xsl:template match="header">
        <xsl:choose >
            <xsl:when test="@status = 'disabled'" >
                <br/>
            </xsl:when>
            <xsl:otherwise>
                <table cellpadding="0" cellspacing="0" border="0" width="100%">
                        <tr>
                            <td width="11"> </td> 
                            <td>
                                <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                    <tr>
                                        <td valign="top">
                                            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                                <tr>
                                                    <td><img src="logoRefScan218x50-c9c9d8.gif" alt="Reference Scanner" width="218" height="50"/></td>
                                                    <td  width="48">
                                                        <a href="http://jb2works.com" title="a product of jb2works.com">
                                                            <img border="0"  src="circle48x50-c9c9d8.gif" alt="jb2works.com"/>
                                                        </a>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <xsl:call-template name="hr"/>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td width="11"> </td> 
                        </tr>
                </table>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="footer">
        <table  cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <td width="11"> </td> 
                <td>
                    <xsl:call-template name="hr"/>
                    <div class="copyright">
                        Reference Scanner Rev.
                        <xsl:apply-templates select="//page/revision"/><tab/><tab/>-<tab/><tab/>
                        Copyright (C) jb2works.com 2003-2004
                    </div>
                </td>
                <td width="11"> </td> 
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="head" >
        <xsl:apply-templates select="node()" />
        <xsl:call-template name="hr"/>
        <br/>
    </xsl:template>

    <xsl:template name="hr">
        <hr style="border: 0px; color: #e2e2e6; background-color: #e2e2e6; height: 1px;"/>
    </xsl:template>

    <xsl:template match="p" >
        <xsl:apply-templates select="node()" />
        <br/><br/>
    </xsl:template>

    <xsl:template match="h" >
        <a name="{@anchor}"/>
        <div class="head">
            <xsl:apply-templates select="node()" />
        </div>
    </xsl:template>

    <xsl:template match="b"><b><xsl:apply-templates select="node()" /></b></xsl:template>

    <xsl:template match="u"><u><xsl:apply-templates select="node()" /></u></xsl:template>

    <xsl:template match="pre"><pre><xsl:apply-templates select="node()" /></pre></xsl:template>

    <xsl:template match="li"><li><xsl:apply-templates select="node()" /></li></xsl:template>

    <xsl:template match="ul"><ul><xsl:apply-templates select="node()" /></ul></xsl:template>

    <xsl:template match="tt">
        <tt>
            <font class="plain">
                <xsl:apply-templates select="node()" />
            </font>
        </tt>
    </xsl:template>

    <xsl:template match="sysinfo">
        <tt>
            <font class="plain-sysinfo">
                <xsl:apply-templates select="node()" />
            </font>
        </tt>
    </xsl:template>

    <xsl:template match="i"><i><xsl:apply-templates select="node()" /></i></xsl:template>

    <xsl:template match="br" > <br/> </xsl:template>

    <xsl:template match="tab" > &nbsp; &nbsp; </xsl:template>

    <xsl:template match="space"> &nbsp; </xsl:template>

    <xsl:template match="space0">&nbsp;</xsl:template>

    <xsl:template match="img" >
        <img src="{@src}" alt="{@alt}" width="{@width}" height="{@height}" border="0"/>
    </xsl:template>

    <xsl:template match="a" >
        <xsl:choose >
            <xsl:when test="@status = 'disabled'" >
                <u><font color="#9f9f9f"><xsl:apply-templates select="node()" /></font></u>
            </xsl:when>
            <xsl:otherwise >
                <a href="{@href}" class="{@class}" title="{@title}"><xsl:apply-templates select="node()" /></a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="bar-separator">
        <font class="navisep">
            <br/>
        </font>
    </xsl:template>

    <xsl:template match="navibar-item" >
        <xsl:choose >
            <xsl:when test="@href" >
                <a href="{@href}" title="Go back to {@text}" class="navibar"><xsl:value-of select="@text"/></a>
            </xsl:when>
            <xsl:otherwise >
                <xsl:value-of select="@text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="navibar-tab" > &gt; </xsl:template>

    <xsl:template match="navibar-lang">
        <font class="navibar">
            <font color="#9f9f9f">
                &nbsp;[
                <xsl:choose >
                    <xsl:when test="@eng" >
                        <a href="{@eng}" class="navibar">eng</a>
                    </xsl:when>
                    <xsl:otherwise >
                        eng
                    </xsl:otherwise>
                </xsl:choose>
                |
                <xsl:choose >
                    <xsl:when test="@de" >
                        <a href="{@de}" class="navibar">de</a>
                    </xsl:when>
                    <xsl:otherwise >
                        de
                    </xsl:otherwise>
                </xsl:choose>
                ]
            </font>
        </font>
    </xsl:template>

    <!--
        ====== Templates for static pages only =======================================================================
    -->

    <xsl:template name="main.static">
        <table  cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <td width="11"> </td> 
                <td class="td1">
                    <xsl:apply-templates select="//page/content/head"/>
                    <xsl:apply-templates select="//page/content/p"/>
                </td>
                <td width="10"> </td>
                <td width="242" valign="top">
                    <br/>
                    <xsl:apply-templates select="//page/navigation.static/box"/>
                    <br/><br/>
                </td>
                <td width="11"> </td> 
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="box">
        <table background="box1-background.gif" cellpadding="0" cellspacing="0" border="0" width="237">
            <tr><td><img src="box1-upper.gif"/></td></tr>
            <tr><td>
                <table cellpadding="0" cellspacing="0" border="0" width="237">
                    <tr><td background="box1-left.gif" width="12"></td>
                        <td class="td1">
                            <xsl:apply-templates select="node()" />
                            <br/>
                        </td><td background="box1-right.gif" width="12"></td>
                    </tr>
                </table>
            </td></tr>
            <tr><td><img src="box1-bottom.gif"/></td></tr>
        </table>
        <br/>
    </xsl:template>

    <xsl:template match="pageindex">
        <xsl:apply-templates
            select="/page/content/*/h"
            mode="pageindex"/>
    </xsl:template>

    <xsl:template match="h" mode="pageindex">
        <a href="#{@anchor}">
            <xsl:apply-templates select="node()" />
        </a>
        <br/>
    </xsl:template>

    <xsl:template match="navibar.static">
        <xsl:call-template name="bar-separator"/>
        <font class="navibar">
            <font color="#9f9f9f">
                ( <xsl:apply-templates select="node()" /> )
            </font>
        </font>
    </xsl:template>

    <!--
        ====== Templates for Result pages only =======================================================================
    -->
    <xsl:template name="main.result">
        <table  cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <td width="11"> </td> 
                <td class="td1">
                    <xsl:apply-templates select="//page/content/head"/>
                </td>
                <td width="11"> </td> 
            </tr>
        </table>
<!--        <table  cellpadding="0" cellspacing="0" border="0" width="1600">-->
<!--            <tr>-->
<!--                <td width="11"> </td> -->
                <td><xsl:apply-templates select="//page/content/p"/></td>
<!--            </tr>-->
<!--        </table>-->
        <table  cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <td width="11"> </td> 
                <td><xsl:apply-templates select="//page/content/status"/></td>
                <td width="11"> </td> 
            </tr>
        </table>
</xsl:template>

    <xsl:template match="diff-color" >
        <font class="plain-diff">
            <xsl:apply-templates select="node()" />
        </font>
    </xsl:template>

    <xsl:template match="blank">&nbsp;</xsl:template>
    <xsl:template match="laquo"> &laquo; </xsl:template>
    <xsl:template match="raquo"> &raquo; </xsl:template>
    <xsl:template match="anchor"><a name="{@name}"/></xsl:template>

    <xsl:template match="navigation.result">
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
            <tr>
                <xsl:apply-templates select="node()" />
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="navibar.result">
        <td>
            <xsl:call-template name="bar-separator"></xsl:call-template>
            <font class="navibar">
                <font color="#9f9f9f">
                    ( <xsl:apply-templates select="node()" /> )
                </font>
            </font>
        </td>
    </xsl:template>

    <xsl:template match="menubar">
        <td align="right">
            <xsl:call-template name="bar-separator"/>
            <font class="menubar">
                <font color="#9f9f9f">
                    [ :: <xsl:apply-templates select="node()" /> :: ]
                </font>
            </font>
        </td>
    </xsl:template>

    <xsl:template match="menubar-item" >
        <xsl:choose >
            <xsl:when test="@href" >
                <a href="{@href}" title="{@title}" class="menubar"><xsl:value-of select="@text"/></a>
            </xsl:when>
            <xsl:otherwise >
                <xsl:value-of select="@text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="menubar-tab" >  &nbsp;::&nbsp; </xsl:template>

    <xsl:template match="status">
        <xsl:call-template name="hr"/>
        <div class="status">
            <xsl:apply-templates select="node()" />
        </div>
    </xsl:template>

    <xsl:template match="logon">
        <form action="heapprofile.page" class="form">
            <input name="user" type="text" value="{@user}" title="Enter user name" class="inputtext" size="8" maxlength="128"/>
            <br/><font class="navisep"><br/></font>
            <input name="pass" type="password" value="{@pass}" title="Enter password" class="inputtext" size="8" maxlength="128"/>
            <br/><font class="navisep"><br/></font>
            <input type="submit" class="inputbutton" title="Logon to create first snapshot" value="logon"/>
              &nbsp;<a href="/helpOnLogon.page" title="Click to get help about logon">?</a>
            <br/><br/><br/>
        </form>
    </xsl:template>

    <xsl:template match="reset-logon">
        <form action="start.page" class="form">
            <input name="user" type="text" value="{@user}" title="Enter user name" class="inputtext" size="8" maxlength="128"/>
            <br/><font class="navisep"><br/></font>
            <input name="pass" type="password" value="{@pass}" title="Enter password" class="inputtext" size="8" maxlength="128"/>
            <br/><font class="navisep"><br/></font>
            <input type="submit" class="inputbutton" title="Restore default logon" value="restore"/>
        </form>
    </xsl:template>

    <!-- Profile -->
    <!--
        @param name the name e.g. "#001"
        @param time the timestamp to display
        @param filter the filter
    -->
    <xsl:template match="snapshot">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td>
            <a name="HeapProfile"/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">  <tr>
                <td class="head">
                Heap Snapshot <xsl:value-of select="@name"/>
                </td>
                <td align="right" class="headr" >
                    <xsl:value-of select="@time"/>
                </td>
            </tr></table>
            <br/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                    <xsl:choose>
                        <xsl:when test="@empty = 'false'">
                            <td class="plain">&lt;count&gt; &nbsp; &lt;class&gt;</td>
                        </xsl:when>
                    </xsl:choose>
                    <td align="right">
                        <form action="heapprofile.page" class="form">&nbsp;
                            <input name="filter" type="text" value="{@filter}" title="Enter a string to filter class name" class="inputtext" size="30" maxlength="1024"/>&nbsp;
                            <input type="submit" class="inputbutton" title="Submit filter for class name" value="filter"/>
                        </form>
                    </td>
                </tr>
            </table>
        </td><td width="11"> </td></tr></table>
        <br/>
        <!-- counters now -->
        <table cellpadding="0" cellspacing="0" border="0" width="1600" class="plain"><tr><td width="11"> </td><td>
            <xsl:apply-templates select="node()" />
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    <br/>
                    No instances in snapshot for filter "<xsl:value-of select="@filter"/>".
                </xsl:when>
            </xsl:choose>
        </td></tr></table>
    </xsl:template>

    <xsl:template match="snapshot-with-bargraph">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td>
            <a name="snapshot"/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">  <tr>
                <td class="head">
                        Heap Snapshot <xsl:value-of select="@name"/>
                </td>
                <td align="right" class="headr" >
                    <xsl:value-of select="@time"/>
                </td>
            </tr></table>
            <br/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                    <xsl:choose>
                        <xsl:when test="@empty = 'false'">
                            <td class="plain" width="100">&lt;count&gt; </td>
                            <td class="plain"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;class&gt;</td>
                        </xsl:when>
                    </xsl:choose>
                    <td align="right">
                        <form action="heapprofile.page" class="form">&nbsp;
                            <input name="filter" type="text" value="{@filter}" title="Enter a string to filter class name" class="inputtext" size="30" maxlength="1024"/>&nbsp;
                            <input type="submit" class="inputbutton" title="Submit filter for class name" value="filter"/>
                        </form>
                    </td>
                </tr>
            </table>
        </td><td width="11"> </td></tr></table>
        <br/>
        <!-- counters now -->
        <table cellpadding="0" cellspacing="0" border="0" width="1600"><tr><td width="11"> </td><td>
            <table cellpadding="0" cellspacing="0" border="0" class="plain" ><xsl:apply-templates select="node()" />
                <xsl:choose>
                    <xsl:when test="@empty = 'true'">
                        <td class="plain">
                            <br/>
                            No instances in snapshot for filter "<xsl:value-of select="@filter"/>".</td>
                    </xsl:when>
                </xsl:choose>
            </table>
        </td></tr></table>
    </xsl:template>
    
    <!-- Diff  -->
    <xsl:template match="snapshot-diff">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td>
            <a name="snapshot-diff"/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">  <tr>
                <td class="head">
                Snapshot Diff <xsl:value-of select="@name"/>
                </td>
                <td align="right" class="headr" >
                    <xsl:value-of select="@time"/>
                </td>
            </tr></table>
            <br/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                    <xsl:choose>
                        <xsl:when test="@empty = 'false'">
                            <td class="plain">&lt;diff&gt; &nbsp;&nbsp; &lt;class&gt;</td>
                        </xsl:when>
                    </xsl:choose>
                    <td align="right">
                        <form action="heapdiff.page" class="form">&nbsp;
                            <input name="filter" type="text" value="{@filter}" title="Enter a string to filter class name" class="inputtext" size="30" maxlength="1024"/>&nbsp;
                            <input type="submit" class="inputbutton" title="Submit filter for class name" value="filter"/>
                        </form>
                    </td>
                </tr>
            </table>
        </td><td width="11"> </td></tr></table>
        <!-- counters now -->
        <br/>
        <table cellpadding="0" cellspacing="0" border="0" width="1600" class="plain"><tr><td width="11"> </td><td>
            <xsl:apply-templates select="node()" />
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    <br/>
                    No instances in diff for filter "<xsl:value-of select="@filter"/>".
                </xsl:when>
            </xsl:choose>
        </td></tr></table>
    </xsl:template>

    <xsl:template match="snapshot-diff-with-bargraph">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td>
            <a name="snapshot-diff"/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">  <tr>
                <td class="head">
                Snapshot Diff <xsl:value-of select="@name"/>
                </td>
                <td align="right" class="headr" >
                    <xsl:value-of select="@time"/>
                </td>
            </tr></table>
            <br/>
            <table cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
                    <xsl:choose>
                        <xsl:when test="@empty = 'false'">
                            <td class="plain" width="100">&lt;diff&gt; </td>
                            <td class="plain"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;class&gt;</td>
                        </xsl:when>
                    </xsl:choose>
                    <td align="right">
                        <form action="heapdiff.page" class="form">&nbsp;
                            <input name="filter" type="text" value="{@filter}" title="Enter a string to filter class name" class="inputtext" size="30" maxlength="1024"/>&nbsp;
                            <input type="submit" class="inputbutton" title="Submit filter for class name" value="filter"/>
                        </form>
                    </td>
                </tr>
            </table>
        </td><td width="11"> </td></tr></table>
        <!-- counters now -->
        <br/>
        <table cellpadding="0" cellspacing="0" border="0" width="1600"><tr><td width="11"> </td><td>
            <table cellpadding="0" cellspacing="0" border="0" class="plain" ><tbody>
                <xsl:apply-templates select="node()" />
                <xsl:choose>
                    <xsl:when test="@empty = 'true'">
                        <td class="plain">
                            <br/>
                            No instances in diff for filter "<xsl:value-of select="@filter"/>".</td>
                    </xsl:when>
                </xsl:choose>
            </tbody></table>
        </td></tr></table>
    </xsl:template>

    <!--
        Snapshot and Diff both -
        Render instance counter for snapshot and diff

        @param value the count - string with dots (9)
        @param class the name of the class
        @param link the link to the grouppage or the scanpage - when not set then do not link
        @param style the style - plain or plain-diff
    -->
    <xsl:template match="counter">
        <font class="{@style}"> 
            <xsl:value-of select="@value"/>
            <xsl:choose>
                <xsl:when test="@link" >
                    <a href="{@link}" title="Click to show instances">
                        <xsl:value-of select="@class"/>
                    </a>
                </xsl:when>
                <xsl:otherwise >
                    <xsl:value-of select="@class"/>
                </xsl:otherwise>
            </xsl:choose>
        </font>
        <br/>
    </xsl:template>


    <!-- 
        @param bar the pixel width of the bar darkblue
        @param space the pixel width of the bar lightgray,
               rule: bar + space = 90px
    -->
    <xsl:template match="counter-with-bargraph">
        <tr><td width="100">
        <table cellpadding="0" cellspacing="0" border="0" height="10"><tr>
            <xsl:choose>
                <xsl:when test="@bar">
                    <td bgcolor="#c0c0e0" width="{@bar}"></td> 
                </xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@space">
                    <td bgcolor="#e9e9e9" width="{@space}"></td>
                </xsl:when>
            </xsl:choose>
        </tr></table>
        </td><td>
            <xsl:value-of select="@value"/>
            <xsl:choose>
                <xsl:when test="@link" >
                    <a href="{@link}" title="Click to show instances">
                        <xsl:value-of select="@class"/>
                    </a>
                </xsl:when>
                <xsl:otherwise >
                    <xsl:value-of select="@class"/>
                </xsl:otherwise>
            </xsl:choose>
        </td></tr>
    </xsl:template>

    <!-- 
        for diff only
        @param style the style - plain or plain-diff
    -->
    <xsl:template match="counter-with-diff-bargraph">
        <tr><td width="100">
        <table cellpadding="0" cellspacing="0" border="0" height="10"><tbody><tr>
           <xsl:choose>
               <xsl:when test="@minusspace">
                   <td bgcolor="#e9e9e9" width="{@minusspace}"> </td>
               </xsl:when>
           </xsl:choose>
            <xsl:choose>
                <xsl:when test="@minusbar">
                    <td bgcolor="#489655" width="{@minusbar}"> </td>
                </xsl:when>
            </xsl:choose>
           <td bgcolor="#fffff" width="3"> </td>
            <xsl:choose>
                <xsl:when test="@plusbar">
                   <td bgcolor="#c95f61" width="{@plusbar}"> </td>
                </xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@plusspace">
                    <td bgcolor="#e9e9e9" width="{@plusspace}"> </td>
                </xsl:when>
            </xsl:choose>
           </tr></tbody>
        </table>
        </td><td class="{@style}">
            <xsl:value-of select="@value"/>
            <xsl:choose>
                <xsl:when test="@link" >
                    <a href="{@link}" title="Click to show instances">
                        <xsl:value-of select="@class"/>
                    </a>
                </xsl:when>
                <xsl:otherwise >
                    <xsl:value-of select="@class"/>
                </xsl:otherwise>
            </xsl:choose>
        </td></tr>
    </xsl:template>

    <!-- 
    Group By Reference result
    @param class the class where to group instances
    @node the dump
    -->
    <xsl:template match="group-by-ref">
        <table cellpadding="0" cellspacing="0" border="0" width="1600" class="plain"><tr><td width="11"> </td><td>
            <a name="group-by-ref"/>
            <div class="head">
    Group By Reference for <xsl:value-of select="@class"/>
            </div>
            <br/>
            <xsl:apply-templates select="node()"/>
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    No instances of <xsl:value-of select="@class"/> strongly reachable yet.
                </xsl:when>
            </xsl:choose>
        </td></tr></table>
    </xsl:template> 

    <xsl:template match="group-by-ref-diff">
        <table cellpadding="0" cellspacing="0" border="0" width="1600" class="plain"><tr><td width="11"> </td><td>
            <a name="group-by-ref"/>
            <div class="head">
    Group By Reference for <xsl:value-of select="@class"/> in Diff
            </div>
            <br/>
            <xsl:apply-templates select="node()"/>
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    No instances of <xsl:value-of select="@class"/> in diff strongly reachable yet.
                </xsl:when>
            </xsl:choose>
        </td></tr></table>
    </xsl:template>

    <!-- Scan Pages -->
    <xsl:template match="scan">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td>
            <a name="scan"/> 
            <div class="head">Show Reference Graphs for <xsl:value-of select="@class"/></div> 
            <br/>
        </td><td width="11"> </td></tr></table>
        <xsl:apply-templates select="node()"/> 
    </xsl:template> 

    <xsl:template match="scanned-instance">
        <table cellpadding="0" cellspacing="0" border="0" width="100%" class="plain"><tr><td width="11"> </td><td>
            <xsl:apply-templates select="node()" />
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    <br/>
                    <xsl:choose>
                        <xsl:when test="@collected = 'false'" >
                            No instance        
                        </xsl:when>
                        <xsl:otherwise>
                            No more instances                            
                        </xsl:otherwise>
                    </xsl:choose>
                    of <xsl:value-of select="@class"/> in <xsl:value-of select="@scope"/> strongly reachable yet.                    
                </xsl:when> 
            </xsl:choose>
            <td class="td1r" align="right">
                <xsl:choose>
                    <xsl:when test="@prev">
                            <a href="{@prev}" title="Go to previous instance">prev</a>
                    </xsl:when>
                    <xsl:otherwise>
                        <u><font color="#9f9f9f">
                        prev                        
                        </font></u>
                    </xsl:otherwise>
                </xsl:choose>
                 &laquo; <xsl:value-of select="@index"/> 
                 of  <xsl:value-of select="@total"/> &raquo;  
                <a href="{@next}" title="Go to next instance">next</a>
            </td>
        </td><td width="11"> </td></tr></table>
    </xsl:template> 

    <xsl:template match="scanned-references">
        <table cellpadding="0" cellspacing="0" border="0" width="1600" class="plain"><tr><td width="11"> </td><td>
            <xsl:apply-templates select="node()"/>
            <xsl:choose>
                <xsl:when test="@empty = 'true'">
                    <br/>
                    No more references to this instance.
                </xsl:when> 
            </xsl:choose>
        </td></tr></table>
    </xsl:template> 
    
    <xsl:template match="add-info">
        <font class="add-info">  &nbsp; &nbsp;  ( <xsl:value-of select="node()"/> )</font>
    </xsl:template>

    <xsl:template match="text">
        <table cellpadding="0" cellspacing="0" border="0" width="100%"><tr><td width="11"> </td><td class="td1">
            <xsl:apply-templates select="node()"/>
        </td><td width="11"> </td></tr></table>
    </xsl:template>

    <xsl:template match="blink">
        <blink>
            <xsl:apply-templates select="node()" />
        </blink>
    </xsl:template>

    <xsl:template match="red">
            <font color="#ee0000">
                <xsl:apply-templates select="node()" />
            </font>
    </xsl:template>

</xsl:stylesheet>