/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/03/27 20:40:53
!  AUTHOR(S): KOGA, Junichiro
!  File : ChoosableOption.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis.perlscriptexecuters;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

public class ChoosableOption extends PerlScriptOption {
    private Logger logger = Logger.getLogger(ChoosableOption.class.getName());

    public ChoosableOption(String optionName, String[] choices) {
        super(optionName, choices);
    }

    public String generateOptions() {
        // TODO Auto-generated method stub
        return "-" + optionName + "=" + combo.getSelectedItem().toString();
    }

    private JComboBox combo;

    public JComponent[] getAssociatedGUI() {
        // TODO Auto-generated method stub
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(optionName));
        combo = new JComboBox(choices);
        panel.add(combo);

        return new JComponent[] { panel };
    }

    public String getOptionType() {
        // TODO Auto-generated method stub
        return "choosable";
    }

}
