/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : SceneGraphElementBG.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DDataManager;

public abstract class SceneGraphElementBG extends BranchGroup implements
        ConfigData {

    public static final int ATOM = 0;
    public static final int BOND = 1;
    public static final int CELL = 2;
    public static final int AXIS = 3;
    public static final int LEGEND = 4;
    public static final int BG = 5;
    public static final int LIGHT = 6;

    public static final int MEASURE = 7;
    protected ConfigDataManager mCD;
    protected J3DDataManager mACVD;
    protected TGAtom parent;

    public SceneGraphElementBG() {
        this.setCapability(Group.ALLOW_CHILDREN_EXTEND);
        this.setCapability(Group.ALLOW_CHILDREN_READ);
        this.setCapability(Group.ALLOW_CHILDREN_WRITE);
        this.setCapability(BranchGroup.ALLOW_DETACH);
    }

    public abstract int getType();

    protected abstract void create();

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean rescaleOnUpdate,
            ConfigDataUpdateEvent e) {
    }

    public boolean needsUpdate() {
        return false;
    }

    public void register(ConfigDataManager mCD, J3DDataManager mACVD,
            TGAtom parent) {
        this.mCD = mCD;
        this.mACVD = mACVD;
        this.parent = parent;
    }

}
