/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/06/24, 18:12
!  AUTHOR(S): KOGA, Junichiro
!  File : JButtonEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.ssh.remotehostexecuter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.Desk;

/**
 * 
 * @author KOGA, Junichiro
 */
public class JButtonEditor extends AbstractCellEditor implements
        TableCellEditor, ActionListener {
    private Logger logger = Logger.getLogger(JButtonEditor.class.getName());
    private JButton button;
    private JLabelRenderer jr;
    private String popupText;

    /**
     * Creates a new instance of JButtonEditor
     */
    public JButtonEditor(String text) {
        button = new JButton(text);
        button.addActionListener(this);
    }

    public JButtonEditor(String text, JLabelRenderer jr) {
        button = new JButton(text);
        this.jr = jr;
        button.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug("action performed!");
        popupText = jr.getText();
        JOptionPane.showInternalMessageDialog(Desk.getDesktop(), popupText);
        fireEditingStopped(); // Make the renderer reappear.
    }

    // Implement the one CellEditor method that AbstractCellEditor doesn't.
    public Object getCellEditorValue() {
        return popupText;
    }

    // Implement the one method defined by TableCellEditor.
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {
        if (value instanceof String) {
            popupText = (String) value;
        }
        return button;
    }

}
