/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 11:45
!  AUTHOR(S): KOGA, Junichiro
!  File : DeleteButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.Utils;

/**
 * 
 * @author KOGA, Junichiro
 */
public class DeleteButton extends JButton implements Command {
    private JTable table;

    public DeleteButton(JTable table, EventListener el) {
        super("delete");
        this.table = table;
        addActionListener((ActionListener) el);
    }

    public void execute(EventObject e) {
        Utils.stop(table);
        int[] rows = table.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; i--) {
            ((DefaultTableModel) table.getModel()).removeRow(rows[i]);
        }
        table.revalidate();
    }

}
