/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : UnitManager.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

public class UnitManager {
    private Object frame;
    private int UNIT_LIST_SIZE;
    private String FACT_DEF;
    public String TYP_ENERGY;
    public String TYP_LEN;

    /**
     * 
     * @uml.property name="unitList"
     * @uml.associationEnd multiplicity="(0 -1)"
     */
    public typDef unitList[];

    /** 萔̒`Ȃǂs. */
    public UnitManager(Object frame) {
        this.frame = frame;

        this.UNIT_LIST_SIZE = ConstParameters.UNIT_LIST_SIZE;
        this.TYP_ENERGY = ConstParameters.TYP_ENERGY;
        this.TYP_LEN = ConstParameters.TYP_LEN;

        unitList = new typDef[UNIT_LIST_SIZE];

        // set unitList
        unitList[0] = new typDef("bohr", FACT_DEF, TYP_LEN);
        unitList[1] = new typDef("angstrom", FACT_DEF, TYP_LEN);
        unitList[2] = new typDef("nm", FACT_DEF, TYP_LEN);
    }

    /**
     * Pʖ, ̎ނԂ. Ⴆ``bohr''Ƃ``length''𓾂.
     * 
     * @param unit_name
     *            Pʖ.
     * @return Pʂ̎.
     */
    public String getUnitTyp(String unit_name) {
        int i, iret;
        String retString;
        for (i = 0; i < UNIT_LIST_SIZE; i++) {
            iret = unit_name.compareToIgnoreCase(unitList[i].getName());
            if (iret == 0) {
                break;
            }
        }

        if (i == UNIT_LIST_SIZE) {
            retString = unit_name + " not in unit list!";
            return (retString);
        } else {
            return (unitList[i].getTyp());
        }
    }
}

/**
 * uPʂ̒`vɎgpNX.
 */
class typDef {
    String name;
    String factor;
    String type;

    public typDef(String name, String factor, String type) {
        this.name = name;
        this.factor = factor;
        this.type = type;
    }

    /**
     * 
     * @uml.property name="name"
     */
    public String getName() {
        return (name);
    }

    public String getFact() {
        return (factor);
    }

    public String getTyp() {
        return (type);
    }
}
