/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSourceMenuFactory;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.Legend;
import jas.plot.LegendEntry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

abstract class AbstractDataManager
extends DataManager
implements Runnable {
    protected transient Timer timer;
    protected transient boolean isInit = false;
    protected Legend legend;
    protected StatisticsBlock stats;
    protected transient int nVisible;
    protected transient int nVisibleLegend;
    protected transient Vector data = new Vector();

    AbstractDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea);
        this.legend = legend;
        this.stats = statisticsBlock;
        this.nVisible = 0;
        this.nVisibleLegend = 0;
        this.xm.setFixed(false);
        this.xm.setRangeAutomatic(true);
        this.ym[0].setFixed(false);
        this.ym[0].setRangeAutomatic(true);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDataManager.this.doUpdate();
            }
        });
        this.timer.setRepeats(false);
    }

    void init() {
        this.computeXAxisRange();
        this.XAxisUpdated();
        this.computeYAxisRange();
        this.isInit = true;
    }

    final void invalidate() {
        if (this.isInit) {
            SwingUtilities.invokeLater(this);
        }
    }

    public final void run() {
        this.doUpdate();
    }

    boolean isRealized() {
        return this.isInit;
    }

    void setRealized(boolean bl) {
        this.isInit = bl;
    }

    void requestShow(JASHistData jASHistData) {
        LegendEntry legendEntry;
        this.da.add(jASHistData.getOverlay());
        ++this.nVisible;
        if (this.legend != null && (legendEntry = jASHistData.getLegendEntry()) != null) {
            this.legend.add(legendEntry);
            ++this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.add(jASHistData);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.computeYAxisRange();
            this.da.validate();
            this.da.repaint();
        }
    }

    void requestHide(JASHistData jASHistData) {
        LegendEntry legendEntry;
        this.da.remove(jASHistData.getOverlay());
        --this.nVisible;
        if (this.legend != null && (legendEntry = jASHistData.getLegendEntry()) != null) {
            this.legend.remove(legendEntry);
            --this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.remove(jASHistData);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.computeYAxisRange();
            this.da.validate();
            this.da.repaint();
        }
    }

    protected void showLegend() {
        int n = this.plot.getShowLegend();
        boolean bl = n == 2 || n == 1 && this.nVisibleLegend > 1;
        this.legend.setVisible(bl);
        this.legend.revalidate();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDataManager.this.doUpdate();
            }
        });
        this.timer.setRepeats(false);
        this.da.add(this.xm, (Object)"x");
        this.da.add(this.ym[0], (Object)"yl");
        this.da.add(this.ym[1], (Object)"yr");
    }

    abstract void doUpdate();

    void remove(JASHistData jASHistData) {
        jASHistData.show(false);
        jASHistData.deleteNormalizationObserver();
        this.data.removeElement(jASHistData);
    }

    int numberOfDataSources() {
        return this.data.size();
    }

    void destroy() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHistData jASHistData = (JASHistData)enumeration.nextElement();
            jASHistData.show(false);
            jASHistData.deleteNormalizationObserver();
        }
        this.data.removeAllElements();
        this.destroyYAxis(1);
        this.stats.clear();
    }

    Enumeration getDataSources() {
        return this.data.elements();
    }

    JMenu addPerDataSourceMenu(String string, DataSourceMenuFactory dataSourceMenuFactory) {
        int n = this.numberOfDataSources();
        if (n == 0) {
            JMenu jMenu = new JMenu(string);
            jMenu.setEnabled(false);
            return jMenu;
        }
        if (n == 1) {
            JASHistData jASHistData = (JASHistData)this.getDataSources().nextElement();
            return dataSourceMenuFactory.createMenu(string, jASHistData);
        }
        JMenu jMenu = new JMenu(string);
        Enumeration enumeration = this.getDataSources();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JASHistData jASHistData = (JASHistData)enumeration.nextElement();
            JMenu jMenu2 = dataSourceMenuFactory.createMenu(jASHistData.getTitle(), jASHistData);
            jMenu2.setMnemonic(48 + (char)n2);
            jMenu.add(jMenu2);
            ++n2;
        }
        return jMenu;
    }
}

