/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.RangeFieldPanelKit;
import AbinitMp.Viewer.StartEnd;
import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class OverlayPanel
extends RangeFieldPanelKit {
    private MyComboBox typeComboBox;
    private MyComboBox methodComboBox;
    private MyComboBox fileComboBox1;
    private MyComboBox fileComboBox2;
    private JTextField rangeText1;
    private JTextField rangeText2;
    public Vector residueAssign1 = new Vector();
    public Vector residueAssign2 = new Vector();
    private int forcus = 0;
    private AbinitMpViewer viewer;
    private String[] methodStrings = new String[]{"C\u03b1", "Heavy Atoms", "All Atoms"};
    private String[] typeStrings = new String[]{"File", "Residue", "Atom"};

    public OverlayPanel(AbinitMpViewer abinitMpViewer, String[] stringArray) {
        this.viewer = abinitMpViewer;
        this.typeComboBox = new MyComboBox(this.typeStrings);
        MyPanel myPanel = new MyPanel(new FlowLayout(0));
        myPanel.add(this.typeComboBox);
        this.typeComboBox.addActionListener(new typeListener());
        this.methodComboBox = new MyComboBox(this.methodStrings);
        MyPanel myPanel2 = new MyPanel(new FlowLayout(0));
        myPanel2.add(this.methodComboBox);
        this.fileComboBox1 = new MyComboBox(stringArray);
        this.fileComboBox2 = new MyComboBox(stringArray);
        if (stringArray.length > 1) {
            this.fileComboBox2.setSelectedIndex(1);
        }
        this.rangeText1 = new JTextField();
        this.rangeText1.setPreferredSize(new Dimension(200, 28));
        this.rangeText2 = new JTextField();
        this.rangeText2.setPreferredSize(new Dimension(200, 28));
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("OverlayPanel.type")), 0, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("OverlayPanel.method")), 0, 1, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel2, 5, 1, 5, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("OverlayPanel.fitResidueNumber")), 0, 2, 5, 1, 1.0, 0.0);
        this.layoutObject(this.fileComboBox1, 0, 3, 5, 1, 1.0, 0.0);
        this.layoutObject(this.rangeText1, 5, 3, 5, 1, 1.0, 0.0);
        this.layoutObject(this.fileComboBox2, 0, 4, 5, 1, 1.0, 0.0);
        this.layoutObject(this.rangeText2, 5, 4, 5, 1, 1.0, 0.0);
        this.rangeText1.setEnabled(false);
        this.rangeText2.setEnabled(false);
    }

    public boolean conform() {
        int n = this.typeComboBox.getSelectedIndex();
        int n2 = this.methodComboBox.getSelectedIndex();
        int n3 = this.fileComboBox1.getSelectedIndex();
        int n4 = this.fileComboBox2.getSelectedIndex();
        this.parseText(this.residueAssign1, this.rangeText1);
        this.parseText(this.residueAssign2, this.rangeText2);
        PdbFile pdbFile = this.viewer.getPdbFileFromTabIndex(n3);
        PdbFile pdbFile2 = this.viewer.getPdbFileFromTabIndex(n4);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string = new String("Overlay ");
        if (n == 0) {
            this.setAtomsFile(pdbFile, vector, n2);
            this.setAtomsFile(pdbFile2, vector2, n2);
        } else if (n == 1) {
            this.setAtomsResidue(pdbFile, vector, n2, this.residueAssign1);
            this.setAtomsResidue(pdbFile2, vector2, n2, this.residueAssign2);
        } else {
            this.setAtomsAtom(pdbFile, vector, this.residueAssign1);
            this.setAtomsAtom(pdbFile2, vector2, this.residueAssign2);
        }
        if (vector.size() != 0) {
            int n5;
            string = string.concat("type:" + this.typeStrings[n]).concat(" method:" + this.methodStrings[n2]).concat(" [" + (String)this.fileComboBox1.getItemAt(this.fileComboBox1.getSelectedIndex())).concat(" " + this.rangeText1.getText()).concat("] [" + (String)this.fileComboBox2.getItemAt(this.fileComboBox2.getSelectedIndex())).concat(" " + this.rangeText2.getText() + "]");
            this.viewer.addMessageln(string);
            int n6 = vector.size();
            int n7 = vector2.size();
            if (n6 > n7) {
                for (n5 = n6 - 1; n5 > n7 - 1; --n5) {
                    vector.remove(n5);
                }
                this.viewer.addMessageln("Warning!! Delete elements by reason of unmatch number of element.");
            } else if (n6 < n7) {
                for (n5 = n7 - 1; n5 > n6 - 1; --n5) {
                    vector2.remove(n5);
                }
                this.viewer.addMessageln("Warning!! Delete elements by reason of unmatch number of element.");
            }
            FileItem fileItem = this.viewer.getFileItem(n3);
            FileItem fileItem2 = this.viewer.getFileItem(n4);
            this.setNewCoordinate(vector, vector2, fileItem, fileItem2);
            this.viewer.displayMoNode();
        } else {
            this.viewer.addMessageln("No match atoms.");
        }
        return true;
    }

    public void close() {
        this.viewer.setOverlayDialog(null, null);
    }

    private void setAtomsFile(PdbFile pdbFile, Vector vector, int n) {
        Vector vector2 = pdbFile.chains;
        for (int i = 0; i < vector2.size(); ++i) {
            AtomData atomData;
            int n2;
            ChainData chainData = (ChainData)vector2.get(i);
            Vector vector3 = chainData.atomTable;
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                atomData = (AtomData)vector3.get(n2);
                if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || !(n == 0 && atomData.allAtomName.equalsIgnoreCase("CA") || n == 0 && atomData.allAtomName.equalsIgnoreCase("C3'") || n == 1 && !atomData.atomName.equalsIgnoreCase("H")) && n != 2) continue;
                vector.add(atomData);
            }
            vector3 = chainData.hemTable;
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                atomData = (AtomData)vector3.get(n2);
                if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || !(n == 0 && atomData.allAtomName.equalsIgnoreCase("CA") || n == 0 && atomData.allAtomName.equalsIgnoreCase("C3'") || n == 1 && !atomData.atomName.equalsIgnoreCase("H")) && n != 2) continue;
                vector.add(atomData);
            }
        }
    }

    private void setAtomsAtom(PdbFile pdbFile, Vector vector, Vector vector2) {
        for (int i = 0; i < vector2.size(); ++i) {
            int n = ((StartEnd)vector2.get((int)i)).start;
            int n2 = ((StartEnd)vector2.get((int)i)).end;
            block1: for (int j = n; j <= n2; ++j) {
                Vector vector3 = pdbFile.chains;
                for (int k = 0; k < vector3.size(); ++k) {
                    int n3;
                    ChainData chainData = (ChainData)vector3.get(k);
                    Vector vector4 = chainData.atomTable;
                    AtomData atomData = null;
                    for (n3 = 0; n3 < vector4.size(); ++n3) {
                        atomData = (AtomData)vector4.get(n3);
                        if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || j != atomData.no) continue;
                        vector.add(atomData);
                        break;
                    }
                    if (atomData != null && j == atomData.no) continue block1;
                    vector4 = chainData.hemTable;
                    for (n3 = 0; n3 < vector4.size(); ++n3) {
                        atomData = (AtomData)vector4.get(n3);
                        if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || j != atomData.no) continue;
                        vector.add(atomData);
                        break;
                    }
                    if (j == atomData.no) continue block1;
                }
            }
        }
    }

    private void setAtomsResidue(PdbFile pdbFile, Vector vector, int n, Vector vector2) {
        for (int i = 0; i < vector2.size(); ++i) {
            int n2 = ((StartEnd)vector2.get((int)i)).start;
            int n3 = ((StartEnd)vector2.get((int)i)).end;
            for (int j = n2; j <= n3; ++j) {
                Vector vector3 = pdbFile.chains;
                for (int k = 0; k < vector3.size(); ++k) {
                    AtomData atomData;
                    int n4;
                    ChainData chainData = (ChainData)vector3.get(k);
                    Vector vector4 = chainData.residueTable;
                    Vector vector5 = chainData.atomTable;
                    ResidueData residueData = this.getResidueData(vector4, j);
                    if (residueData != null) {
                        for (n4 = residueData.startNo; n4 <= residueData.endNo; ++n4) {
                            atomData = (AtomData)vector5.get(n4);
                            if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || !(n == 0 && atomData.allAtomName.equalsIgnoreCase("CA") || n == 0 && atomData.allAtomName.equalsIgnoreCase("C3'") || n == 1 && !atomData.atomName.equalsIgnoreCase("H")) && n != 2) continue;
                            vector.add(atomData);
                        }
                        continue;
                    }
                    vector4 = chainData.hemResidueTable;
                    vector5 = chainData.hemTable;
                    residueData = this.getResidueData(vector4, j);
                    if (residueData == null) continue;
                    for (n4 = residueData.startNo; n4 <= residueData.endNo; ++n4) {
                        atomData = (AtomData)vector5.get(n4);
                        if (atomData.iCode != null && atomData.iCode.trim().length() != 0 || !(n == 0 && atomData.allAtomName.equalsIgnoreCase("CA") || n == 0 && atomData.allAtomName.equalsIgnoreCase("C3'") || n == 1 && !atomData.atomName.equalsIgnoreCase("H")) && n != 2) continue;
                        vector.add(atomData);
                    }
                }
            }
        }
    }

    public void setOverlayInfo(int n, int n2) {
        Vector vector;
        JTextField jTextField;
        MyComboBox myComboBox;
        if (this.typeComboBox.getSelectedIndex() == 0) {
            return;
        }
        if (this.fileComboBox1.getSelectedIndex() == n) {
            this.forcus = 0;
        } else if (this.fileComboBox2.getSelectedIndex() == n) {
            this.forcus = 1;
        } else {
            return;
        }
        if (this.forcus == 0) {
            myComboBox = this.fileComboBox1;
            jTextField = this.rangeText1;
            vector = this.residueAssign1;
        } else {
            myComboBox = this.fileComboBox2;
            jTextField = this.rangeText2;
            vector = this.residueAssign2;
        }
        myComboBox.setSelectedIndex(n);
        this.parseText(vector, jTextField);
        this.setResidueNo(vector, jTextField, n2);
    }

    private void setNewCoordinate(Vector vector, Vector vector2, FileItem fileItem, FileItem fileItem2) {
        Object object;
        int n;
        int n2;
        double[] dArray = new double[3];
        double[] dArray2 = this.calcCoordnate(vector, fileItem);
        double[] dArray3 = this.calcCoordnate(vector2, fileItem2);
        int n3 = dArray2.length / 3;
        double[] dArray4 = this.calcCenter(dArray2);
        double[] dArray5 = this.calcCenter(dArray3);
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < 3; ++i) {
                dArray3[n2 * 3 + i] = dArray3[n2 * 3 + i] - dArray5[i];
            }
        }
        double d = 1.0;
        double d2 = Double.parseDouble(MyResourceBundle.getResourceString("OverlayPanel.epsiron"));
        int n4 = Integer.parseInt(MyResourceBundle.getResourceString("OverlayPanel.limit"));
        for (n2 = 0; d > d2 && n2 < n4; ++n2) {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                for (int i = 0; i < 3; ++i) {
                    dArray2[n5 * 3 + i] = dArray2[n5 * 3 + i] - dArray4[i];
                }
            }
            for (n5 = 0; n5 < 3; ++n5) {
                dArray[n5] = dArray5[n5] - dArray4[n5];
            }
            double[][] dArray6 = new double[3][3];
            if (n3 >= 3) {
                int n6;
                double[][] dArray7 = new double[3][3];
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            dArray7[j][i] = dArray7[j][i] + dArray3[j + n * 3] * dArray2[i + n * 3];
                        }
                    }
                }
                Matrix matrix = new Matrix(dArray7);
                Matrix matrix2 = matrix.transpose();
                object = matrix2.times(matrix);
                EigenvalueDecomposition eigenvalueDecomposition = ((Matrix)object).eig();
                Matrix matrix3 = eigenvalueDecomposition.getV();
                double[] dArray8 = new double[3];
                for (int i = 0; i < 3; ++i) {
                    dArray8[i] = eigenvalueDecomposition.getD().get(i, i);
                }
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2 - i; ++j) {
                        if (!(dArray8[j] < dArray8[j + 1])) continue;
                        double d3 = dArray8[j];
                        dArray8[j] = dArray8[j + 1];
                        dArray8[j + 1] = d3;
                        for (int k = 0; k < 3; ++k) {
                            d3 = matrix3.get(k, j);
                            matrix3.set(k, j, matrix3.get(k, j + 1));
                            matrix3.set(k, j + 1, d3);
                        }
                    }
                }
                double[][] dArray9 = matrix3.getArray();
                dArray9[0][2] = dArray9[1][0] * dArray9[2][1] - dArray9[2][0] * dArray9[1][1];
                dArray9[1][2] = dArray9[2][0] * dArray9[0][1] - dArray9[0][0] * dArray9[2][1];
                dArray9[2][2] = dArray9[0][0] * dArray9[1][1] - dArray9[1][0] * dArray9[0][1];
                Matrix[] matrixArray = new Matrix[3];
                Matrix matrix4 = new Matrix(3, 1);
                for (int i = 0; i < 3; ++i) {
                    int n7;
                    for (n7 = 0; n7 < 3; ++n7) {
                        matrix4.set(n7, 0, matrix3.get(n7, i));
                    }
                    matrixArray[i] = matrix.times(matrix4);
                    if (i != 2) continue;
                    for (n7 = 0; n7 < 3; ++n7) {
                        matrixArray[i].set(n7, 0, -matrixArray[i].get(n7, 0));
                    }
                }
                double[][] dArray10 = matrixArray[0].getArray();
                double[][] dArray11 = matrixArray[1].getArray();
                double[][] dArray12 = matrixArray[2].getArray();
                for (n6 = 0; n6 < 2; ++n6) {
                    double[][] dArray13 = matrixArray[n6].getArray();
                    double d4 = Math.sqrt(dArray13[0][0] * dArray13[0][0] + dArray13[1][0] * dArray13[1][0] + dArray13[2][0] * dArray13[2][0]);
                    for (int i = 0; i < 3; ++i) {
                        dArray13[i][0] = dArray13[i][0] / d4;
                    }
                }
                dArray12[0][0] = dArray10[1][0] * dArray11[2][0] - dArray10[2][0] * dArray11[1][0];
                dArray12[1][0] = dArray10[2][0] * dArray11[0][0] - dArray10[0][0] * dArray11[2][0];
                dArray12[2][0] = dArray10[0][0] * dArray11[1][0] - dArray10[1][0] * dArray11[0][0];
                for (n6 = 0; n6 < 3; ++n6) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            dArray6[n6][i] = dArray6[n6][i] + matrixArray[j].get(n6, 0) * matrix3.get(i, j);
                        }
                    }
                }
            }
            double[] dArray14 = new double[16];
            if (n3 >= 3) {
                for (n = 0; n < 3; ++n) {
                    for (int i = 0; i < 3; ++i) {
                        dArray14[n * 4 + i] = dArray6[n][i];
                    }
                }
            } else {
                for (n = 0; n < 3; ++n) {
                    dArray14[n * 4 + n] = 1.0;
                }
                this.viewer.addMessageln("Only translation. (Number of atoms < 3)");
            }
            dArray14[15] = 1.0;
            if (n2 > 0) {
                this.calcNewCoord(fileItem, dArray14, dArray4, dArray5, false);
            } else {
                this.calcNewCoord(fileItem, dArray14, dArray4, dArray5, true);
            }
            for (n = 0; n < n3; ++n) {
                AtomData atomData = (AtomData)vector.get(n);
                dArray2[n * 3] = atomData.x;
                dArray2[n * 3 + 1] = atomData.y;
                dArray2[n * 3 + 2] = atomData.z;
            }
            dArray4 = this.calcCenter(dArray2);
            d = Math.abs(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2] - (dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]));
        }
        fileItem2.calcNewCoord(this.viewer);
        this.viewer.calcCoordInfo();
        fileItem.coordInfo.setCenter((float)dArray5[0], (float)dArray5[1], (float)dArray5[2]);
        fileItem2.coordInfo.setCenter((float)dArray5[0], (float)dArray5[1], (float)dArray5[2]);
        this.viewer.getCoordInfo().setCenter((float)dArray5[0], (float)dArray5[1], (float)dArray5[2]);
        double d5 = 0.0;
        for (n = 0; n < vector.size(); ++n) {
            AtomData atomData = (AtomData)vector.get(n);
            object = (AtomData)vector2.get(n);
            d5 = (atomData.x - ((AtomData)object).x) * (atomData.x - ((AtomData)object).x) + (atomData.y - ((AtomData)object).y) * (atomData.y - ((AtomData)object).y) + (atomData.z - ((AtomData)object).z) * (atomData.z - ((AtomData)object).z);
        }
        this.viewer.addMessageln("RMSD " + Math.sqrt(d5 / (double)vector.size()));
    }

    private double[] calcCoordnate(Vector vector, FileItem fileItem) {
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D();
        double[] dArray = new double[vector.size() * 3];
        fileItem.transformGroup.getTransform(transform3D);
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        for (int i = 0; i < vector.size(); ++i) {
            AtomData atomData = (AtomData)vector.get(i);
            transform3D2.setTranslation(new Vector3f(atomData.coordX - fileItem.coordInfo.xcenter + coordInfo.xcenter, atomData.coordY - fileItem.coordInfo.ycenter + coordInfo.ycenter, atomData.coordZ - fileItem.coordInfo.zcenter + coordInfo.zcenter));
            transform3D3.mul(transform3D, transform3D2);
            transform3D3.get(matrix4d);
            double d = matrix4d.m03 + (double)fileItem.coordInfo.xcenter;
            double d2 = matrix4d.m13 + (double)fileItem.coordInfo.ycenter;
            double d3 = matrix4d.m23 + (double)fileItem.coordInfo.zcenter;
            dArray[i * 3] = d;
            dArray[i * 3 + 1] = d2;
            dArray[i * 3 + 2] = d3;
        }
        return dArray;
    }

    private void calcNewCoord(FileItem fileItem, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D3 = new Transform3D();
        Transform3D transform3D4 = new Transform3D();
        Vector3d vector3d = new Vector3d();
        PdbFile pdbFile = fileItem.getPdbFile();
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        fileItem.transformGroup.getTransform(transform3D);
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = null;
            for (int j = 0; j < 2; ++j) {
                vector2 = j == 0 ? chainData.atomTable : chainData.hemTable;
                for (int k = 0; k < vector2.size(); ++k) {
                    double d;
                    double d2;
                    double d3;
                    AtomData atomData = (AtomData)vector2.get(k);
                    if (bl) {
                        vector3d.set((double)(atomData.coordX - fileItem.coordInfo.xcenter + coordInfo.xcenter), (double)(atomData.coordY - fileItem.coordInfo.ycenter + coordInfo.ycenter), (double)(atomData.coordZ - fileItem.coordInfo.zcenter + coordInfo.zcenter));
                        transform3D3.setTranslation(vector3d);
                        transform3D4.mul(transform3D, transform3D3);
                        transform3D4.get(matrix4d);
                        d3 = matrix4d.m03 + (double)fileItem.coordInfo.xcenter - dArray2[0];
                        d2 = matrix4d.m13 + (double)fileItem.coordInfo.ycenter - dArray2[1];
                        d = matrix4d.m23 + (double)fileItem.coordInfo.zcenter - dArray2[2];
                    } else {
                        d3 = (double)atomData.x - dArray2[0];
                        d2 = (double)atomData.y - dArray2[1];
                        d = (double)atomData.z - dArray2[2];
                    }
                    vector3d.set(d3, d2, d);
                    transform3D3.setTranslation(vector3d);
                    transform3D2.set(dArray);
                    transform3D4.mul(transform3D2, transform3D3);
                    transform3D4.get(matrix4d);
                    atomData.x = (float)(matrix4d.m03 + dArray3[0]);
                    atomData.y = (float)(matrix4d.m13 + dArray3[1]);
                    atomData.z = (float)(matrix4d.m23 + dArray3[2]);
                }
            }
        }
    }

    private double[] calcCenter(double[] dArray) {
        int n;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        int n2 = dArray.length / 3;
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = dArray[2];
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        dArray3[2] = dArray[2];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 3; ++i) {
                dArray2[i] = Math.min(dArray2[i], dArray[n * 3 + i]);
                dArray3[i] = Math.max(dArray3[i], dArray[n * 3 + i]);
            }
        }
        for (n = 0; n < 3; ++n) {
            dArray4[n] = (dArray3[n] - dArray2[n]) / 2.0 + dArray2[n];
        }
        return dArray4;
    }

    class typeListener
    extends AbstractAction {
        typeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OverlayPanel.this.rangeText1.setText("");
            OverlayPanel.this.rangeText2.setText("");
            if (OverlayPanel.this.typeComboBox.getSelectedIndex() == 0) {
                OverlayPanel.this.rangeText1.setEnabled(false);
                OverlayPanel.this.rangeText2.setEnabled(false);
                OverlayPanel.this.methodComboBox.setEnabled(true);
            } else if (OverlayPanel.this.typeComboBox.getSelectedIndex() == 1) {
                OverlayPanel.this.viewer.setSelectionMode(2);
                OverlayPanel.this.rangeText1.setEnabled(true);
                OverlayPanel.this.rangeText2.setEnabled(true);
                OverlayPanel.this.methodComboBox.setEnabled(true);
            } else if (OverlayPanel.this.typeComboBox.getSelectedIndex() == 2) {
                OverlayPanel.this.viewer.setSelectionMode(3);
                OverlayPanel.this.rangeText1.setEnabled(true);
                OverlayPanel.this.rangeText2.setEnabled(true);
                OverlayPanel.this.methodComboBox.setEnabled(false);
            }
        }
    }
}

