/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.DisplayPreference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;

public class IsoPreferenceWindow
extends BaseWindow {
    private MyButton[] buttons;
    private Vector modifyButtons = new Vector();
    private Color3f[] colorData;
    private int size = 3;
    private AbinitMpViewer viewer;

    public IsoPreferenceWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("IsoPreferenceWindow.Title"));
        Serializable serializable;
        Serializable serializable2;
        this.viewer = abinitMpViewer;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.buttons = new MyButton[this.size];
        this.colorData = new Color3f[this.size];
        String[] stringArray = new String[this.size];
        this.colorData[0] = DisplayPreference.densityColor;
        stringArray[0] = MyResourceBundle.getResourceString("IsoPreferenceWindow.density");
        this.colorData[1] = DisplayPreference.moMinusColor;
        stringArray[1] = MyResourceBundle.getResourceString("IsoPreferenceWindow.moMinus");
        this.colorData[2] = DisplayPreference.moPlusColor;
        stringArray[2] = MyResourceBundle.getResourceString("IsoPreferenceWindow.moPlus");
        this.getJMenuBar().add(this.addMenuItem("IsoPreferenceWindow.fileMenuTitle", "IsoPreferenceWindow.fileMenu", (Action)new fileListener()));
        MyPanel myPanel = new MyPanel(new GridLayout(0, 2));
        for (int i = 0; i < this.size; ++i) {
            myPanel.add(new JLabel(stringArray[i]));
            serializable2 = new buttonListener();
            serializable = new MyButton();
            serializable.setActionCommand(Integer.toString(i));
            this.buttons[i] = serializable;
            serializable.addActionListener((ActionListener)((Object)serializable2));
            serializable.setBackground(this.colorData[i].get());
            myPanel.add((Component)serializable);
        }
        MyPanel myPanel2 = new MyPanel(new FlowLayout(1));
        serializable2 = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel2.add((Component)serializable2);
        ((AbstractButton)serializable2).addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)myPanel, "Center");
        this.mainPanel.add((Component)myPanel2, "South");
        this.pack();
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        if (((Dimension)serializable).width > 2000) {
            ((Dimension)serializable).width /= 2;
        }
        this.setBounds(((Dimension)serializable).width - 240, 350, 210, 180);
    }

    public void closeProcess() {
        for (int i = 0; i < this.modifyButtons.size(); ++i) {
            MyButton myButton = (MyButton)this.modifyButtons.get(i);
            String string = myButton.getText();
            int n = Integer.parseInt(string) - 1;
            myButton.setBackground(this.colorData[n].get());
        }
        this.modifyButtons.removeAllElements();
    }

    public void setPreference() {
        this.colorData[0] = DisplayPreference.densityColor;
        this.colorData[1] = DisplayPreference.moMinusColor;
        this.colorData[2] = DisplayPreference.moPlusColor;
        for (int i = 0; i < this.size; ++i) {
            this.buttons[i].setBackground(this.colorData[i].get());
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < IsoPreferenceWindow.this.modifyButtons.size(); ++i) {
                MyButton myButton = (MyButton)IsoPreferenceWindow.this.modifyButtons.get(i);
                String string = myButton.getActionCommand();
                Color color = myButton.getBackground();
                int n = Integer.parseInt(string);
                IsoPreferenceWindow.this.colorData[n].set(color);
                IsoPreferenceWindow.this.setWaitCursor();
                IsoPreferenceWindow.this.viewer.displayMoNode();
                IsoPreferenceWindow.this.setDefaultCursor();
            }
            IsoPreferenceWindow.this.modifyButtons.removeAllElements();
        }
    }

    class buttonListener
    extends AbstractAction {
        buttonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            String string = myButton.getText();
            Color color = myButton.getBackground();
            if ((color = JColorChooser.showDialog(myButton, "Color", color)) != null) {
                myButton.setBackground(color);
                IsoPreferenceWindow.this.modifyButtons.add(myButton);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("IsoPreferenceWindow.fileMenu");
            char c = string.charAt(0);
            if (IsoPreferenceWindow.this.getNemonic(stringArray[0]) == c) {
                IsoPreferenceWindow.this.closeProcess();
                IsoPreferenceWindow.this.setVisible(false);
            }
        }
    }
}

