/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ARGBColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JSlider alphaSlider;
    protected JSpinner redSpinner;
    protected JSpinner blueSpinner;
    protected JSpinner greenSpinner;
    protected JSpinner alphaSpinner;
    private final int minValue = 0;
    private final int maxValue = 255;
    private boolean isAdjusting = false;

    private void setColor(Color color) {
        int n = color.getRed();
        int n2 = color.getBlue();
        int n3 = color.getGreen();
        int n4 = color.getAlpha();
        if (this.redSlider.getValue() != n) {
            this.redSlider.setValue(n);
        }
        if (this.greenSlider.getValue() != n3) {
            this.greenSlider.setValue(n3);
        }
        if (this.blueSlider.getValue() != n2) {
            this.blueSlider.setValue(n2);
        }
        if (this.alphaSlider.getValue() != n4) {
            this.alphaSlider.setValue(n4);
        }
        if ((Integer)this.redSpinner.getValue() != n) {
            this.redSpinner.setValue(new Integer(n));
        }
        if ((Integer)this.greenSpinner.getValue() != n3) {
            this.greenSpinner.setValue(new Integer(n3));
        }
        if ((Integer)this.blueSpinner.getValue() != n2) {
            this.blueSpinner.setValue(new Integer(n2));
        }
        if ((Integer)this.alphaSpinner.getValue() != n4) {
            this.alphaSpinner.setValue(new Integer(n4));
        }
    }

    public String getDisplayName() {
        return "ARGB";
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel("Red");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        gridBagLayout.setConstraints(this.redSlider, gridBagConstraints);
        jLabel.setLabelFor(this.redSlider);
        jPanel.add(this.redSlider);
        this.redSpinner = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.redSpinner.addChangeListener(this);
        jPanel2.add(this.redSpinner);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jLabel = new JLabel("Green");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.greenSlider = new JSlider(0, 0, 255, color.getGreen());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        gridBagLayout.setConstraints(this.greenSlider, gridBagConstraints);
        jPanel.add(this.greenSlider);
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        jLabel.setLabelFor(this.greenSlider);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(this.greenSpinner);
        this.greenSpinner.addChangeListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        jLabel = new JLabel("Blue");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.blueSlider = new JSlider(0, 0, 255, color.getBlue());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        gridBagLayout.setConstraints(this.blueSlider, gridBagConstraints);
        jPanel.add(this.blueSlider);
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        jLabel.setLabelFor(this.blueSlider);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(this.blueSpinner);
        this.blueSpinner.addChangeListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        jLabel = new JLabel("Alpha");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.alphaSlider = new JSlider(0, 0, 255, color.getAlpha());
        this.alphaSlider.setMajorTickSpacing(85);
        this.alphaSlider.setMinorTickSpacing(17);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        gridBagLayout.setConstraints(this.alphaSlider, gridBagConstraints);
        jPanel.add(this.alphaSlider);
        this.alphaSpinner = new JSpinner(new SpinnerNumberModel(color.getAlpha(), 0, 255, 1));
        jLabel.setLabelFor(this.alphaSlider);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.alphaSpinner);
        this.alphaSpinner.addChangeListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.alphaSlider.addChangeListener(this);
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.setColor(this.getColorFromModel());
            this.isAdjusting = false;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider && !this.isAdjusting) {
            int n = this.redSlider.getValue();
            int n2 = this.greenSlider.getValue();
            int n3 = this.blueSlider.getValue();
            int n4 = this.alphaSlider.getValue();
            Color color = new Color(n, n2, n3, n4);
            this.getColorSelectionModel().setSelectedColor(color);
        } else if (changeEvent.getSource() instanceof JSpinner && !this.isAdjusting) {
            int n = (Integer)this.redSpinner.getValue();
            int n5 = (Integer)this.greenSpinner.getValue();
            int n6 = (Integer)this.blueSpinner.getValue();
            int n7 = (Integer)this.alphaSpinner.getValue();
            Color color = new Color(n, n5, n6, n7);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

