/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.Text3DData;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JTextField;

public class TrajectoryTextAssignPanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    private JTextField sizeText;
    private JTextField xText;
    private JTextField yText;
    private MyComboBox fontComboBox;
    private MyComboBox styleComboBox;
    private MyButton colorButton;
    private Color color = Color.red;
    private final String[] styleList = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private final int[] styleId = new int[]{0, 1, 2, 3};
    private String[] fontList;

    public TrajectoryTextAssignPanel(AbinitMpViewer abinitMpViewer) {
        this.viewer = abinitMpViewer;
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FlowLayout flowLayout = new FlowLayout(0);
        this.sizeText = new JTextField("100");
        this.sizeText.setPreferredSize(new Dimension(70, 28));
        this.xText = new JTextField("70.00");
        this.xText.setPreferredSize(new Dimension(50, 28));
        this.yText = new JTextField("95.00");
        this.yText.setPreferredSize(new Dimension(50, 28));
        this.fontComboBox = new MyComboBox(this.fontList);
        this.styleComboBox = new MyComboBox(this.styleList);
        this.colorButton = new MyButton();
        this.colorButton.setPreferredSize(new Dimension(50, 28));
        this.colorButton.setBackground(this.color);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("apply"));
        this.colorButton.addActionListener(new colorListener());
        myButton.addActionListener(new applyListener());
        int n = 0;
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.font")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.fontComboBox, 5, n, 10, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.style")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.styleComboBox, 5, n, 10, 1, 1.0, 0.0);
        MyPanel myPanel = new MyPanel(flowLayout);
        myPanel.add(this.sizeText);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.size")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(this.colorButton);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.color")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        ++n;
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.x")));
        myPanel.add(this.xText);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.y")));
        myPanel.add(this.yText);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TrajectoryTextAssignPanel.position")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        myPanel = new MyPanel();
        myPanel.add(myButton);
        this.layoutObject(myPanel, 0, ++n, 0, 1, 1.0, 0.0);
        Text3DData text3DData = new Text3DData();
        text3DData.x = 80.0f;
        abinitMpViewer.setTrajectoryTex3DtData(text3DData);
    }

    class colorListener
    extends AbstractAction {
        colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            if ((TrajectoryTextAssignPanel.this.color = JColorChooser.showDialog(myButton, "Color", TrajectoryTextAssignPanel.this.color)) != null) {
                myButton.setBackground(TrajectoryTextAssignPanel.this.color);
            }
        }
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Text3DData text3DData = new Text3DData();
            text3DData.font = (String)TrajectoryTextAssignPanel.this.fontComboBox.getSelectedItem();
            text3DData.style = TrajectoryTextAssignPanel.this.styleId[TrajectoryTextAssignPanel.this.styleComboBox.getSelectedIndex()];
            text3DData.size = Integer.parseInt(TrajectoryTextAssignPanel.this.sizeText.getText());
            text3DData.color = new Color(TrajectoryTextAssignPanel.this.color.getRGB());
            text3DData.x = Float.parseFloat(TrajectoryTextAssignPanel.this.xText.getText());
            text3DData.y = Float.parseFloat(TrajectoryTextAssignPanel.this.yText.getText());
            TrajectoryTextAssignPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            TrajectoryTextAssignPanel.this.viewer.createTrajectoryText(text3DData);
            TrajectoryTextAssignPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

